/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.TriggerEditorComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TriggerEditorDialog
implements SelectionListener {
    private transient Shell shell = null;
    private transient Button btnAccept = null;
    private transient Button btnCancel = null;
    private transient EList triggers = null;
    private transient Collection vOriginalTriggers = null;
    private transient TriggerEditorComposite triggereditor = null;
    private transient ChartWizardContext wizardContext;
    private transient boolean bEnableURLParameters;
    private transient boolean bEnableShowTooltipValue;

    public TriggerEditorDialog(Shell shellParent, EList triggers, ChartWizardContext wizardContext, String sTitle, boolean bEnableURLParameters, boolean bEnableShowTooltipValue) {
        this.triggers = triggers;
        this.wizardContext = wizardContext;
        this.bEnableURLParameters = bEnableURLParameters;
        this.bEnableShowTooltipValue = bEnableShowTooltipValue;
        this.vOriginalTriggers = EcoreUtil.copyAll((Collection)triggers);
        this.shell = new Shell(shellParent, 67696);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.shell.setLayout((Layout)new FillLayout());
        ChartUIUtil.bindHelp((Control)this.shell, (String)"org.eclipse.birt.chart.cshelp.Interactivity_ID");
        this.placeComponents();
        this.shell.setText(new MessageFormat(Messages.getString("TriggerEditorDialog.Title.TriggerEditor")).format(new Object[]{sTitle}));
        this.shell.pack();
        this.shell.setDefaultButton(this.btnAccept);
        UIHelper.centerOnScreen((Shell)this.shell);
        this.shell.layout();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout();
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        glContent.verticalSpacing = 5;
        Composite cmpContent = new Composite((Composite)this.shell, 0);
        cmpContent.setLayout((Layout)glContent);
        this.triggereditor = new TriggerEditorComposite(cmpContent, 0, this.triggers, this.wizardContext, this.bEnableURLParameters, this.bEnableShowTooltipValue);
        GridData gdTriggerEditor = new GridData(768);
        this.triggereditor.setLayoutData(gdTriggerEditor);
        GridLayout glButtons = new GridLayout();
        glButtons.numColumns = 2;
        glButtons.horizontalSpacing = 5;
        Composite cmpButtons = new Composite(cmpContent, 0);
        GridData gdButtons = new GridData(768);
        cmpButtons.setLayoutData((Object)gdButtons);
        cmpButtons.setLayout((Layout)glButtons);
        this.btnAccept = new Button(cmpButtons, 8);
        GridData gdBTNAccept = new GridData(128);
        gdBTNAccept.grabExcessHorizontalSpace = true;
        this.btnAccept.setLayoutData((Object)gdBTNAccept);
        this.btnAccept.setText(Messages.getString("Shared.Lbl.OK"));
        this.btnAccept.addSelectionListener((SelectionListener)this);
        this.btnCancel = new Button(cmpButtons, 8);
        GridData gdBTNCancel = new GridData(128);
        gdBTNCancel.grabExcessHorizontalSpace = false;
        this.btnCancel.setLayoutData((Object)gdBTNCancel);
        this.btnCancel.setText(Messages.getString("Shared.Lbl.Cancel"));
        this.btnCancel.addSelectionListener((SelectionListener)this);
    }

    public EList getTriggers() {
        return this.triggers;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.btnAccept)) {
            this.shell.dispose();
        } else if (e.getSource().equals(this.btnCancel)) {
            this.triggers.clear();
            this.triggers.addAll(this.vOriginalTriggers);
            this.shell.dispose();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

