/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.series;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.RiserType;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class BarSeriesAttributeComposite
extends Composite
implements SelectionListener,
Listener {
    Composite cmpContent = null;
    Combo cmbRiserTypes = null;
    FillChooserComposite fccRiserOutline = null;
    Series series = null;
    ChartWizardContext context;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.series");

    public BarSeriesAttributeComposite(Composite parent, int style, ChartWizardContext context, Series series) {
        super(parent, style);
        if (!(series instanceof BarSeries)) {
            try {
                throw new ChartException("org.eclipse.birt.chart.ui.extension", 20, "BarSeriesAttributeComposite.Exception.IllegalArgument", new Object[]{series.getClass().getName()}, Messages.getResourceBundle());
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
                e.printStackTrace();
            }
        }
        this.series = series;
        this.context = context;
        this.init();
        this.placeComponents();
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatBarChartYSeries_ID");
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.marginHeight = 2;
        glContent.marginWidth = 2;
        this.setLayout((Layout)glContent);
        Label lblRiserType = new Label((Composite)this, 0);
        GridData gdLBLRiserType = new GridData();
        lblRiserType.setLayoutData((Object)gdLBLRiserType);
        lblRiserType.setText(Messages.getString("BarSeriesAttributeComposite.Lbl.RiserType"));
        this.cmbRiserTypes = new Combo((Composite)this, 12);
        GridData gdCMBRiserTypes = new GridData(768);
        this.cmbRiserTypes.setLayoutData((Object)gdCMBRiserTypes);
        this.cmbRiserTypes.addSelectionListener((SelectionListener)this);
        Label lblRiserOutline = new Label((Composite)this, 0);
        GridData gdLBLRiserOutline = new GridData();
        lblRiserOutline.setLayoutData((Object)gdLBLRiserOutline);
        lblRiserOutline.setText(Messages.getString("BarSeriesAttributeComposite.Lbl.RiserOutline"));
        this.fccRiserOutline = new FillChooserComposite(this, 0, this.context, (Fill)((BarSeries)this.series).getRiserOutline(), false, false, true, true);
        GridData gdFCCRiserOutline = new GridData(768);
        this.fccRiserOutline.setLayoutData(gdFCCRiserOutline);
        this.fccRiserOutline.addListener(this);
        this.populateLists();
    }

    private void populateLists() {
        NameSet ns = LiteralHelper.riserTypeSet;
        this.cmbRiserTypes.setItems(ns.getDisplayNames());
        this.cmbRiserTypes.select(ns.getSafeNameIndex(((BarSeries)this.series).getRiser().getName()));
    }

    public Point getPreferredSize() {
        return new Point(400, 200);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.cmbRiserTypes)) {
            ((BarSeries)this.series).setRiser(RiserType.getByName((String)LiteralHelper.riserTypeSet.getNameByDisplayName(this.cmbRiserTypes.getText())));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.fccRiserOutline) && event.type == 1) {
            ((BarSeries)this.series).setRiserOutline((ColorDefinition)event.data);
        }
    }
}

