/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.series;

import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FormatSpecifierDialog;
import org.eclipse.birt.chart.ui.swt.composites.LabelAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class DialLabelSheet
extends AbstractPopupSheet
implements Listener,
SelectionListener {
    private transient Composite cmpContent = null;
    private transient LabelAttributesComposite lacTitle = null;
    private transient Button btnFormatSpecifier;
    private transient SeriesDefinition seriesDefn = null;

    public DialLabelSheet(String title, ChartWizardContext context, SeriesDefinition seriesDefn) {
        super(title, context, false);
        this.seriesDefn = seriesDefn;
    }

    protected Composite getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.DataPointLabels_ID");
        GridLayout glContent = new GridLayout(2, false);
        glContent.verticalSpacing = 0;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        this.cmpContent = new Composite(parent, 0);
        this.cmpContent.setLayout((Layout)glContent);
        org.eclipse.swt.widgets.Label label = new org.eclipse.swt.widgets.Label(this.cmpContent, 0);
        GridData gd = new GridData();
        gd.horizontalIndent = 10;
        label.setLayoutData((Object)gd);
        label.setText(Messages.getString("DialLabelSheet.Label.Format"));
        this.btnFormatSpecifier = new Button(this.cmpContent, 8);
        gd = new GridData();
        gd.horizontalIndent = 25;
        gd.widthHint = 20;
        gd.heightHint = 20;
        this.btnFormatSpecifier.setLayoutData((Object)gd);
        this.btnFormatSpecifier.setToolTipText(Messages.getString("BaseDataDefinitionComponent.Text.EditFormat"));
        this.btnFormatSpecifier.setImage(UIHelper.getImage((String)"icons/obj16/formatbuilder.gif"));
        this.btnFormatSpecifier.getImage().setBackground(this.btnFormatSpecifier.getBackground());
        this.btnFormatSpecifier.addSelectionListener((SelectionListener)this);
        this.lacTitle = new LabelAttributesComposite(this.cmpContent, 0, null, this.getSeriesForProcessing().getDial().getLabel(), this.getChart().getUnits(), false, true, this.getContext(), true, true, false);
        GridData gdLACTitle = new GridData(768);
        gdLACTitle.horizontalSpan = 2;
        this.lacTitle.setLayoutData(gdLACTitle);
        this.lacTitle.addListener(this);
        return this.cmpContent;
    }

    private DialSeries getSeriesForProcessing() {
        return (DialSeries)this.seriesDefn.getDesignTimeSeries();
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.lacTitle)) {
            switch (event.type) {
                case 1: {
                    this.getLabel().setVisible(((Boolean)event.data).booleanValue());
                    break;
                }
                case 3: {
                    this.getLabel().getCaption().setFont((FontDefinition)((Object[])event.data)[0]);
                    this.getLabel().getCaption().setColor((ColorDefinition)((Object[])event.data)[1]);
                    break;
                }
                case 4: {
                    this.getLabel().setBackground((Fill)event.data);
                    break;
                }
                case 5: {
                    this.getLabel().setShadowColor((ColorDefinition)event.data);
                    break;
                }
                case 6: {
                    this.getLabel().getOutline().setStyle((LineStyle)event.data);
                    break;
                }
                case 7: {
                    this.getLabel().getOutline().setThickness(((Integer)event.data).intValue());
                    break;
                }
                case 8: {
                    this.getLabel().getOutline().setColor((ColorDefinition)event.data);
                    break;
                }
                case 9: {
                    this.getLabel().getOutline().setVisible(((Boolean)event.data).booleanValue());
                    break;
                }
                case 10: {
                    this.getLabel().setInsets((Insets)event.data);
                }
            }
        }
    }

    private Label getLabel() {
        return this.getSeriesForProcessing().getDial().getLabel();
    }

    public void widgetSelected(SelectionEvent e) {
        FormatSpecifierDialog editor;
        if (e.getSource().equals(this.btnFormatSpecifier) && !(editor = new FormatSpecifierDialog(this.cmpContent.getShell(), this.getSeriesForProcessing().getDial().getFormatSpecifier(), Messages.getString("BaseDataDefinitionComponent.Text.EditFormat"))).wasCancelled()) {
            this.getSeriesForProcessing().getDial().setFormatSpecifier(editor.getFormatSpecifier());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

