/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.series;

import java.util.List;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.DataPackage;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.ExternalizedTextEditorComposite;
import org.eclipse.birt.chart.ui.swt.composites.LocalizedNumberEditorComposite;
import org.eclipse.birt.chart.ui.swt.composites.SeriesGroupingComposite;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.SeriesPaletteSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class SeriesXSheetImpl
extends SubtaskSheetImpl
implements Listener,
ModifyListener,
SelectionListener {
    private transient Combo cmbSorting = null;
    private static final String UNSORTED_OPTION = Messages.getString("BaseSeriesDataSheetImpl.Choice.Unsorted");
    private transient Label lblMinSlice;
    private transient Label lblBottomPercent;
    private transient Label lblLabel;
    private transient Combo cmbMinSlice;
    private transient LocalizedNumberEditorComposite txtMinSlice;
    private transient ExternalizedTextEditorComposite txtLabel = null;
    private static final String TOOLTIP_MINIMUM_SLICE = Messages.getString("PieBottomAreaComponent.Label.AnySliceWithASize");
    private static final String[] MINMUM_SLICE_ITEMS = new String[]{Messages.getString("PieBottomAreaComponent.Label.Percentage"), Messages.getString("PieBottomAreaComponent.Label.Value")};

    public void getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatChartXSeries_ID");
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout(2, false);
        this.cmpContent.setLayout((Layout)glContent);
        GridData gd = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd);
        Composite cmpBasic = new Composite(this.cmpContent, 0);
        cmpBasic.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData(768);
        cmpBasic.setLayoutData((Object)gd);
        if (this.getChart() instanceof ChartWithoutAxes && !(this.getChart() instanceof DialChart)) {
            this.createPieAxisArea(cmpBasic);
        }
        Label lblSorting = new Label(cmpBasic, 0);
        lblSorting.setText(Messages.getString("BaseSeriesDataSheetImpl.Lbl.DataSorting"));
        this.cmbSorting = new Combo(cmpBasic, 12);
        GridData gdCMBSorting = new GridData(768);
        this.cmbSorting.setLayoutData((Object)gdCMBSorting);
        this.cmbSorting.addSelectionListener((SelectionListener)this);
        Composite cmpGrouping = new Composite(cmpBasic, 0);
        GridData gdCMPGrouping = new GridData(768);
        gdCMPGrouping.horizontalSpan = 2;
        cmpGrouping.setLayoutData((Object)gdCMPGrouping);
        cmpGrouping.setLayout((Layout)new FillLayout());
        new SeriesGroupingComposite(cmpGrouping, 0, this.getSeriesDefinitionForProcessing(), this.getChart() instanceof ChartWithoutAxes);
        this.createButtonGroup(this.cmpContent);
        this.populateLists();
    }

    private void createButtonGroup(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 0x1000008;
        cmp.setLayoutData((Object)gridData);
        SeriesPaletteSheet popup = new SeriesPaletteSheet(Messages.getString("SeriesXSheetImpl.Label.SeriesPalette"), this.getContext(), this.getSeriesDefinitionForProcessing());
        Button btnSeriesPal = this.createToggleButton(cmp, Messages.getString("SeriesXSheetImpl.Label.SeriesPalette&"), popup);
        btnSeriesPal.addSelectionListener((SelectionListener)this);
    }

    private void createPieAxisArea(Composite parent) {
        this.lblMinSlice = new Label(parent, 0);
        this.lblMinSlice.setText(Messages.getString("PieBottomAreaComponent.Label.MinimumSlice"));
        this.lblMinSlice.setToolTipText(TOOLTIP_MINIMUM_SLICE);
        Composite cmpMinSlice = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        cmpMinSlice.setLayout((Layout)gridLayout);
        cmpMinSlice.setLayoutData((Object)new GridData(768));
        this.cmbMinSlice = new Combo(cmpMinSlice, 12);
        this.cmbMinSlice.setToolTipText(TOOLTIP_MINIMUM_SLICE);
        this.cmbMinSlice.setItems(MINMUM_SLICE_ITEMS);
        this.cmbMinSlice.setText(((ChartWithoutAxes)this.getChart()).isMinSlicePercent() ? MINMUM_SLICE_ITEMS[0] : MINMUM_SLICE_ITEMS[1]);
        this.cmbMinSlice.addSelectionListener((SelectionListener)this);
        this.txtMinSlice = new LocalizedNumberEditorComposite(cmpMinSlice, 2048);
        GridData gridData = new GridData(768);
        this.txtMinSlice.setLayoutData(gridData);
        this.txtMinSlice.setToolTipText(TOOLTIP_MINIMUM_SLICE);
        this.txtMinSlice.setValue(((ChartWithoutAxes)this.getChart()).getMinSlice());
        this.txtMinSlice.addModifyListener(this);
        this.lblBottomPercent = new Label(cmpMinSlice, 0);
        this.lblBottomPercent.setText("%");
        this.lblBottomPercent.setVisible(((ChartWithoutAxes)this.getChart()).isMinSlicePercent());
        this.lblLabel = new Label(parent, 0);
        this.lblLabel.setText(Messages.getString("PieBottomAreaComponent.Label.MinSliceLabel"));
        this.lblLabel.setToolTipText(TOOLTIP_MINIMUM_SLICE);
        List keys = null;
        if (this.getContext().getUIServiceProvider() != null) {
            keys = this.getContext().getUIServiceProvider().getRegisteredKeys();
        }
        this.txtLabel = new ExternalizedTextEditorComposite(parent, 2048, -1, -1, keys, this.getContext().getUIServiceProvider(), ((ChartWithoutAxes)this.getChart()).getMinSliceLabel() != null ? ((ChartWithoutAxes)this.getChart()).getMinSliceLabel() : "");
        GridData gdTXTTitle = new GridData(768);
        this.txtLabel.setLayoutData(gdTXTTitle);
        this.txtLabel.setEnabled(((ChartWithoutAxes)this.getChart()).getMinSlice() != 0.0);
        this.txtLabel.addListener(this);
    }

    private void populateLists() {
        this.cmbSorting.add(UNSORTED_OPTION);
        String[] nss = LiteralHelper.sortOptionSet.getDisplayNames();
        for (int i = 0; i < nss.length; ++i) {
            this.cmbSorting.add(nss[i]);
        }
        if (!this.getSeriesDefinitionForProcessing().eIsSet((EStructuralFeature)DataPackage.eINSTANCE.getSeriesDefinition_Sorting())) {
            this.cmbSorting.select(0);
        } else {
            this.cmbSorting.select(LiteralHelper.sortOptionSet.getNameIndex(this.getSeriesDefinitionForProcessing().getSorting().getName()) + 1);
        }
    }

    private SeriesDefinition getSeriesDefinitionForProcessing() {
        SeriesDefinition sd = null;
        if (this.getChart() instanceof ChartWithAxes) {
            sd = (SeriesDefinition)((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getSeriesDefinitions().get(this.getIndex());
        } else if (this.getChart() instanceof ChartWithoutAxes) {
            sd = (SeriesDefinition)((ChartWithoutAxes)this.getChart()).getSeriesDefinitions().get(this.getIndex());
        }
        return sd;
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource() == this.txtMinSlice) {
            ((ChartWithoutAxes)this.getChart()).setMinSlice(this.txtMinSlice.getValue());
            this.txtLabel.setEnabled(((ChartWithoutAxes)this.getChart()).getMinSlice() != 0.0);
        }
    }

    public void handleEvent(Event event) {
        if (this.getChart() instanceof ChartWithoutAxes && event.widget.equals((Object)this.txtLabel)) {
            ((ChartWithoutAxes)this.getChart()).setMinSliceLabel(this.txtLabel.getText());
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.detachPopup(e.widget)) {
            return;
        }
        if (this.isRegistered(e.widget)) {
            this.attachPopup(((Button)e.widget).getText());
        }
        if (e.getSource().equals(this.cmbSorting)) {
            if (this.cmbSorting.getText().equals(UNSORTED_OPTION)) {
                this.getSeriesDefinitionForProcessing().eUnset((EStructuralFeature)DataPackage.eINSTANCE.getSeriesDefinition_Sorting());
            } else {
                this.getSeriesDefinitionForProcessing().setSorting(SortOption.getByName((String)LiteralHelper.sortOptionSet.getNameByDisplayName(this.cmbSorting.getText())));
            }
        }
        if (this.getChart() instanceof ChartWithoutAxes && e.widget.equals(this.cmbMinSlice)) {
            ((ChartWithoutAxes)this.getChart()).setMinSlicePercent(this.cmbMinSlice.getSelectionIndex() == 0);
            this.lblBottomPercent.setVisible(((ChartWithoutAxes)this.getChart()).isMinSlicePercent());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

