/***********************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Actuate Corporation - initial API and implementation
 ***********************************************************************/

package org.eclipse.birt.chart.examples.api.data;

/**
 * Presents a pie chart with min slice, which could be acheived via SQL.
 * 
 */
import java.io.IOException;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;

import com.ibm.icu.util.ULocale;

public class MinSliceOld
{

	/**
	 * execute application
	 * 
	 * @param args
	 */
	public static void main( String[] args )
	{
		new MinSliceOld( ).pieMinSlice( );

	}

	/**
	 * Get the chart instance from the design file and set min slice.
	 * 
	 * @return An instance of the simulated runtime chart model (containing
	 *         filled datasets)
	 */
	void pieMinSlice( )
	{
		SessionHandle sessionHandle = new DesignEngine( null ).newSessionHandle( (ULocale) null );
		ReportDesignHandle designHandle = null;

		String path = "src/org/eclipse/birt/chart/examples/api/data/";//$NON-NLS-1$

		try
		{
			designHandle = sessionHandle.openDesign( path
					+ "NonMinSlice.rptdesign" );//$NON-NLS-1$
		}
		catch ( DesignFileException e )
		{
			// TODO Auto-generated catch block
			e.printStackTrace( );
		}

		OdaDataSetHandle dataSet = (OdaDataSetHandle) designHandle
				.getDataSets( ).get( 0 );
		String query = dataSet
				.getQueryText( )
				.concat(
						"\nhaving SUM(CLASSICMODELS.ORDERDETAILS.QUANTITYORDERED) > 7000\n"//$NON-NLS-1$
								+ "union\n"//$NON-NLS-1$
								+ "select (MIN(CLASSICMODELS.ORDERDETAILS.ORDERLINENUMBER)-MIN(CLASSICMODELS.ORDERDETAILS.ORDERLINENUMBER)) as ORDERLINENUMBER,\n"//$NON-NLS-1$
								+ "SUM(CLASSICMODELS.ORDERDETAILS.QUANTITYORDERED) as TotalQuantities\n"//$NON-NLS-1$
								+ "from CLASSICMODELS.ORDERDETAILS\n"//$NON-NLS-1$
								+ "where CLASSICMODELS.ORDERDETAILS.ORDERLINENUMBER in\n"//$NON-NLS-1$
								+ "(select CLASSICMODELS.ORDERDETAILS.ORDERLINENUMBER\n"//$NON-NLS-1$
								+ "from CLASSICMODELS.ORDERDETAILS\n"//$NON-NLS-1$
								+ "group by CLASSICMODELS.ORDERDETAILS.ORDERLINENUMBER\n"//$NON-NLS-1$
								+ "having SUM(CLASSICMODELS.ORDERDETAILS.QUANTITYORDERED)<=7000)"//$NON-NLS-1$
				);
		try
		{
			dataSet.setQueryText( query );
		}
		catch ( SemanticException e )
		{
			e.printStackTrace( );
		}

		ExtendedItemHandle eih = (ExtendedItemHandle) designHandle.getBody( )
				.getContents( ).get( 0 );

		ChartReportItemImpl crii = null;
		try
		{
			crii = (ChartReportItemImpl) eih.getReportItem( );
		}
		catch ( ExtendedElementException e )
		{
			// TODO Auto-generated catch block
			e.printStackTrace( );
		}

		Chart cm = (Chart) crii.getProperty( "chart.instance" ); //$NON-NLS-1$	    
		cm.getTitle( ).getLabel( ).getCaption( ).setValue( "MinSlice" );//$NON-NLS-1$

		try
		{
			designHandle.saveAs( path + "MinSlice.rptdesign" );//$NON-NLS-1$
		}
		catch ( IOException e )
		{
			e.printStackTrace( );
		}
	}
}
