/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.DocumentProvider;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;

public class FileReportDocumentProvider
extends DocumentProvider {
    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        File file = new File(moduleHandle.getFileName());
        if (file.exists()) {
            try {
                FileInputStream stream = new FileInputStream(file);
                this.setDocumentContent(document, stream, encoding);
                ((InputStream)stream).close();
                return true;
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return false;
    }

    protected String getPersistedEncoding(Object element) {
        if (element instanceof IEncodedStorage) {
            try {
                if (element instanceof IEncodedStorage) {
                    return ((IEncodedStorage)element).getCharset();
                }
            }
            catch (CoreException e) {
                return null;
            }
        }
        return null;
    }

    public boolean isModifiable(Object element) {
        return !this.isReadOnly(element);
    }

    public boolean isReadOnly(Object element) {
        if (element instanceof IPathEditorInput) {
            File file = ((IPathEditorInput)element).getPath().toFile();
            return !file.canWrite();
        }
        return super.isReadOnly(element);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element instanceof IPathEditorInput) {
            byte[] bytes = document.get().getBytes();
            IPathEditorInput input = (IPathEditorInput)element;
            File file = input.getPath().toFile();
            try {
                int length;
                FileOutputStream out = new FileOutputStream(file);
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                byte[] read = new byte[64];
                while ((length = in.read(read)) != -1) {
                    ((OutputStream)out).write(read, 0, length);
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

