/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.FileReportDocumentProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportEditorInput;
import org.eclipse.birt.report.designer.internal.ui.editors.wizards.SaveReportAsWizard;
import org.eclipse.birt.report.designer.internal.ui.editors.wizards.SaveReportAsWizardDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class FileReportProvider
implements IReportProvider {
    private ModuleHandle model;
    private static final String VERSION_MESSAGE = Messages.getString((String)"TextPropertyDescriptor.Message.Version");

    public ModuleHandle getReportModuleHandle(Object element) {
        return this.getReportModuleHandle(element, false);
    }

    public ModuleHandle getReportModuleHandle(Object element, boolean reset) {
        IPath path;
        if ((this.model == null && element instanceof IPathEditorInput || reset) && (path = ((IPathEditorInput)element).getPath()) != null) {
            String fileName = path.toOSString();
            try {
                FileInputStream stream = new FileInputStream(path.toFile());
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("createdBy", MessageFormat.format(VERSION_MESSAGE, ReportPlugin.getVersion(), ReportPlugin.getBuildInfo()));
                this.model = SessionHandleAdapter.getInstance().init(fileName, (InputStream)stream, properties);
            }
            catch (DesignFileException e) {
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return this.model;
    }

    public void saveReport(ModuleHandle moduleHandle, Object element, IProgressMonitor monitor) {
        if (element instanceof IPathEditorInput) {
            IPathEditorInput input = (IPathEditorInput)element;
            this.saveFile(moduleHandle, input.getPath().toFile(), monitor);
        }
    }

    private void saveFile(final ModuleHandle moduleHandle, final File file, IProgressMonitor monitor) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public final synchronized void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run(IProgressMonitor pm) throws CoreException {
                            try {
                                this.this$1.execute(pm);
                            }
                            catch (CoreException e) {
                                throw e;
                            }
                            catch (IOException e) {
                                ExceptionHandler.handle((Throwable)e);
                            }
                        }
                    };
                    ResourcesPlugin.getWorkspace().run(workspaceRunnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 0, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException(e.getMessage());
                }
            }

            public void execute(IProgressMonitor monitor) throws CoreException, IOException {
                if (file.exists() || file.createNewFile()) {
                    FileOutputStream out = new FileOutputStream(file);
                    moduleHandle.serialize((OutputStream)out);
                    out.close();
                }
            }
        };
        try {
            new ProgressMonitorDialog(UIUtil.getDefaultShell()).run(false, true, op);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public IPath getSaveAsPath(Object element) {
        if (element instanceof IPathEditorInput) {
            IEditorInput input = (IEditorInput)element;
            SaveReportAsWizardDialog dialog = new SaveReportAsWizardDialog(UIUtil.getDefaultShell(), (IWizard)new SaveReportAsWizard(this.model, input));
            if (dialog.open() == 0) {
                return dialog.getResult();
            }
        }
        return null;
    }

    public IEditorInput createNewEditorInput(IPath path) {
        File file = new File(path.toOSString());
        try {
            if (file.exists() || file.createNewFile()) {
                return new ReportEditorInput(file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public IPath getInputPath(IEditorInput input) {
        if (input instanceof IPathEditorInput) {
            return ((IPathEditorInput)input).getPath();
        }
        return null;
    }

    public IDocumentProvider getReportDocumentProvider(Object element) {
        return new FileReportDocumentProvider();
    }

    public void connect(ModuleHandle handle) {
        this.model = handle;
    }
}

