/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.extension;

import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.ui.editors.IReportEditorPage;
import org.eclipse.birt.report.designer.ui.editors.actions.PageSetAction;
import org.eclipse.birt.report.designer.ui.editors.extension.IExtensionConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;

public class FormPageDef
implements IExtensionConstants {
    private IConfigurationElement element;
    public String id;
    public String targetEditor;
    public String displayName;
    public String pageClass;
    public boolean visible = true;
    public String relative;
    public int position;
    public IAction pageAction;

    FormPageDef(IConfigurationElement element) {
        this.element = element;
        this.id = this.loadStringAttribute(element, "id");
        this.displayName = this.loadStringAttribute(element, "displayName");
        this.pageClass = this.loadStringAttribute(element, "class");
        this.visible = this.loadBooleanAttribute(element, "visible");
        this.relative = this.loadStringAttribute(element, "relative");
        this.position = this.loadPosition(element, "position");
        if (this.loadStringAttribute(element, "pageAction") != null) {
            this.pageAction = (IAction)this.loadClass(element, "pageAction");
        }
        if (this.pageAction == null) {
            this.pageAction = new PageSetAction(this.displayName, this.id);
        }
    }

    private int loadPosition(IConfigurationElement element, String attributeName) {
        String attribute = element.getAttribute(attributeName);
        if ("left".equals(attribute)) {
            return 0;
        }
        if ("right".equals(attribute)) {
            return 1;
        }
        return 0;
    }

    private String loadStringAttribute(IConfigurationElement element, String attributeName) {
        return element.getAttribute(attributeName);
    }

    private boolean loadBooleanAttribute(IConfigurationElement element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    private Object loadClass(IConfigurationElement element, String attributeName) {
        Object clazz = null;
        try {
            clazz = element.createExecutableExtension(attributeName);
        }
        catch (CoreException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return clazz;
    }

    public IReportEditorPage createPage() {
        Object def = this.loadClass(this.element, "class");
        if (def instanceof IReportEditorPage) {
            return (IReportEditorPage)def;
        }
        return null;
    }
}

