/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedQualifiedTypeReference
extends ArrayQualifiedTypeReference {
    public TypeReference[][] typeArguments;
    private boolean didResolve = false;

    public ParameterizedQualifiedTypeReference(char[][] tokens, TypeReference[][] typeArguments, int dim, long[] positions) {
        super(tokens, dim, positions);
        this.typeArguments = typeArguments;
    }

    public void checkBounds(Scope scope) {
        if (this.resolvedType == null) {
            return;
        }
        this.checkBounds((ReferenceBinding)this.resolvedType.leafComponentType(), scope, this.typeArguments.length - 1);
    }

    public void checkBounds(ReferenceBinding type, Scope scope, int index) {
        if (index > 0 && type.enclosingType() != null) {
            this.checkBounds(type.enclosingType(), scope, index - 1);
        }
        if (type.isParameterizedType()) {
            ParameterizedTypeBinding parameterizedType = (ParameterizedTypeBinding)type;
            ReferenceBinding currentType = parameterizedType.type;
            TypeVariableBinding[] typeVariables = currentType.typeVariables();
            TypeBinding[] argTypes = parameterizedType.arguments;
            if (argTypes != null && typeVariables != null) {
                parameterizedType.boundCheck(scope, this.typeArguments[index]);
            }
        }
    }

    public TypeReference copyDims(int dim) {
        return new ParameterizedQualifiedTypeReference(this.tokens, this.typeArguments, dim, this.sourcePositions);
    }

    public char[][] getParameterizedTypeName() {
        int length = this.tokens.length;
        char[][] qParamName = new char[length][];
        int i = 0;
        while (i < length) {
            TypeReference[] arguments = this.typeArguments[i];
            if (arguments == null) {
                qParamName[i] = this.tokens[i];
            } else {
                StringBuffer buffer = new StringBuffer(5);
                buffer.append(this.tokens[i]);
                buffer.append('<');
                int j = 0;
                int argLength = arguments.length;
                while (j < argLength) {
                    if (j > 0) {
                        buffer.append(',');
                    }
                    buffer.append(CharOperation.concatWith(arguments[j].getParameterizedTypeName(), '.'));
                    ++j;
                }
                buffer.append('>');
                int nameLength = buffer.length();
                qParamName[i] = new char[nameLength];
                buffer.getChars(0, nameLength, qParamName[i], 0);
            }
            ++i;
        }
        int dim = this.dimensions;
        if (dim > 0) {
            char[] dimChars = new char[dim * 2];
            int i2 = 0;
            while (i2 < dim) {
                int index = i2 * 2;
                dimChars[index] = 91;
                dimChars[index + 1] = 93;
                ++i2;
            }
            qParamName[length - 1] = CharOperation.concat(qParamName[length - 1], dimChars);
        }
        return qParamName;
    }

    protected TypeBinding getTypeBinding(Scope scope) {
        return null;
    }

    private TypeBinding internalResolveType(Scope scope, boolean checkBounds) {
        this.constant = Constant.NotAConstant;
        if (this.didResolve) {
            if (this.resolvedType != null && !this.resolvedType.isValidBinding()) {
                return null;
            }
            return this.resolvedType;
        }
        this.didResolve = true;
        Binding binding = scope.getPackage(this.tokens);
        if (binding != null && !binding.isValidBinding()) {
            this.resolvedType = (ReferenceBinding)binding;
            this.reportInvalidType(scope);
            return null;
        }
        PackageBinding packageBinding = binding == null ? null : (PackageBinding)binding;
        boolean isClassScope = scope.kind == 3;
        boolean typeIsConsistent = true;
        ReferenceBinding qualifiedType = null;
        int i = packageBinding == null ? 0 : packageBinding.compoundName.length;
        int max = this.tokens.length;
        while (i < max) {
            TypeReference[] args;
            this.findNextTypeBinding(i, scope, packageBinding);
            if (!this.resolvedType.isValidBinding()) {
                this.reportInvalidType(scope);
                return null;
            }
            ReferenceBinding currentType = (ReferenceBinding)this.resolvedType;
            if (qualifiedType == null && (qualifiedType = currentType.enclosingType()) != null && (qualifiedType.isGenericType() || qualifiedType.isParameterizedType())) {
                ReferenceBinding referenceBinding = qualifiedType = currentType.isStatic() ? (ReferenceBinding)scope.environment().convertToRawType(qualifiedType) : scope.environment().convertToParameterizedType(qualifiedType);
            }
            if (typeIsConsistent && currentType.isStatic() && qualifiedType != null && (qualifiedType.isParameterizedType() || qualifiedType.isGenericType())) {
                scope.problemReporter().staticMemberOfParameterizedType(this, scope.environment().createParameterizedType((ReferenceBinding)currentType.erasure(), null, qualifiedType));
                typeIsConsistent = false;
            }
            if ((args = this.typeArguments[i]) != null) {
                TypeVariableBinding[] typeVariables;
                TypeReference keep = null;
                if (isClassScope) {
                    keep = ((ClassScope)scope).superTypeReference;
                    ((ClassScope)scope).superTypeReference = null;
                }
                int argLength = args.length;
                TypeBinding[] argTypes = new TypeBinding[argLength];
                boolean argHasError = false;
                int j = 0;
                while (j < argLength) {
                    TypeBinding argType;
                    TypeReference arg = args[j];
                    TypeBinding typeBinding = argType = isClassScope ? arg.resolveTypeArgument((ClassScope)scope, currentType, j) : arg.resolveTypeArgument((BlockScope)scope, currentType, j);
                    if (argType == null) {
                        argHasError = true;
                    } else {
                        argTypes[j] = argType;
                    }
                    ++j;
                }
                if (argHasError) {
                    return null;
                }
                if (isClassScope) {
                    ((ClassScope)scope).superTypeReference = keep;
                    if (((ClassScope)scope).detectHierarchyCycle(currentType, this, argTypes)) {
                        return null;
                    }
                }
                if ((typeVariables = currentType.typeVariables()) == Binding.NO_TYPE_VARIABLES) {
                    scope.problemReporter().nonGenericTypeCannotBeParameterized(this, currentType, argTypes);
                    return null;
                }
                if (argLength != typeVariables.length) {
                    scope.problemReporter().incorrectArityForParameterizedType(this, currentType, argTypes);
                    return null;
                }
                if (typeIsConsistent && !currentType.isStatic() && qualifiedType != null && qualifiedType.isRawType()) {
                    scope.problemReporter().rawMemberTypeCannotBeParameterized(this, scope.environment().createRawType((ReferenceBinding)currentType.erasure(), qualifiedType), argTypes);
                    typeIsConsistent = false;
                }
                ParameterizedTypeBinding parameterizedType = scope.environment().createParameterizedType((ReferenceBinding)currentType.erasure(), argTypes, qualifiedType);
                if (checkBounds) {
                    parameterizedType.boundCheck(scope, args);
                }
                qualifiedType = parameterizedType;
            } else {
                if (isClassScope && ((ClassScope)scope).detectHierarchyCycle(currentType, this, null)) {
                    return null;
                }
                ReferenceBinding currentErasure = (ReferenceBinding)currentType.erasure();
                if (currentErasure.isGenericType()) {
                    if (typeIsConsistent && qualifiedType != null && qualifiedType.isParameterizedType()) {
                        scope.problemReporter().parameterizedMemberTypeMissingArguments(this, scope.environment().createParameterizedType(currentErasure, null, qualifiedType));
                        typeIsConsistent = false;
                    }
                    qualifiedType = scope.environment().createRawType(currentErasure, qualifiedType);
                } else {
                    qualifiedType = qualifiedType != null && qualifiedType.isParameterizedType() ? scope.environment().createParameterizedType(currentErasure, null, qualifiedType) : currentType;
                }
            }
            ++i;
        }
        this.resolvedType = qualifiedType;
        if (this.isTypeUseDeprecated(this.resolvedType, scope)) {
            this.reportDeprecatedType(scope);
        }
        if (this.dimensions > 0) {
            if (this.dimensions > 255) {
                scope.problemReporter().tooManyDimensions(this);
            }
            this.resolvedType = scope.createArrayType(this.resolvedType, this.dimensions);
        }
        return this.resolvedType;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        int length = this.tokens.length;
        int i = 0;
        while (i < length - 1) {
            output.append(this.tokens[i]);
            TypeReference[] typeArgument = this.typeArguments[i];
            if (typeArgument != null) {
                output.append('<');
                int max = typeArgument.length - 1;
                int j = 0;
                while (j < max) {
                    typeArgument[j].print(0, output);
                    output.append(", ");
                    ++j;
                }
                typeArgument[max].print(0, output);
                output.append('>');
            }
            output.append('.');
            ++i;
        }
        output.append(this.tokens[length - 1]);
        TypeReference[] typeArgument = this.typeArguments[length - 1];
        if (typeArgument != null) {
            output.append('<');
            int max = typeArgument.length - 1;
            int j = 0;
            while (j < max) {
                typeArgument[j].print(0, output);
                output.append(", ");
                ++j;
            }
            typeArgument[max].print(0, output);
            output.append('>');
        }
        if ((this.bits & 0x4000) != 0) {
            int i2 = 0;
            while (i2 < this.dimensions - 1) {
                output.append("[]");
                ++i2;
            }
            output.append("...");
        } else {
            int i3 = 0;
            while (i3 < this.dimensions) {
                output.append("[]");
                ++i3;
            }
        }
        return output;
    }

    public TypeBinding resolveType(BlockScope scope, boolean checkBounds) {
        return this.internalResolveType(scope, checkBounds);
    }

    public TypeBinding resolveType(ClassScope scope) {
        return this.internalResolveType(scope, false);
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            int i = 0;
            int max = this.typeArguments.length;
            while (i < max) {
                if (this.typeArguments[i] != null) {
                    int j = 0;
                    int max2 = this.typeArguments[i].length;
                    while (j < max2) {
                        this.typeArguments[i][j].traverse(visitor, scope);
                        ++j;
                    }
                }
                ++i;
            }
        }
        visitor.endVisit(this, scope);
    }

    public void traverse(ASTVisitor visitor, ClassScope scope) {
        if (visitor.visit(this, scope)) {
            int i = 0;
            int max = this.typeArguments.length;
            while (i < max) {
                if (this.typeArguments[i] != null) {
                    int j = 0;
                    int max2 = this.typeArguments[i].length;
                    while (j < max2) {
                        this.typeArguments[i][j].traverse(visitor, scope);
                        ++j;
                    }
                }
                ++i;
            }
        }
        visitor.endVisit(this, scope);
    }
}

