/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.report.designer.data.ui.dataset.CachePreferencePage;
import org.eclipse.birt.report.designer.data.ui.dataset.DataModelManager;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetComputedColumnsPage;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetDataSourceSelectionPage;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetFiltersPage;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetParametersPage;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.data.ui.dataset.JointDataSetPage;
import org.eclipse.birt.report.designer.data.ui.dataset.OutputColumnDefnPage;
import org.eclipse.birt.report.designer.data.ui.dataset.OutputColumnsPage;
import org.eclipse.birt.report.designer.data.ui.dataset.OutputParameterPreviewPage;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyPageWrapper;
import org.eclipse.birt.report.designer.data.ui.dataset.ResultSetPreviewPage;
import org.eclipse.birt.report.designer.data.ui.datasource.PropertyBindingPage;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.property.AbstractPropertyDialog;
import org.eclipse.birt.report.designer.data.ui.property.PropertyNode;
import org.eclipse.birt.report.designer.data.ui.util.DTPUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPage;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.DesignerState;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DataSetDesignSession;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.UIManifestExplorer;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetEditorPage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PropertyPage;

public class DataSetEditor
extends AbstractPropertyDialog
implements IPreferencePageContainer {
    private ItemModelManager itemModelManager = new ItemModelManager();
    private DataModelManager dataModelManager = new DataModelManager();
    private DataSetDesignSession m_designSession = null;
    private boolean includeInputParameterPage = false;
    private boolean includeOutputParameterPage = false;
    private boolean needToFocusOnOutput = false;
    private ToolBarManager toolbarManager = null;
    private List history = new ArrayList();
    private int historyIndex = -1;
    static /* synthetic */ Class class$org$eclipse$birt$report$designer$data$ui$dataset$DataSetEditor;

    /*
     * WARNING - void declaration
     */
    public DataSetEditor(Shell parentShell, DataSetHandle ds, boolean needToFocusOnOutput) {
        super(parentShell, ds);
        String dataSetType;
        String dataSourceType;
        if (!(ds instanceof JointDataSetHandle) && ds.getDataSource() == null) {
            throw new RuntimeException(Messages.getFormattedString((String)"dataset.editor.error.noDataSource", (Object[])new String[]{ds.getName()}));
        }
        this.needToFocusOnOutput = needToFocusOnOutput;
        if (ds instanceof OdaDataSetHandle) {
            OdaDataSourceHandle dataSource = (OdaDataSourceHandle)((OdaDataSetHandle)ds).getDataSource();
            dataSourceType = dataSource.getExtensionID();
            dataSetType = ((OdaDataSetHandle)ds).getExtensionID();
        } else if (ds instanceof ScriptDataSetHandle) {
            dataSourceType = "script";
            dataSetType = "ScriptSelectDataSet";
        } else if (ds instanceof JointDataSetHandle) {
            dataSourceType = "";
            dataSetType = "";
            this.addJointDataSetPage();
        } else {
            throw new RuntimeException(Messages.getFormattedString((String)"dataset.editor.error.noDataSource", (Object[])new String[]{ds.getClass().getName()}));
        }
        if (!(ds instanceof JointDataSetHandle)) {
            void var5_6;
            void var4_5;
            this.addPageTo("/", "org.eclipse.birt.datasource.editor.dataset.datasourceselectionpage", Messages.getString((String)"dataset.editor.dataSource"), null, new DataSetDataSourceSelectionPage());
            if (DesignSessionUtil.hasValidOdaDesignUIExtension((String)var4_5)) {
                this.addCustomPageODAV3((OdaDataSetHandle)ds, (String)var4_5, (String)var5_6);
            } else {
                this.addBirtPage((String)var4_5, (String)var5_6);
            }
        }
        this.addCommonPage(ds);
        this.itemModelManager.start(ds);
    }

    private void addCustomPageODAV3(OdaDataSetHandle dataSetHandle, String dataSourceType, String dataSetType) {
        try {
            this.m_designSession = DataSetDesignSession.startEditDesign((DesignSessionRequest)DTPUtil.getInstance().createDesignSessionRequest(dataSetHandle));
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
        if (this.m_designSession != null) {
            this.populateEditorPage(this.m_designSession, dataSourceType, dataSetType);
        }
    }

    private void populateEditorPage(DataSetDesignSession m_designSession, String dataSourceType, String dataSetType) {
        try {
            DataSetEditorPage[] dataSetEditorPages = m_designSession.getEditorPages();
            for (int i = 0; i < dataSetEditorPages.length; ++i) {
                DataSetEditorPage dataSetEditorPage = dataSetEditorPages[i];
                PropertyPageWrapper propertyPageWrapper = new PropertyPageWrapper((PropertyPage)dataSetEditorPage);
                this.addPageTo(dataSetEditorPage.getPagePath(), dataSetEditorPage.getPageId(), dataSetEditorPage.getTitle(), null, propertyPageWrapper);
                if (!dataSetEditorPage.hasInitialFocus()) continue;
                this.setDefaultNode(dataSetEditorPage.getPageId());
            }
        }
        catch (OdaException e) {
            ExceptionHandler.handle(e);
        }
        try {
            this.includeInputParameterPage = UIManifestExplorer.getInstance().getDataSetUIElement(dataSourceType, dataSetType).supportsInParameters();
            this.includeOutputParameterPage = UIManifestExplorer.getInstance().getDataSetUIElement(dataSourceType, dataSetType).supportsOutParameters();
        }
        catch (OdaException ex) {
            ExceptionHandler.handle(ex);
        }
    }

    private void addCommonPage(DataSetHandle ds) {
        if (ds instanceof ScriptDataSetHandle) {
            this.addPageTo("/", "org.eclipse.birt.datasource.editor.dataset.outputcolumnpage", Messages.getString((String)"dataset.editor.outputColumns"), null, new OutputColumnDefnPage());
            this.addPageTo("/", "org.eclipse.birt.datasource.editor.dataset.parameterspage", Messages.getString((String)"dataset.editor.parameters"), null, new DataSetParametersPage());
            this.addPageTo("/", "org.eclipse.birt.datasource.editor.dataset.filterspage", Messages.getString((String)"dataset.editor.filters"), null, new DataSetFiltersPage());
            this.addCachePreferencePage(ds);
            this.addPageTo("/", "org.eclipse.birt.datasource.editor.dataset.resultsetpreviewpage", Messages.getString((String)"dataset.editor.preview"), null, new ResultSetPreviewPage());
        } else if (ds instanceof OdaDataSetHandle) {
            this.addPageTo("/", "org.eclipse.birt.datasource.editor.dataset.outputcolumnpage", Messages.getString((String)"dataset.editor.outputColumns"), null, new OutputColumnsPage());
            this.addPageTo("/", "org.eclipse.birt.datasource.editor.dataset.computedcolumnspage", Messages.getString((String)"dataset.editor.computedColumns"), null, new DataSetComputedColumnsPage());
            if (this.includeInputParameterPage) {
                this.addPageTo("/", "org.eclipse.birt.datasource.editor.dataset.parameterspage", Messages.getString((String)"dataset.editor.parameters"), null, new DataSetParametersPage());
            }
            this.addPageTo("/", "org.eclipse.birt.datasource.editor.dataset.filterspage", Messages.getString((String)"dataset.editor.filters"), null, new DataSetFiltersPage());
            this.addPageTo("/", "org.eclipse.birt.datasource.editor.property", Messages.getString((String)"datasource.editor.property"), null, new PropertyBindingPage());
            this.addCachePreferencePage(ds);
            if (this.includeOutputParameterPage) {
                this.addPageTo("/", "org.eclipse.birt.datasource.editor.dataset.outputparameterpreviewpage", Messages.getString((String)"dataset.editor.outputparameters"), null, new OutputParameterPreviewPage());
            }
            this.addPageTo("/", "org.eclipse.birt.datasource.editor.dataset.resultsetpreviewpage", Messages.getString((String)"dataset.editor.preview"), null, new ResultSetPreviewPage());
        } else if (ds instanceof JointDataSetHandle) {
            this.addPageTo("/", "org.eclipse.birt.datasource.editor.dataset.outputcolumnpage", Messages.getString((String)"dataset.editor.outputColumns"), null, new OutputColumnsPage());
            this.addPageTo("/", "org.eclipse.birt.datasource.editor.dataset.computedcolumnspage", Messages.getString((String)"dataset.editor.computedColumns"), null, new DataSetComputedColumnsPage());
            this.addPageTo("/", "org.eclipse.birt.datasource.editor.dataset.filterspage", Messages.getString((String)"dataset.editor.filters"), null, new DataSetFiltersPage());
            this.addPageTo("/", "org.eclipse.birt.datasource.editor.dataset.resultsetpreviewpage", Messages.getString((String)"dataset.editor.preview"), null, new ResultSetPreviewPage());
        }
        if (this.needToFocusOnOutput) {
            this.setDefaultNode("org.eclipse.birt.datasource.editor.dataset.outputcolumnpage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCachePreferencePage(DataSetHandle ds) {
        CachePreferencePage cachePage = new CachePreferencePage();
        try {
            cachePage.setBaseDesign(this.getDataSetDesign(ds), this.getDataSourceDesign(ds));
        }
        catch (BirtException birtException) {
        }
        finally {
            this.addPageTo("/", "org.eclipse.birt.datasource.editor.dataset.cachePreferencepage", Messages.getString((String)"dataset.editor.cachePreference"), null, cachePage);
        }
    }

    private void addJointDataSetPage() {
        this.addPageTo("/", "org.eclipse.birt.datasource.editor.dataset.jointDataSetPage", Messages.getString((String)"JointDataSetPage.query"), null, new JointDataSetPage(Messages.getString((String)"dataset.editor.dataSource")));
    }

    private void addBirtPage(String dataSourceType, String dataSetType) {
        try {
            IConfigurationElement element = DataSetProvider.findDataSetElement(dataSetType, dataSourceType);
            if (element != null) {
                IConfigurationElement[] editorPages;
                String supportParameterPage = element.getAttribute("addsDataSetParametersPage");
                if (supportParameterPage != null) {
                    this.includeInputParameterPage = Boolean.valueOf(supportParameterPage);
                }
                if ((editorPages = element.getChildren("dataSetEditorPage")) != null) {
                    boolean hasFocus = false;
                    for (int n = 0; n < editorPages.length; ++n) {
                        IPropertyPage page = (IPropertyPage)editorPages[n].createExecutableExtension("class");
                        this.addPageTo(editorPages[n].getAttribute("path"), editorPages[n].getAttribute("name"), editorPages[n].getAttribute("displayName"), null, page);
                        if (hasFocus) continue;
                        String initFocusAttr = editorPages[n].getAttribute("initFocus");
                        if (initFocusAttr != null && initFocusAttr.equalsIgnoreCase("true")) {
                            this.setDefaultNode(editorPages[n].getAttribute("name"));
                            hasFocus = true;
                            continue;
                        }
                        if (n != editorPages.length - 1) continue;
                        this.setDefaultNode(editorPages[0].getAttribute("name"));
                    }
                }
            }
        }
        catch (CoreException e1) {
            ExceptionHandler.handle(e1);
        }
    }

    public boolean performOk() {
        try {
            if (this.m_designSession != null) {
                DTPUtil.getInstance().updateDataSetHandle(this.m_designSession.finish().getResponse(), (OdaDataSetHandle)this.getHandle(), false);
            }
        }
        catch (OdaException e) {
            ExceptionHandler.handle(e);
        }
        this.itemModelManager.destory(false);
        return true;
    }

    public void updateROMDesignerState(DesignerState designerState) {
        this.dataModelManager.updateROMDesignerState(designerState, this.getHandle());
    }

    public void updateDataSetDesign(String propName) {
        try {
            if (this.m_designSession != null) {
                DataSetDesign dataSetDesign = this.m_designSession.finish().getResponse().getDataSetDesign();
                this.dataModelManager.updateDataSetDesign(dataSetDesign, this.getHandle(), propName);
                this.m_designSession = DataSetDesignSession.startEditDesign((DesignSessionRequest)DesignFactory.eINSTANCE.createDesignSessionRequest(dataSetDesign));
                this.populateDataSetEditor();
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }

    public boolean performCancel() {
        if (this.m_designSession != null) {
            this.m_designSession.cancel();
        }
        this.itemModelManager.destory(true);
        return true;
    }

    public DataSetHandle getHandle() {
        return (DataSetHandle)this.getModel();
    }

    protected Control createContents(Composite parent) {
        String title = Messages.getFormattedString((String)"dataset.edit", (Object[])new String[]{this.getHandle().getName()});
        this.getShell().setText(title);
        Control control = super.createContents(parent);
        Utility.setSystemHelp(control, "org.eclipse.birt.cshelp.Dialog_DatasetEdit_ID");
        return control;
    }

    public DataSetViewData[] getCurrentItemModel() {
        return this.itemModelManager.getCurrentItemModel();
    }

    public DataSetViewData[] getCurrentItemModel(boolean useColumnHint, boolean suppressErrorMessage) {
        return this.itemModelManager.getCurrentItemModel(useColumnHint, suppressErrorMessage);
    }

    protected void okPressed() {
        super.okPressed();
        try {
            DataSetUIUtil.updateColumnCache(this.getHandle());
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        if (this.rootNode.hasSubNodes()) {
            PropertyNode[] nodes = this.rootNode.getSubNodes();
            for (int n = 0; n < nodes.length; ++n) {
                AbstractDescriptionPropertyPage page;
                if (nodes[n].getPage() instanceof DataSetParametersPage) {
                    if (this.viewer == null && this.viewer.getTree() == null) {
                        return;
                    }
                    page = (DataSetParametersPage)nodes[n].getPage();
                    if (!((DataSetParametersPage)page).canFinish() && !this.viewer.getTree().isDisposed()) {
                        TreeItem firstNode = this.viewer.getTree().getItems()[n];
                        StructuredSelection select = new StructuredSelection(firstNode.getData());
                        this.viewer.setSelection((ISelection)select);
                        String name = ((DataSetParametersPage)nodes[n].getPage()).getNoneValuedParameterName();
                        this.setMessage(Messages.getFormattedString((String)"dataset.editor.error.noInputParameterDefaultValue", (Object[])new Object[]{name}), 3);
                        return;
                    }
                }
                if (!(nodes[n].getPage() instanceof CachePreferencePage)) continue;
                if (this.viewer == null) {
                    return;
                }
                page = (CachePreferencePage)nodes[n].getPage();
                if (!((CachePreferencePage)page).clearCacheOnExit()) continue;
            }
        }
    }

    private IBaseDataSetDesign getDataSetDesign(DataSetHandle ds) throws BirtException {
        return DataSetProvider.getCurrentInstance().createDataSetDesign(ds);
    }

    private IBaseDataSourceDesign getDataSourceDesign(DataSetHandle ds) throws BirtException {
        return DataSetProvider.getCurrentInstance().createDataSourceDesign(ds.getDataSource());
    }

    public DataModelManager getDataModelManager() {
        return this.dataModelManager;
    }

    private PropertyPage getCurrentPropertyPage() {
        IPropertyPage ipropertyPage;
        if (this.getCurrentNode() != null && (ipropertyPage = this.getCurrentNode().getPage()) instanceof PropertyPageWrapper) {
            return ((PropertyPageWrapper)ipropertyPage).getPropertyPage();
        }
        return null;
    }

    private void populateDataSetEditor() {
        DataSetEditorPage[] dataSetEditorPages;
        if (this.m_designSession == null) {
            return;
        }
        try {
            dataSetEditorPages = this.m_designSession.getEditorPages();
        }
        catch (OdaException e) {
            return;
        }
        for (int i = 0; i < dataSetEditorPages.length; ++i) {
            DataSetEditorPage dataSetEditorPage = dataSetEditorPages[i];
            PropertyPageWrapper propertyPageWrapper = new PropertyPageWrapper((PropertyPage)dataSetEditorPage);
            if (!this.rootNode.hasSubNodes()) continue;
            PropertyNode[] nodes = this.rootNode.getSubNodes();
            for (int n = 0; n < nodes.length; ++n) {
                if (nodes[n] == null || !nodes[n].getId().equals(dataSetEditorPage.getPageId())) continue;
                nodes[n].setPage(propertyPageWrapper);
                nodes[n].setContainer(this);
                nodes[n].createPageControl(this.getPropertyPane());
            }
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return null;
    }

    public void updateButtons() {
        PropertyPage propertyPage = this.getCurrentPropertyPage();
        if (propertyPage != null && this.getOkButton() != null) {
            this.getOkButton().setEnabled(propertyPage.isValid());
        }
    }

    public void updateMessage() {
        PropertyPage propertyPage = this.getCurrentPropertyPage();
        if (propertyPage != null) {
            this.setMessage(propertyPage.getMessage(), propertyPage.getMessageType());
        }
    }

    public void updateTitle() {
    }

    public Composite createTitleArea(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        this.createMessageComposite(parent);
        this.createToolbarComposite(parent);
        return null;
    }

    private void createMessageComposite(Composite parent) {
        super.createTitleArea(parent);
    }

    private void createToolbarComposite(Composite parent) {
        Composite toolbarComposite = new Composite(parent, 0);
        GridLayout toolbarLayout = new GridLayout();
        toolbarLayout.marginHeight = 0;
        toolbarLayout.verticalSpacing = 0;
        toolbarComposite.setLayout((Layout)toolbarLayout);
        toolbarComposite.setLayoutData((Object)new GridData(0x1000008, 4, false, true));
        this.createHistoryToolBar(toolbarComposite);
    }

    private void createHistoryToolBar(Composite parent) {
        ToolBar historyBar = new ToolBar(parent, 0x800100);
        historyBar.setLayoutData((Object)new GridData(0x1000008, 4, false, true));
        this.toolbarManager = new ToolBarManager(historyBar);
        this.createHistoryControls(historyBar);
        this.toolbarManager.update(false);
    }

    private void createHistoryControls(ToolBar historyBar) {
        abstract class HistoryNavigationAction
        extends Action
        implements IMenuCreator {
            private Menu lastMenu;
            protected static final int MAX_ENTRIES = 5;

            HistoryNavigationAction() {
                super("", 4);
            }

            public IMenuCreator getMenuCreator() {
                return this;
            }

            public void dispose() {
                if (this.lastMenu != null) {
                    this.lastMenu.dispose();
                    this.lastMenu = null;
                }
            }

            public Menu getMenu(Control parent) {
                if (this.lastMenu != null) {
                    this.lastMenu.dispose();
                }
                this.lastMenu = new Menu(parent);
                this.createEntries(this.lastMenu);
                return this.lastMenu;
            }

            public Menu getMenu(Menu parent) {
                return null;
            }

            protected void addActionToMenu(Menu parent, IAction action) {
                ActionContributionItem item = new ActionContributionItem(action);
                item.fill(parent, -1);
            }

            protected abstract void createEntries(Menu var1);
        }
        HistoryNavigationAction backward = new HistoryNavigationAction(){
            {
            }

            public void run() {
                DataSetEditor.this.jumpToHistory(DataSetEditor.this.historyIndex - 1);
            }

            public boolean isEnabled() {
                boolean enabled;
                boolean bl = enabled = DataSetEditor.this.historyIndex > 0;
                if (enabled) {
                    this.setToolTipText(DataSetEditor.this.getHistoryToolTip(this.getText(), DataSetEditor.this.historyIndex - 1));
                } else {
                    this.setToolTipText(this.getText());
                }
                return enabled;
            }

            protected void createEntries(Menu menu) {
                int limit = Math.max(0, DataSetEditor.this.historyIndex - 5);
                for (int i = DataSetEditor.this.historyIndex - 1; i >= limit; --i) {
                    class HistoryItemAction
                    extends Action {
                        private final int index;
                        private final /* synthetic */ DataSetEditor this$0;

                        HistoryItemAction(DataSetEditor this$0, int index, String label) {
                            this.this$0 = this$0;
                            super(label, 1);
                            this.index = index;
                        }

                        public void run() {
                            DataSetEditor.access$100(this.this$0, this.index);
                        }
                    }
                    HistoryItemAction action = new HistoryItemAction(DataSetEditor.this, i, DataSetEditor.this.getHistoryPropertyNode(i).getNodeLabel());
                    this.addActionToMenu(menu, (IAction)action);
                }
            }
        };
        backward.setText(Messages.getString((String)"dataset.editor.historybar.backward"));
        backward.setImageDescriptor(ReportPlatformUIImages.getImageDescriptor("BackwardEnabled"));
        backward.setDisabledImageDescriptor(ReportPlatformUIImages.getImageDescriptor("BackwardDisabled"));
        this.toolbarManager.add((IAction)backward);
        HistoryNavigationAction forward = new HistoryNavigationAction(){
            {
            }

            public void run() {
                DataSetEditor.this.jumpToHistory(DataSetEditor.this.historyIndex + 1);
            }

            public boolean isEnabled() {
                boolean enabled;
                boolean bl = enabled = DataSetEditor.this.historyIndex < DataSetEditor.this.history.size() - 1;
                if (enabled) {
                    this.setToolTipText(DataSetEditor.this.getHistoryToolTip(this.getText(), DataSetEditor.this.historyIndex + 1));
                } else {
                    this.setToolTipText(this.getText());
                }
                return enabled;
            }

            protected void createEntries(Menu menu) {
                int limit = Math.min(DataSetEditor.this.history.size(), DataSetEditor.this.historyIndex + 5 + 1);
                for (int i = DataSetEditor.this.historyIndex + 1; i < limit; ++i) {
                    HistoryItemAction action = new HistoryItemAction(DataSetEditor.this, i, DataSetEditor.this.getHistoryPropertyNode(i).getNodeLabel());
                    this.addActionToMenu(menu, (IAction)action);
                }
            }
        };
        forward.setText(Messages.getString((String)"dataset.editor.historybar.forward"));
        forward.setImageDescriptor(ReportPlatformUIImages.getImageDescriptor("ForwardEnabled"));
        forward.setDisabledImageDescriptor(ReportPlatformUIImages.getImageDescriptor("ForwardDisabled"));
        this.toolbarManager.add((IAction)forward);
    }

    private void jumpToHistory(int index) {
        if (this.canLeave() && index >= 0 && index < this.history.size()) {
            this.historyIndex = index;
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)((PropertyNode)this.history.get(this.historyIndex))));
        }
        this.updateHistoryControls();
    }

    private boolean canLeave() {
        return ((PropertyNode)this.history.get(this.historyIndex)).getPage().canLeave();
    }

    private void updateHistoryControls() {
        this.toolbarManager.update(false);
        IContributionItem[] items = this.toolbarManager.getItems();
        for (int i = 0; i < items.length; ++i) {
            items[i].update("enabled");
            items[i].update("toolTipText");
        }
    }

    public void showSelectionPage(PropertyNode selectedNode) {
        super.showSelectionPage(selectedNode);
        if (this.showPage) {
            this.addHistoryNode(selectedNode);
        }
    }

    private void addHistoryNode(PropertyNode node) {
        if (this.historyIndex == -1 || !this.history.get(this.historyIndex).equals(node)) {
            this.history.subList(this.historyIndex + 1, this.history.size()).clear();
            this.history.add(node);
            ++this.historyIndex;
            this.updateHistoryControls();
        }
    }

    private String getHistoryToolTip(String toolTipPrefix, int index) {
        return toolTipPrefix + " " + Messages.getString((String)"dataset.editor.historybar.to") + " " + this.getHistoryPropertyNode(index).getNodeLabel();
    }

    private PropertyNode getHistoryPropertyNode(int index) {
        return (PropertyNode)this.history.get(index);
    }

    private static class ItemModelManager
    implements Listener {
        private DataSetHandle ds = null;
        private boolean itemModelChanged = true;
        private DataSetViewData[] savedItemModel = null;
        private String savedQueryText = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        private ItemModelManager() {
        }

        public void start(DataSetHandle dataSet) {
            if (!$assertionsDisabled && dataSet == null) {
                throw new AssertionError();
            }
            this.ds = dataSet;
            if (this.ds instanceof OdaDataSetHandle) {
                this.savedQueryText = ((OdaDataSetHandle)this.ds).getQueryText();
            }
            this.savedItemModel = DataSetProvider.getCurrentInstance().getCachedDataSetItemModel(this.ds);
            this.ds.addListener((Listener)this);
        }

        public void destory(boolean rollback) {
            if (rollback) {
                if (this.ds instanceof OdaDataSetHandle) {
                    try {
                        ((OdaDataSetHandle)this.ds).setQueryText(this.savedQueryText);
                        DataSetProvider.getCurrentInstance().getDataSetDesign(this.ds, true, true);
                    }
                    catch (SemanticException e) {
                    }
                    catch (BirtException birtException) {
                        // empty catch block
                    }
                }
                DataSetProvider.getCurrentInstance().setModelOfDataSetHandle(this.ds, this.savedItemModel);
            }
            this.ds.removeListener((Listener)this);
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            this.itemModelChanged = true;
        }

        public DataSetViewData[] getCurrentItemModel() {
            DataSetViewData[] dataSetItem = DataSetProvider.getCurrentInstance().getColumns(this.ds, this.itemModelChanged);
            this.itemModelChanged = false;
            return dataSetItem;
        }

        public DataSetViewData[] getCurrentItemModel(boolean useColumnHint, boolean suppressErrorMessage) {
            DataSetViewData[] dataSetItem = DataSetProvider.getCurrentInstance().getColumns(this.ds, this.itemModelChanged, useColumnHint, suppressErrorMessage);
            this.itemModelChanged = false;
            return dataSetItem;
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$report$designer$data$ui$dataset$DataSetEditor == null ? (class$org$eclipse$birt$report$designer$data$ui$dataset$DataSetEditor = DataSetEditor.class$("org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor")) : class$org$eclipse$birt$report$designer$data$ui$dataset$DataSetEditor).desiredAssertionStatus();
        }
    }
}

