/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.data.ui.dataset.ExpressionValueCellEditor;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.util.ChoiceSetFactory;
import org.eclipse.birt.report.designer.data.ui.util.DataSetExpressionProvider;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.dialogs.PropertyHandleTableViewer;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ComboBoxExpressionCellEditor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public final class DataSetFiltersPage
extends AbstractDescriptionPropertyPage
implements ITableLabelProvider {
    private transient PropertyHandleTableViewer viewer = null;
    private transient DataSetViewData[] columns = null;
    private transient String[] columnExpressions = null;
    private transient PropertyHandle filters = null;
    private transient FilterCondition newFilter = null;
    private transient boolean isOperatorSet = false;
    private static String[] operators;
    private static String[] operatorDisplayNames;
    private transient ComboBoxExpressionCellEditor columnNameEditor = null;
    private static final Image selectorImage;

    public Control createContents(Composite parent) {
        this.initColumnNames();
        this.viewer = new PropertyHandleTableViewer(parent, true, true, true);
        TableColumn column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(" ");
        column.setResizable(false);
        column.setWidth(19);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.expression"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.operator"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.value1"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.value2"));
        column.setWidth(100);
        this.initializeFilters();
        this.viewer.getViewer().setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList filterList = new ArrayList(10);
                Iterator iter = DataSetFiltersPage.this.filters.iterator();
                if (iter != null) {
                    while (iter.hasNext()) {
                        filterList.add(iter.next());
                    }
                }
                if (DataSetFiltersPage.this.newFilter == null) {
                    DataSetFiltersPage.this.newFilter = new FilterCondition();
                }
                filterList.add(DataSetFiltersPage.this.newFilter);
                return filterList.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.getViewer().setLabelProvider((IBaseLabelProvider)this);
        this.viewer.getViewer().setInput((Object)this.filters);
        this.setupEditors();
        this.addListeners();
        this.viewer.getDownButton().setToolTipText(Messages.getString((String)"DataSetFiltersPage.toolTipText.Down"));
        this.viewer.getUpButton().setToolTipText(Messages.getString((String)"DataSetFiltersPage.toolTipText.Up"));
        this.viewer.getRemoveButton().setToolTipText(Messages.getString((String)"DataSetFiltersPage.toolTipText.Remove"));
        return this.viewer.getControl();
    }

    private void setupEditors() {
        CellEditor[] editors = new CellEditor[5];
        if (this.columnExpressions == null) {
            this.columnExpressions = new String[0];
        }
        this.columnNameEditor = new ComboBoxExpressionCellEditor((Composite)this.viewer.getViewer().getTable(), this.columnExpressions, 0);
        DataSetExpressionProvider provider = new DataSetExpressionProvider((DesignElementHandle)this.getContainer().getModel());
        this.columnNameEditor.setExpressionProvider(provider);
        editors[1] = this.columnNameEditor;
        editors[2] = new ComboBoxCellEditor((Composite)this.viewer.getViewer().getTable(), operatorDisplayNames, 8);
        ExpressionValueCellEditor editor = new ExpressionValueCellEditor((Composite)this.viewer.getViewer().getTable(), false);
        editor.setExpressionProvider(provider);
        editor.setReportElement((ReportElementHandle)this.getContainer().getModel());
        editors[3] = editor;
        editor = new ExpressionValueCellEditor((Composite)this.viewer.getViewer().getTable(), false);
        editor.setExpressionProvider(provider);
        editor.setReportElement((ReportElementHandle)this.getContainer().getModel());
        editors[4] = editor;
        this.viewer.getViewer().setCellEditors(editors);
        this.viewer.getViewer().setColumnProperties(new String[]{"", "expr", "operator", "value1", "value2"});
        this.viewer.getViewer().setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                String operator = "";
                String expr = null;
                try {
                    operator = (String)Utility.getProperty(element, "operator");
                    expr = (String)Utility.getProperty(element, "expr");
                }
                catch (Exception ex) {
                    ExceptionHandler.handle(ex);
                }
                if (operator == null) {
                    operator = "";
                }
                if (element == DataSetFiltersPage.this.newFilter && !property.equals("expr")) {
                    return false;
                }
                if (property.equals("value2") && !operator.equals("between") && !operator.equals("not-between")) {
                    return false;
                }
                if (property.equals("value1") && (operator.equals("is-null") || operator.equals("is-not-null") || operator.equals("is-true") || operator.equals("is-false"))) {
                    return false;
                }
                ((ExpressionValueCellEditor)DataSetFiltersPage.this.viewer.getViewer().getCellEditors()[3]).setSelectValueExpression(expr);
                ((ExpressionValueCellEditor)DataSetFiltersPage.this.viewer.getViewer().getCellEditors()[4]).setSelectValueExpression(expr);
                return true;
            }

            public Object getValue(Object element, String property) {
                Object value = null;
                try {
                    value = Utility.getProperty(element, property);
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                }
                if ("operator".equals(property)) {
                    value = new Integer(DataSetFiltersPage.this.getOperatorIndex((String)value));
                }
                if (value == null) {
                    value = "";
                }
                return value;
            }

            public void modify(Object element, String property, Object value) {
                Object actualElement = ((TableItem)element).getData();
                if (value != null) {
                    try {
                        if ("operator".equals(property)) {
                            Integer index = (Integer)value;
                            if (index > -1 && index < operators.length) {
                                value = operators[index];
                                if (value.equals("is-null") || value.equals("is-not-null") || value.equals("is-true") || value.equals("is-false")) {
                                    Utility.setProperty(actualElement, "value1", "");
                                    Utility.setProperty(actualElement, "value2", "");
                                    DataSetFiltersPage.this.viewer.getViewer().refresh();
                                } else if (!value.equals("between") && !value.equals("not-between")) {
                                    Utility.setProperty(actualElement, "value2", "");
                                    DataSetFiltersPage.this.viewer.getViewer().refresh();
                                }
                            } else {
                                value = "";
                            }
                        } else if ("expr".equals(property)) {
                            if (DataSetFiltersPage.this.isColumnName((String)value)) {
                                value = "row[\"" + Utility.escape((String)value) + "\"]";
                            }
                            if (actualElement != DataSetFiltersPage.this.newFilter && (value == null || ((String)value).trim().length() == 0)) {
                                ExceptionHandler.openMessageBox(Messages.getString((String)"filters.error.title"), Messages.getString((String)"filters.empty.columnName"), 2);
                                DataSetFiltersPage.this.viewer.getViewer().update(actualElement, null);
                                return;
                            }
                        }
                        Utility.setProperty(actualElement, property, value);
                    }
                    catch (InvocationTargetException ite) {
                        Exception e = new Exception(Messages.getString((String)"DataSetFiltersPage.exception.msg.operator.notSupport") + value);
                        ExceptionHandler.handle(e);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        ExceptionHandler.handle(ex);
                    }
                    DataSetFiltersPage.this.viewer.getViewer().update(((TableItem)element).getData(), null);
                    if (actualElement instanceof FilterCondition) {
                        DataSetFiltersPage.this.isOperatorSet = true;
                        if (DataSetFiltersPage.this.newFilter.getExpr() != null && DataSetFiltersPage.this.newFilter.getExpr().trim().length() > 0) {
                            try {
                                DataSetFiltersPage.this.filters.addItem((IStructure)DataSetFiltersPage.this.newFilter);
                                DataSetFiltersPage.this.clearNewFilter();
                                DataSetFiltersPage.this.viewer.getViewer().refresh();
                            }
                            catch (SemanticException e) {
                                ExceptionHandler.handle(e);
                            }
                        }
                    }
                }
            }
        });
    }

    private void addListeners() {
        this.viewer.getViewer().getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    DataSetFiltersPage.this.removeSelectedItem();
                }
                DataSetFiltersPage.this.setPageProperties();
            }
        });
        this.viewer.getRemoveButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetFiltersPage.this.removeSelectedItem();
                DataSetFiltersPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetFiltersPage.this.removeSelectedItem();
                DataSetFiltersPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveAllMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetFiltersPage.this.removeAllItem();
                DataSetFiltersPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.viewer.getViewer().addSelectionChangedListener((ISelectionChangedListener)new ViewerSelectionListener());
    }

    private void initColumnNames() {
        this.columns = ((DataSetEditor)this.getContainer()).getCurrentItemModel(true, true);
        if (this.columns != null) {
            this.columnExpressions = new String[this.columns.length];
            for (int n = 0; n < this.columns.length; ++n) {
                this.columnExpressions[n] = this.columns[n].getName();
            }
        }
    }

    private boolean isColumnName(String name) {
        for (int n = 0; n < this.columnExpressions.length; ++n) {
            if (!this.columnExpressions[n].equals(name)) continue;
            return true;
        }
        return false;
    }

    private void initializeFilters() {
        this.filters = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("filter");
    }

    private int getOperatorIndex(String filter) {
        for (int n = 0; n < operators.length; ++n) {
            if (!operators[n].equals(filter)) continue;
            return n;
        }
        return -1;
    }

    public void pageActivated() {
        this.getContainer().setMessage(Messages.getString((String)"dataset.editor.filters"), 0);
        this.initColumnNames();
        if (this.columnExpressions != null) {
            this.columnNameEditor.setItems(this.columnExpressions);
        }
        this.setPageProperties();
    }

    private void setPageProperties() {
        boolean filterConditionExists = false;
        filterConditionExists = this.filters != null && this.filters.getListValue() != null && this.filters.getListValue().size() > 0;
        this.viewer.getDownButton().setEnabled(filterConditionExists);
        this.viewer.getUpButton().setEnabled(filterConditionExists);
        this.viewer.getRemoveButton().setEnabled(filterConditionExists);
        this.viewer.getRemoveMenuItem().setEnabled(filterConditionExists);
        this.viewer.getRemoveAllMenuItem().setEnabled(filterConditionExists);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return selectorImage;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String value = null;
        try {
            if (element != this.newFilter) {
                switch (columnIndex) {
                    case 1: {
                        value = (String)Utility.getProperty(element, "expr");
                        break;
                    }
                    case 2: {
                        if (element == this.newFilter && !this.isOperatorSet) break;
                        int index = this.getOperatorIndex((String)Utility.getProperty(element, "operator"));
                        if (index > -1) {
                            value = operatorDisplayNames[index];
                            break;
                        }
                        value = (String)Utility.getProperty(element, "operator");
                        break;
                    }
                    case 3: {
                        value = (String)Utility.getProperty(element, "value1");
                        break;
                    }
                    case 4: {
                        value = (String)Utility.getProperty(element, "value2");
                    }
                }
            } else if (columnIndex == 1) {
                value = Messages.getString((String)"filters.prompt.new");
            }
        }
        catch (Exception ex) {
            ExceptionHandler.handle(ex);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public String getPageDescription() {
        return Messages.getString((String)"DataSetFiltersPage.description");
    }

    private void clearNewFilter() {
        this.newFilter = null;
        this.isOperatorSet = false;
    }

    private void removeSelectedItem() {
        int count;
        int index = this.viewer.getViewer().getTable().getSelectionIndex();
        int n = count = this.filters.getListValue() == null ? 0 : this.filters.getListValue().size();
        if (index == count) {
            this.clearNewFilter();
            this.viewer.getViewer().refresh();
        }
    }

    private void removeAllItem() {
        this.clearNewFilter();
        this.viewer.getViewer().refresh();
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    public boolean performOk() {
        return super.performOk();
    }

    public String getToolTip() {
        return Messages.getString((String)"DataSetFiltersPage.Filter.Tooltip");
    }

    static {
        IChoiceSet chset = ChoiceSetFactory.getStructChoiceSet("FilterCondition", "operator");
        IChoice[] chs = chset.getChoices();
        operators = new String[chs.length];
        operatorDisplayNames = new String[chs.length];
        for (int i = 0; i < chs.length; ++i) {
            DataSetFiltersPage.operators[i] = chs[i].getName();
            DataSetFiltersPage.operatorDisplayNames[i] = chs[i].getDisplayName();
        }
        selectorImage = ReportPlatformUIImages.getImage("TableRowSelector");
    }

    private class ViewerSelectionListener
    implements ISelectionChangedListener {
        private ViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            DataSetFiltersPage.this.setPageProperties();
        }
    }
}

