/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.data.engine.api.IParameterMetaData;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.dialogs.PropertyHandleTableViewer;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ExpressionCellEditor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.DataSetParameter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class DataSetParametersPage
extends AbstractDescriptionPropertyPage
implements Listener {
    private boolean modelChanged = true;
    private PropertyHandle parameters;
    private PropertyHandleTableViewer viewer;
    private static String[] dataTypes = new String[]{"any", "date-time", "decimal", "float", "integer", "string"};
    private static String[] dataTypeDisplayNames = new String[]{Messages.getString((String)"datatypes.any"), Messages.getString((String)"datatypes.dateTime"), Messages.getString((String)"datatypes.decimal"), Messages.getString((String)"datatypes.float"), Messages.getString((String)"datatypes.integer"), Messages.getString((String)"datatypes.string")};
    private static String[] yesNo = new String[]{Messages.getString((String)"label.yes"), Messages.getString((String)"label.no")};
    private static String[] directions = new String[]{Messages.getString((String)"label.input"), Messages.getString((String)"label.output"), Messages.getString((String)"label.inputOutput")};
    private static String NAME = "name";
    private static String DATA_TYPE = "dataType";
    private static String DIRECTION = "direction";
    private static String INPUT = "input";
    private static String OUTPUT = "output";
    private static String DEFAULT_VALUE = "defaultValue";
    private static String NULLABLE = "nullable";
    private static String OPTIONAL = "optional";
    private static String DEFAULT_MESSAGE = Messages.getString((String)"dataset.editor.parameters");
    private DataSetParameter newParameter = null;
    private boolean isDirectionSet = false;
    private boolean isOptionalSet = false;
    private boolean isNullableSet = false;
    private boolean isDataTypeSet = false;
    private String parameterName;
    private static String ERROR_DLG_TITLE = Messages.getString((String)"ParameterDialog.ErrorTitle.InvalidInput");
    private static String ERROR_MSG_EMPTY_COLUMN_NAME = Messages.getString((String)"ParameterDialog.ErrorMessage.CanootBeNull");

    public Control createContents(Composite parent) {
        this.parameters = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("parameters");
        this.viewer = new PropertyHandleTableViewer(parent, true, true, true);
        TableColumn column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(" ");
        column.setResizable(false);
        column.setWidth(19);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.name"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.dataType"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.direction"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.defaultValue"));
        column.setWidth(100);
        this.viewer.getViewer().setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Iterator iter = DataSetParametersPage.this.parameters.iterator();
                ArrayList params = new ArrayList(10);
                if (iter != null) {
                    while (iter.hasNext()) {
                        params.add(iter.next());
                    }
                }
                if (DataSetParametersPage.this.newParameter == null) {
                    DataSetParametersPage.this.newParameter = new DataSetParameter();
                    DataSetParametersPage.this.newParameter.setIsInput(true);
                }
                params.add(DataSetParametersPage.this.newParameter);
                DataSetParametersPage.this.refreshPositions();
                return params.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.getViewer().setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                String value = null;
                DataSetParameter metaData = null;
                metaData = element instanceof DataSetParameter ? (DataSetParameter)element : (DataSetParameter)((DataSetParameterHandle)element).getStructure();
                if (metaData != DataSetParametersPage.this.newParameter) {
                    switch (columnIndex) {
                        case 0: {
                            if (metaData.getPosition() == null) break;
                            value = metaData.getPosition().toString();
                            break;
                        }
                        case 1: {
                            value = metaData.getName();
                            break;
                        }
                        case 2: {
                            if (metaData == DataSetParametersPage.this.newParameter && !DataSetParametersPage.this.isDataTypeSet) break;
                            value = DataSetParametersPage.this.getTypeDisplayName(metaData.getDataType());
                            break;
                        }
                        case 3: {
                            if (metaData == DataSetParametersPage.this.newParameter && !DataSetParametersPage.this.isDirectionSet) break;
                            value = DataSetParametersPage.this.getDirectionDisplayName(metaData.isInput(), metaData.isOutput());
                            break;
                        }
                        case 4: {
                            value = metaData.getDefaultValue();
                            break;
                        }
                        case 5: {
                            if (metaData == DataSetParametersPage.this.newParameter && !DataSetParametersPage.this.isNullableSet) break;
                            value = DataSetParametersPage.this.getBooleanDisplayName(metaData.allowNull());
                            break;
                        }
                        case 6: {
                            if (metaData == DataSetParametersPage.this.newParameter && !DataSetParametersPage.this.isOptionalSet) break;
                            value = DataSetParametersPage.this.getBooleanDisplayName(metaData.isOptional());
                        }
                    }
                } else if (columnIndex == 1) {
                    value = Messages.getString((String)"ParameterDialog.Prompt.new");
                }
                if (value == null) {
                    value = "";
                }
                return value;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.viewer.getViewer().setInput((Object)this.parameters);
        this.setupEditors();
        this.addRefreshMenu();
        this.addListeners();
        ((DataSetHandle)this.getContainer().getModel()).addListener((Listener)this);
        return this.viewer.getControl();
    }

    private void addRefreshMenu() {
        MenuItem itmRefresh = new MenuItem(this.viewer.getMenu(), 0, 0);
        new MenuItem(this.viewer.getMenu(), 2, 1);
        itmRefresh.setText(Messages.getString((String)"parameters.menuItem.refresh"));
        itmRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyHandle handle = (PropertyHandle)DataSetParametersPage.this.viewer.getViewer().getInput();
                try {
                    handle.clearValue();
                }
                catch (SemanticException e1) {
                    e1.printStackTrace();
                }
                DataSetParametersPage.this.refreshParameters();
                DataSetParametersPage.this.viewer.getViewer().refresh();
            }
        });
    }

    protected final void setupEditors() {
        ExpressionCellEditor editor = new ExpressionCellEditor((Composite)this.viewer.getViewer().getTable(), 0);
        CellEditor[] editors = new CellEditor[8];
        editors[1] = new TextCellEditor((Composite)this.viewer.getViewer().getTable(), 0);
        editors[2] = new ComboBoxCellEditor((Composite)this.viewer.getViewer().getTable(), dataTypeDisplayNames, 8);
        editors[3] = new ComboBoxCellEditor((Composite)this.viewer.getViewer().getTable(), directions, 8);
        editors[4] = editor;
        editors[5] = new ComboBoxCellEditor((Composite)this.viewer.getViewer().getTable(), yesNo, 8);
        editors[6] = new ComboBoxCellEditor((Composite)this.viewer.getViewer().getTable(), yesNo, 8);
        this.viewer.getViewer().setColumnProperties(new String[]{"", NAME, DATA_TYPE, DIRECTION, DEFAULT_VALUE, NULLABLE, OPTIONAL});
        this.viewer.getViewer().setCellEditors(editors);
        this.viewer.getViewer().setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                DataSetParametersPage.this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
                if (property.equals(DEFAULT_VALUE) || property.equals(NULLABLE) || property.equals(OPTIONAL)) {
                    Boolean isInput = null;
                    try {
                        isInput = (Boolean)Utility.getProperty(element, INPUT);
                    }
                    catch (Exception ex) {
                        ExceptionHandler.handle(ex);
                    }
                    if (isInput == null || !isInput.booleanValue()) {
                        return false;
                    }
                }
                return element != DataSetParametersPage.this.newParameter || property.equals(NAME);
            }

            public Object getValue(Object element, String property) {
                Object value = null;
                try {
                    value = property.equals(DIRECTION) ? new Integer(DataSetParametersPage.this.getDirectionIndex((Boolean)Utility.getProperty(element, INPUT), (Boolean)Utility.getProperty(element, OUTPUT))) : (property.equals(NULLABLE) ? new Boolean(true) : Utility.getProperty(element, property));
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                }
                if (property.equals(OPTIONAL)) {
                    if (value == null) {
                        value = new Boolean(false);
                    }
                    value = (Boolean)value != false ? new Integer(0) : new Integer(1);
                } else if (property.equals(NULLABLE)) {
                    if (value == null) {
                        value = new Boolean(true);
                    }
                    value = (Boolean)value != false ? new Integer(0) : new Integer(1);
                } else if (property.equals(DATA_TYPE)) {
                    value = new Integer(DataSetParametersPage.this.getTypeIndex((String)value));
                }
                if (value == null) {
                    value = "";
                }
                return value;
            }

            public void modify(Object element, String property, Object value) {
                Object actualElement = ((TableItem)element).getData();
                Object finalValue = value;
                String finalProperty = property;
                if (property.equals(DIRECTION)) {
                    int selection = (Integer)finalValue;
                    char ch = Character.toUpperCase(INPUT.charAt(0));
                    StringBuffer sbFinalProperty = new StringBuffer();
                    sbFinalProperty.append("is").append(ch).append(INPUT.substring(1));
                    try {
                        Utility.setProperty(actualElement, sbFinalProperty.toString(), selection == 0 || selection == 2 ? new Boolean(true) : new Boolean(false));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ch = Character.toUpperCase(OUTPUT.charAt(0));
                    sbFinalProperty.setLength(0);
                    sbFinalProperty.append("is").append(ch).append(OUTPUT.substring(1));
                    finalProperty = sbFinalProperty.toString();
                    Object object = finalValue = selection == 1 || selection == 2 ? new Boolean(true) : new Boolean(false);
                    if (actualElement == DataSetParametersPage.this.newParameter) {
                        DataSetParametersPage.this.isDirectionSet = true;
                    }
                } else if (property.equals(OPTIONAL) || property.equals(NULLABLE)) {
                    char ch = Character.toUpperCase(property.charAt(0));
                    StringBuffer sbFinalProperty = new StringBuffer();
                    sbFinalProperty.append("is").append(ch).append(property.substring(1));
                    finalValue = (Integer)value == 0 ? new Boolean(true) : new Boolean(false);
                    finalProperty = sbFinalProperty.toString();
                    if (actualElement == DataSetParametersPage.this.newParameter) {
                        if (property.equals(OPTIONAL)) {
                            DataSetParametersPage.this.isOptionalSet = true;
                        } else if (property.equals(NULLABLE)) {
                            DataSetParametersPage.this.isNullableSet = true;
                        }
                    }
                } else if (property.equals(DATA_TYPE)) {
                    int selectedType = (Integer)value;
                    finalValue = selectedType > 0 ? DataSetParametersPage.this.getTypeString(selectedType) : null;
                }
                if (property.equals(NAME)) {
                    if (actualElement != DataSetParametersPage.this.newParameter && (finalValue == null || ((String)finalValue).trim().length() == 0)) {
                        ExceptionHandler.openMessageBox(ERROR_DLG_TITLE, ERROR_MSG_EMPTY_COLUMN_NAME, 2);
                        DataSetParametersPage.this.viewer.getViewer().update(actualElement, null);
                        return;
                    }
                    if (!DataSetParametersPage.this.isUniqueName(actualElement, (String)finalValue)) {
                        DataSetParametersPage.this.viewer.getViewer().update(actualElement, null);
                        return;
                    }
                }
                try {
                    Utility.setProperty(actualElement, finalProperty, finalValue);
                    DataSetParametersPage.this.viewer.getViewer().update(actualElement, null);
                    if (actualElement == DataSetParametersPage.this.newParameter) {
                        DataSetParametersPage.this.isDataTypeSet = true;
                        if (DataSetParametersPage.this.newParameter.getName() != null && DataSetParametersPage.this.newParameter.getName().trim().length() > 0) {
                            DataSetParametersPage.this.parameters.addItem((IStructure)DataSetParametersPage.this.newParameter);
                            DataSetParametersPage.this.clearNewParameter();
                            DataSetParametersPage.this.viewer.getViewer().refresh();
                        }
                    }
                    DataSetParametersPage.this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle(ex);
                }
            }
        });
    }

    private void addListeners() {
        this.viewer.getViewer().getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    DataSetParametersPage.this.removeSelectedItem();
                    DataSetParametersPage.this.setPageProperties();
                }
            }
        });
        this.viewer.getRemoveButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetParametersPage.this.removeSelectedItem();
                DataSetParametersPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetParametersPage.this.removeSelectedItem();
                DataSetParametersPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveAllMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetParametersPage.this.removeAllItem();
                DataSetParametersPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.viewer.getViewer().addSelectionChangedListener((ISelectionChangedListener)new ViewerSelectionListener());
    }

    protected int getDirectionIndex(Boolean isInput, Boolean isOutput) {
        boolean output;
        boolean input = isInput == null ? false : isInput;
        boolean bl = output = isOutput == null ? false : isOutput;
        if (input && output) {
            return 2;
        }
        if (output) {
            return 1;
        }
        return 0;
    }

    protected String getDirectionDisplayName(boolean isInput, boolean isOutput) {
        if (isInput && isOutput) {
            return directions[2];
        }
        if (isOutput) {
            return directions[1];
        }
        return directions[0];
    }

    private final int getTypeIndex(String dataTypeName) {
        for (int n = 0; n < dataTypes.length; ++n) {
            if (!dataTypes[n].equals(dataTypeName)) continue;
            return n;
        }
        return 0;
    }

    private final String getTypeString(int index) {
        if (index > -1 && index < dataTypes.length) {
            return dataTypes[index];
        }
        return null;
    }

    private final String getBooleanDisplayName(boolean value) {
        return value ? Messages.getString((String)"label.yes") : Messages.getString((String)"label.no");
    }

    private final String getTypeDisplayName(String typeName) {
        for (int n = 0; n < dataTypes.length; ++n) {
            if (!dataTypes[n].equals(typeName)) continue;
            return dataTypeDisplayNames[n];
        }
        return dataTypeDisplayNames[0];
    }

    public void pageActivated() {
        this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
        if (!this.doSaveEmptyParameter(this.parameters)) {
            this.getContainer().setMessage(Messages.getFormattedString((String)"dataset.editor.error.noInputParameterDefaultValue", (Object[])new Object[]{this.getNoneValuedParameterName()}), 3);
        }
        if (this.viewer != null) {
            this.viewer.getViewer().refresh();
        }
        this.setPageProperties();
    }

    private void refreshParameters() {
        try {
            DataSetHandle ds = (DataSetHandle)this.getContainer().getModel();
            Collection paramsFromDataSet = null;
            paramsFromDataSet = DataSetProvider.getCurrentInstance().getParametersFromDataSet(ds);
            if (paramsFromDataSet != null) {
                Iterator iter = paramsFromDataSet.iterator();
                while (iter.hasNext()) {
                    IParameterMetaData paramFromDataSet = (IParameterMetaData)iter.next();
                    DataSetParameter parameter = null;
                    parameter = paramFromDataSet.getPosition() > 0 ? this.findParameterByPosition(paramFromDataSet.getPosition()) : this.findParameterByName(paramFromDataSet.getName());
                    if (parameter != null) {
                        DataSetParameter newParameter = this.newParameter(paramFromDataSet);
                        if (this.isSameParameters(parameter, newParameter)) continue;
                        this.parameters.replaceItem((IStructure)parameter, (IStructure)newParameter);
                        continue;
                    }
                    this.parameters.addItem((IStructure)this.newParameter(paramFromDataSet));
                }
                if (this.parameters.getListValue() != null && paramsFromDataSet.size() < this.parameters.getListValue().size()) {
                    int size = this.parameters.getListValue().size();
                    while (size > paramsFromDataSet.size()) {
                        this.parameters.removeItem(size - 1);
                        size = this.parameters.getListValue().size();
                    }
                }
            } else if (this.viewer != null) {
                PropertyHandle handle = (PropertyHandle)this.viewer.getViewer().getInput();
                handle.clearValue();
            }
            this.refreshPositions();
            this.setPageProperties();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private DataSetParameter newParameter(IParameterMetaData paramFromDataSet) {
        DataSetParameter parameter = new DataSetParameter();
        try {
            parameter.setDataType(DataSetParametersPage.toModelDataType(paramFromDataSet.getDataTypeName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        parameter.setDefaultValue(paramFromDataSet.getDefaultInputValue());
        if (paramFromDataSet.isOptional() != null) {
            parameter.setIsOptional(paramFromDataSet.isOptional().booleanValue());
        }
        if (paramFromDataSet.isNullable() != null) {
            parameter.setAllowNull(paramFromDataSet.isNullable().booleanValue());
        }
        if (paramFromDataSet.isInputMode() != null) {
            parameter.setIsInput(paramFromDataSet.isInputMode().booleanValue());
        }
        if (paramFromDataSet.isOutputMode() != null) {
            parameter.setIsOutput(paramFromDataSet.isOutputMode().booleanValue());
        }
        if (paramFromDataSet.isInputMode() == null && paramFromDataSet.isOutputMode() == null || !parameter.isInput() && !parameter.isOutput()) {
            parameter.setIsInput(true);
        }
        parameter.setName(paramFromDataSet.getName());
        if (parameter.getName() == null) {
            parameter.setName(this.getUniqueName());
        }
        return parameter;
    }

    private boolean isSameParameters(DataSetParameter param1, DataSetParameter param2) {
        boolean isSame = false;
        if (param1 == param2) {
            isSame = true;
        } else if (param1 == null || param2 == null) {
            isSame = false;
        } else if (param1.getDataType().equals(param2.getDataType()) && param1.isInput() == param2.isInput() && param1.isOutput() == param2.isOutput()) {
            isSame = true;
        }
        return isSame;
    }

    private static String toModelDataType(String dteDTName) {
        if (dteDTName == null) {
            return null;
        }
        String modelDataType = dteDTName;
        if (dteDTName.equals(DataType.ANY_TYPE_NAME)) {
            modelDataType = "any";
        } else if (dteDTName.equals(DataType.INTEGER_TYPE_NAME)) {
            modelDataType = "integer";
        } else if (dteDTName.equals(DataType.DOUBLE_TYPE_NAME)) {
            modelDataType = "float";
        } else if (dteDTName.equals(DataType.DECIMAL_TYPE_NAME)) {
            modelDataType = "decimal";
        } else if (dteDTName.equals(DataType.STRING_TYPE_NAME)) {
            modelDataType = "string";
        } else if (dteDTName.equals(DataType.DATE_TYPE_NAME)) {
            modelDataType = "date-time";
        } else if (dteDTName.equals(DataType.BINARY_TYPE_NAME)) {
            modelDataType = "any";
        }
        return modelDataType;
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        this.modelChanged = true;
    }

    protected final DataSetParameter findParameterByPosition(int position) {
        Iterator iter;
        if (this.parameters != null && (iter = this.parameters.iterator()) != null) {
            while (iter.hasNext()) {
                DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                if (parameter.getPosition() == null || parameter.getPosition() != position) continue;
                return (DataSetParameter)parameter.getStructure();
            }
        }
        return null;
    }

    protected final DataSetParameter findParameterByName(String name) {
        Iterator iter;
        if (this.parameters != null && (iter = this.parameters.iterator()) != null) {
            while (iter.hasNext()) {
                DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                if (name == null || !name.equals(parameter.getName())) continue;
                return (DataSetParameter)parameter.getStructure();
            }
        }
        return null;
    }

    protected final void refreshPositions() {
        if (this.parameters != null) {
            int position = 1;
            Iterator iter = this.parameters.iterator();
            if (iter != null) {
                while (iter.hasNext()) {
                    DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                    parameter.setPosition(new Integer(position++));
                }
            }
        }
    }

    protected final String getUniqueName() {
        int n = 1;
        String prefix = "param";
        StringBuffer buf = new StringBuffer();
        while (buf.length() == 0) {
            Iterator iter;
            buf.append(prefix).append(n++);
            if (this.parameters == null || (iter = this.parameters.iterator()) == null) continue;
            while (iter.hasNext() && buf.length() > 0) {
                DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                if (!buf.toString().equalsIgnoreCase(parameter.getName())) continue;
                buf.setLength(0);
            }
        }
        return buf.toString();
    }

    public boolean performCancel() {
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return super.performCancel();
    }

    public boolean performOk() {
        if (this.doSaveEmptyParameter(this.parameters)) {
            this.refreshPositions();
            if (this.modelChanged && this.getContainer() != null && this.getContainer() instanceof DataSetEditor) {
                this.modelChanged = false;
                ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
                ((DataSetEditor)this.getContainer()).updateDataSetDesign("parameters");
            }
            return super.performOk();
        }
        String name = this.getNoneValuedParameterName();
        boolean confirm = MessageDialog.openConfirm(null, (String)Messages.getString((String)"dataset.editor.error.title"), (String)Messages.getFormattedString((String)"dataset.editor.error.validationParameter", (Object[])new Object[]{name}));
        if (confirm) {
            ((DataSetEditor)this.getContainer()).updateDataSetDesign("parameters");
        }
        return confirm;
    }

    private boolean doSaveEmptyParameter(PropertyHandle parameters) {
        Iterator iter;
        if (parameters == null) {
            parameters = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("parameters");
        }
        if (parameters != null && (iter = parameters.iterator()) != null) {
            while (iter.hasNext()) {
                DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                if (!parameter.isInput() || parameter.getDefaultValue() != null && parameter.getDefaultValue().trim().length() != 0 && !parameter.getDefaultValue().trim().equalsIgnoreCase("null")) continue;
                this.setNoneValuedParameterName(parameter.getName());
                return false;
            }
        }
        return true;
    }

    public boolean canLeave() {
        this.refreshPositions();
        if (this.modelChanged && this.getContainer() != null && this.getContainer() instanceof DataSetEditor) {
            this.modelChanged = false;
            ((DataSetEditor)this.getContainer()).updateDataSetDesign("parameters");
        }
        return true;
    }

    public boolean canFinish() {
        this.refreshPositions();
        return this.doSaveEmptyParameter(this.parameters);
    }

    private void clearNewParameter() {
        this.newParameter = null;
        this.isDirectionSet = false;
        this.isOptionalSet = false;
        this.isNullableSet = false;
        this.isDataTypeSet = false;
        this.viewer.getViewer().refresh();
    }

    private void removeSelectedItem() {
        int count;
        int index = this.viewer.getViewer().getTable().getSelectionIndex();
        int n = count = this.parameters.getListValue() == null ? 0 : this.parameters.getListValue().size();
        if (index == count) {
            this.clearNewParameter();
            this.viewer.getViewer().refresh();
        }
    }

    private void removeAllItem() {
        this.clearNewParameter();
        this.viewer.getViewer().refresh();
    }

    private boolean isUniqueName(Object dataSetParameter, String name) {
        DataSetParameter parameter = null;
        parameter = dataSetParameter instanceof DataSetParameterHandle ? (DataSetParameter)((DataSetParameterHandle)dataSetParameter).getStructure() : (DataSetParameter)dataSetParameter;
        Iterator iter = this.parameters.iterator();
        if (iter != null) {
            while (iter.hasNext()) {
                DataSetParameterHandle handle = (DataSetParameterHandle)iter.next();
                if (parameter == handle.getStructure() || !handle.getName().equals(name)) continue;
                this.getContainer().setMessage(Messages.getString((String)"dataset.editor.error.duplicateParameterName"), 3);
                return false;
            }
        }
        return true;
    }

    private void setPageProperties() {
        boolean parametersExist = false;
        boolean bl = parametersExist = this.parameters != null && this.parameters.getListValue() != null && this.parameters.getListValue().size() > 0;
        if (this.viewer != null) {
            this.viewer.getDownButton().setEnabled(parametersExist);
            this.viewer.getUpButton().setEnabled(parametersExist);
            this.viewer.getRemoveButton().setEnabled(parametersExist);
            this.viewer.getRemoveMenuItem().setEnabled(parametersExist);
            this.viewer.getRemoveAllMenuItem().setEnabled(parametersExist);
        }
        if (!parametersExist) {
            this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
        }
    }

    public String getToolTip() {
        return Messages.getString((String)"DataSetParametersPage.Filter.Tooltip");
    }

    public String getNoneValuedParameterName() {
        return this.parameterName;
    }

    private void setNoneValuedParameterName(String name) {
        this.parameterName = name;
    }

    private class ViewerSelectionListener
    implements ISelectionChangedListener {
        private ViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            DataSetParametersPage.this.setPageProperties();
        }
    }
}

