/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.data.ui.dataset.OutputColumnsContentProvider;
import org.eclipse.birt.report.designer.data.ui.dataset.OutputColumnsLabelProvider;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Utility;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public final class OutputColumnsPage
extends AbstractDescriptionPropertyPage
implements Listener {
    private transient TableViewer outputColumnsViewer = null;
    private transient boolean modelChanged = true;
    private transient PropertyHandle resultSetColumnPropertyHandle = null;

    public Control createContents(Composite parent) {
        this.resultSetColumnPropertyHandle = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("resultSetHints");
        this.outputColumnsViewer = new TableViewer(parent, 65536);
        this.outputColumnsViewer.getTable().setHeaderVisible(true);
        this.outputColumnsViewer.getTable().setLinesVisible(true);
        TableColumn column = new TableColumn(this.outputColumnsViewer.getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.name"));
        column.setWidth(100);
        column = new TableColumn(this.outputColumnsViewer.getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.type"));
        column.setWidth(100);
        column = new TableColumn(this.outputColumnsViewer.getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.alias"));
        column.setWidth(100);
        column = new TableColumn(this.outputColumnsViewer.getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.displayName"));
        column.setWidth(100);
        this.outputColumnsViewer.setContentProvider((IContentProvider)new OutputColumnsContentProvider());
        this.outputColumnsViewer.setLabelProvider((IBaseLabelProvider)new OutputColumnsLabelProvider());
        this.setupEditors();
        ((DataSetHandle)this.getContainer().getModel()).addListener((Listener)this);
        return this.outputColumnsViewer.getControl();
    }

    private void setupEditors() {
        CellEditor[] editors = new CellEditor[5];
        editors[0] = new TextCellEditor((Composite)this.outputColumnsViewer.getTable());
        editors[2] = new TextCellEditor((Composite)this.outputColumnsViewer.getTable());
        editors[3] = new TextCellEditor((Composite)this.outputColumnsViewer.getTable());
        editors[4] = new TextCellEditor((Composite)this.outputColumnsViewer.getTable());
        this.outputColumnsViewer.setColumnProperties(new String[]{"name", "dataTypeName", "alias", "realDisplayName", "helpText"});
        this.outputColumnsViewer.setCellEditors(editors);
        this.outputColumnsViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if ("name".equals(property)) {
                    String name = ((DataSetViewData)element).getDataSetColumnName();
                    return name == null || name.trim().length() == 0;
                }
                return true;
            }

            public Object getValue(Object element, String property) {
                String value = null;
                try {
                    value = (String)Utility.getProperty(element, property);
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                }
                return value == null ? "" : value;
            }

            public void modify(Object element, String property, Object value) {
                DataSetViewData item = (DataSetViewData)((TableItem)element).getData();
                try {
                    Utility.setProperty(item, property, value);
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                }
                if ("name".equals(property)) {
                    OutputColumnsPage.this.updateResultSetColumn(item);
                }
                OutputColumnsPage.this.outputColumnsViewer.update((Object)item, null);
                OutputColumnsPage.this.updateMessage();
            }
        });
    }

    private final void updateResultSetColumn(DataSetViewData column) {
        ResultSetColumn resultSetColumn;
        if (this.resultSetColumnPropertyHandle == null) {
            return;
        }
        Iterator iter = this.resultSetColumnPropertyHandle.iterator();
        boolean found = false;
        if (iter != null) {
            while (iter.hasNext() && !found) {
                resultSetColumn = (ResultSetColumnHandle)iter.next();
                if (resultSetColumn.getPosition().intValue() != column.getPosition()) continue;
                found = true;
                resultSetColumn.setColumnName(column.getName());
                try {
                    resultSetColumn.setDataType(column.getDataTypeName());
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                }
            }
        }
        if (!found) {
            resultSetColumn = new ResultSetColumn();
            resultSetColumn.setPosition(new Integer(column.getPosition()));
            resultSetColumn.setColumnName(column.getName());
            resultSetColumn.setDataType(column.getDataTypeName());
            try {
                if (this.resultSetColumnPropertyHandle != null) {
                    this.resultSetColumnPropertyHandle.addItem((IStructure)resultSetColumn);
                }
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    protected final void updateOutputColumns() {
        this.clearOutputColumns();
        this.outputColumnsViewer.setInput((Object)((DataSetEditor)this.getContainer()).getCurrentItemModel(false, false));
    }

    protected final void clearOutputColumns() {
        this.outputColumnsViewer.getTable().removeAll();
    }

    private final void clearUnusedData() {
        this.clearUnusedColumnHints();
        this.clearUnusedResultSetColumns();
    }

    private final void clearUnusedColumnHints() {
        DataSetViewData[] items = null;
        items = this.outputColumnsViewer == null ? DataSetProvider.getCurrentInstance().getColumns(((DataSetEditor)this.getContainer()).getHandle(), false, true, true) : (DataSetViewData[])this.outputColumnsViewer.getInput();
        PropertyHandle handle = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("columnHints");
        ArrayList list = handle.getListValue();
        if (list != null) {
            int count = list.size();
            for (int n = count - 1; n >= 0; --n) {
                ColumnHint hint = (ColumnHint)list.get(n);
                String columnName = (String)hint.getProperty((Module)handle.getDesign(), "columnName");
                boolean found = false;
                if (!this.isEmpty(hint, handle.getModule().getModuleHandle())) {
                    for (int m = 0; m < items.length && !found; ++m) {
                        found = columnName.equals(items[m].getName());
                    }
                }
                if (found) continue;
                try {
                    handle.removeItem((IStructure)hint);
                    continue;
                }
                catch (PropertyValueException e) {
                    ExceptionHandler.handle(e);
                }
            }
        }
    }

    private boolean isEmpty(ColumnHint hint, ModuleHandle designHandle) {
        String alias = (String)hint.getProperty(designHandle.getModule(), "alias");
        String displayName = (String)hint.getProperty(designHandle.getModule(), "displayName");
        String helpText = (String)hint.getProperty(designHandle.getModule(), "helpText");
        return !(alias != null && alias.trim().length() != 0 || displayName != null && displayName.trim().length() != 0 || helpText != null && helpText.trim().length() != 0);
    }

    private final void clearUnusedResultSetColumns() {
        DataSetViewData[] items = null;
        items = this.outputColumnsViewer == null ? DataSetProvider.getCurrentInstance().getColumns(((DataSetEditor)this.getContainer()).getHandle(), false, true, true) : (DataSetViewData[])this.outputColumnsViewer.getInput();
        if (this.resultSetColumnPropertyHandle == null) {
            this.resultSetColumnPropertyHandle = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("resultSetHints");
        }
        ArrayList list = null;
        if (this.resultSetColumnPropertyHandle != null) {
            list = this.resultSetColumnPropertyHandle.getListValue();
        }
        if (list != null) {
            int count = list.size();
            for (int n = count - 1; n >= 0; --n) {
                ResultSetColumn column = (ResultSetColumn)list.get(n);
                boolean found = false;
                for (int m = 0; m < items.length && !found; ++m) {
                    found = items[m].getPosition() == column.getPosition().intValue() && (column.getColumnName() == null || column.getColumnName().equals(items[m].getName()));
                }
                if (found) continue;
                try {
                    if (this.resultSetColumnPropertyHandle == null) continue;
                    this.resultSetColumnPropertyHandle.removeItem((IStructure)column);
                    continue;
                }
                catch (PropertyValueException e) {
                    ExceptionHandler.handle(e);
                }
            }
        }
    }

    public void pageActivated() {
        if (this.modelChanged) {
            this.updateOutputColumns();
            this.modelChanged = false;
        }
        this.getContainer().setMessage(Messages.getString((String)"dataset.editor.outputColumns"), 0);
    }

    public boolean canLeave() {
        if (this.isValid()) {
            this.saveOutputColumns();
            return super.canLeave();
        }
        return false;
    }

    private void saveOutputColumns() {
        PropertyHandle handle = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("columnHints");
        if (this.outputColumnsViewer != null && this.outputColumnsViewer.getInput() != null) {
            DataSetViewData[] items = (DataSetViewData[])this.outputColumnsViewer.getInput();
            String columnName = null;
            boolean found = false;
            for (int n = 0; n < items.length; ++n) {
                ColumnHintHandle hint;
                columnName = items[n].getName();
                found = false;
                Iterator iter = handle.iterator();
                if (iter != null) {
                    while (iter.hasNext() && !found) {
                        hint = (ColumnHintHandle)iter.next();
                        if (!hint.getColumnName().equals(columnName)) continue;
                        found = true;
                        if (items[n].getRealDisplayName() == null || items[n].getRealDisplayName().trim().length() == 0) {
                            hint.setDisplayName(null);
                        } else {
                            hint.setDisplayName(items[n].getRealDisplayName());
                        }
                        if (items[n].getAlias() == null || items[n].getAlias().trim().length() == 0) {
                            hint.setAlias(null);
                        } else {
                            hint.setAlias(items[n].getAlias());
                        }
                        if (items[n].getHelpText() == null || items[n].getHelpText().trim().length() == 0) {
                            hint.setHelpText(null);
                            continue;
                        }
                        hint.setHelpText(items[n].getHelpText());
                    }
                }
                if (found || !this.isColumnHintRequired(items[n])) continue;
                hint = new ColumnHint();
                hint.setProperty("columnName", (Object)columnName);
                if (items[n].getRealDisplayName() != null && items[n].getRealDisplayName().trim().length() > 0) {
                    hint.setProperty("displayName", (Object)items[n].getRealDisplayName());
                }
                if (items[n].getAlias() != null && items[n].getAlias().trim().length() > 0) {
                    hint.setProperty("alias", (Object)items[n].getAlias());
                }
                if (items[n].getHelpText() != null && items[n].getHelpText().trim().length() > 0) {
                    hint.setProperty("helpText", (Object)items[n].getHelpText());
                }
                try {
                    handle.addItem((IStructure)hint);
                    continue;
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                }
            }
        }
    }

    private boolean isValid() {
        boolean validate = true;
        DataSetViewData[] items = null;
        items = this.outputColumnsViewer == null ? DataSetProvider.getCurrentInstance().getColumns(((DataSetEditor)this.getContainer()).getHandle(), false, true, true) : (DataSetViewData[])this.outputColumnsViewer.getInput();
        block0: for (int i = 0; i < items.length && validate; ++i) {
            String newColumnNameOrAlias = items[i].getAlias();
            if (newColumnNameOrAlias == null || newColumnNameOrAlias.length() <= 0) continue;
            for (int n = 0; n < items.length; ++n) {
                if (i == n || (items[n].getName() == null || !items[n].getName().equals(newColumnNameOrAlias)) && (items[n].getAlias() == null || !items[n].getAlias().equals(newColumnNameOrAlias))) continue;
                validate = false;
                this.getContainer().setMessage(Messages.getFormattedString((String)"dataset.editor.error.columnOrAliasNameAlreadyUsed", (Object[])new Object[]{newColumnNameOrAlias, new Integer(n + 1)}), 3);
                continue block0;
            }
        }
        return validate;
    }

    private void updateMessage() {
        if (this.isValid()) {
            this.getContainer().setMessage(Messages.getString((String)"dataset.editor.outputColumns"), 0);
        }
    }

    private boolean isColumnHintRequired(DataSetViewData model) {
        return model.getRealDisplayName() != null && model.getRealDisplayName().trim().length() != 0 || model.getAlias() != null && model.getAlias().trim().length() != 0 || model.getHelpText() != null && model.getHelpText().trim().length() != 0;
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (focus.equals(this.getContainer().getModel())) {
            this.modelChanged = true;
        }
    }

    public boolean performCancel() {
        if (this.outputColumnsViewer != null && this.outputColumnsViewer.getInput() != null) {
            DataSetProvider manager = DataSetProvider.getCurrentInstance();
            manager.updateModel(((DataSetEditor)this.getContainer()).getHandle(), (DataSetViewData[])this.outputColumnsViewer.getInput());
        }
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return super.performCancel();
    }

    public boolean performOk() {
        if (this.isValid()) {
            this.saveOutputColumns();
            this.clearUnusedData();
            ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
            return super.performOk();
        }
        return false;
    }

    public String getPageDescription() {
        return Messages.getString((String)"OutputColumnsPage.description");
    }

    public String getToolTip() {
        return Messages.getString((String)"OutputColumnPage.OutputColumns.Tooltip");
    }
}

