/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.datasource;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.elements.interfaces.IDesignElementModel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PropertyBindingPage
extends AbstractDescriptionPropertyPage {
    private IDesignElementModel ds;
    private List bindingName = new ArrayList();
    private List displayName = new ArrayList();
    private List bindingValue = new ArrayList();
    private List nameLabelList = new ArrayList();
    private List propertyTextList = new ArrayList();
    private List buttonList = new ArrayList();
    private final String QUERYTEXT = "queryText";
    private final String PASSWORD = "odaPassword";

    public Control createContents(Composite parent) {
        this.initPropertyBinding();
        int size = this.bindingName.size();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(272);
        composite.setLayoutData((Object)gridData);
        for (int i = 0; i < size; ++i) {
            Text propertyText;
            Label nameLabel = new Label(composite, 0);
            nameLabel.setText((String)this.displayName.get(i) + ":");
            this.nameLabelList.add(nameLabel);
            GridData data = new GridData(768);
            if (((String)this.bindingName.get(i)).equals("queryText")) {
                propertyText = new Text(composite, 2816);
                data.heightHint = 100;
            } else {
                propertyText = ((String)this.bindingName.get(i)).equals("odaPassword") ? new Text(composite, 0x400800) : new Text(composite, 2048);
            }
            propertyText.setLayoutData((Object)data);
            propertyText.setText((String)this.bindingValue.get(i) == null ? "" : (String)this.bindingValue.get(i));
            this.propertyTextList.add(propertyText);
            Button buildButton = new Button(composite, 0);
            buildButton.setText("...");
            this.buttonList.add(buildButton);
        }
        this.addListener();
        if (size <= 0) {
            this.setEmptyPropertyMessages(composite);
        }
        return composite;
    }

    private void addListener() {
        for (int i = 0; i < this.buttonList.size(); ++i) {
            Button buildButton = (Button)this.buttonList.get(i);
            final Text text = (Text)this.propertyTextList.get(i);
            final String name = (String)this.bindingName.get(i);
            buildButton.setToolTipText("Open expression builder to input " + this.displayName.get(i) + "value");
            buildButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String str = "";
                    str = name.equals("odaPassword") ? "" : text.getText();
                    ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), str);
                    if (dialog.open() == 0) {
                        str = dialog.getResult();
                        text.setText(str);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    private void initPropertyBinding() {
        long id = -1L;
        List bindingList = null;
        if (this.getContainer().getModel() instanceof DataSourceHandle) {
            this.ds = (DataSourceHandle)this.getContainer().getModel();
            bindingList = ((DataSourceHandle)this.ds).getModuleHandle().getListProperty("propertyBindings");
            id = ((DataSourceHandle)this.ds).getID();
        } else if (this.getContainer().getModel() instanceof DataSetHandle) {
            this.ds = (DataSetHandle)this.getContainer().getModel();
            bindingList = ((DataSetHandle)this.ds).getModuleHandle().getListProperty("propertyBindings");
            id = ((DataSetHandle)this.ds).getID();
        }
        if (bindingList == null) {
            this.setDefaultProperty();
        } else {
            Iterator iterator = bindingList.iterator();
            IElementDefn elementDefn = this.getElementDefn();
            ArrayList<PropertyBinding> propertyBindingList = new ArrayList<PropertyBinding>();
            while (iterator.hasNext()) {
                PropertyBinding binding = (PropertyBinding)iterator.next();
                if (binding.getID().longValue() != id) continue;
                this.bindingName.add(binding.getName());
                this.displayName.add(elementDefn.getProperty(binding.getName()).getDisplayName());
                this.bindingValue.add(binding.getValue());
                propertyBindingList.add(binding);
            }
            if (propertyBindingList != null && propertyBindingList.size() == 0) {
                this.setDefaultProperty();
            }
        }
    }

    private void setDefaultProperty() {
        Iterator iterator = null;
        IElementDefn elementDefn = this.getElementDefn();
        if (elementDefn != null) {
            iterator = elementDefn.getProperties().iterator();
        }
        if (this.ds instanceof DataSetHandle && ((DataSetHandle)this.ds).getPropertyHandle("queryText").isVisible()) {
            this.bindingName.add("queryText");
            this.displayName.add(Messages.getString((String)"PropertyBindingPage.dataset.queryText"));
            this.bindingValue.add("");
        } else if (this.ds instanceof DataSetHandle) {
            iterator = ((DataSetHandle)this.ds).getDefn().getProperties().iterator();
            elementDefn = ((DataSetHandle)this.ds).getDefn();
            if (((DataSetHandle)this.ds).getPropertyHandle("queryText").isVisible()) {
                this.bindingName.add("queryText");
                this.bindingValue.add("");
            }
        }
        while (iterator != null && iterator.hasNext()) {
            IElementPropertyDefn propertyDefn = (IElementPropertyDefn)iterator.next();
            if (!(propertyDefn instanceof IPropertyDefn) || propertyDefn.getValueType() != 4) continue;
            String name = propertyDefn.getName();
            if (elementDefn != null && !elementDefn.isPropertyVisible(name)) continue;
            this.bindingName.add(name);
            this.displayName.add(propertyDefn.getDisplayName());
            this.bindingValue.add("");
        }
    }

    private IElementDefn getElementDefn() {
        IElementDefn elementDefn = null;
        if (this.ds instanceof DataSourceHandle) {
            elementDefn = ((DataSourceHandle)this.ds).getDefn();
        } else if (this.ds instanceof DataSetHandle) {
            elementDefn = ((DataSetHandle)this.ds).getDefn();
        }
        return elementDefn;
    }

    public boolean performOk() {
        if (this.isUsePropertyBinding()) {
            for (int i = 0; i < this.bindingName.size(); ++i) {
                try {
                    if (this.ds instanceof DataSourceHandle) {
                        ((DataSourceHandle)this.ds).setPropertyBinding((String)this.bindingName.get(i), ((Text)this.propertyTextList.get(i)).getText());
                        continue;
                    }
                    if (!(this.ds instanceof DataSetHandle)) continue;
                    ((DataSetHandle)this.ds).setPropertyBinding((String)this.bindingName.get(i), ((Text)this.propertyTextList.get(i)).getText());
                    continue;
                }
                catch (SemanticException e) {
                    e.printStackTrace();
                }
            }
        } else {
            for (int i = 0; i < this.bindingName.size(); ++i) {
                try {
                    if (this.ds instanceof DataSourceHandle) {
                        ((DataSourceHandle)this.ds).setPropertyBinding((String)this.bindingName.get(i), null);
                        continue;
                    }
                    if (!(this.ds instanceof DataSetHandle)) continue;
                    ((DataSetHandle)this.ds).setPropertyBinding((String)this.bindingName.get(i), null);
                    continue;
                }
                catch (SemanticException e) {
                    e.printStackTrace();
                }
            }
        }
        return super.performOk();
    }

    private boolean isUsePropertyBinding() {
        boolean useBinding = false;
        for (int i = 0; i < this.propertyTextList.size(); ++i) {
            if (((Text)this.propertyTextList.get(i)).getText() == null || ((Text)this.propertyTextList.get(i)).getText().trim().length() <= 0) continue;
            useBinding = true;
            return useBinding;
        }
        return useBinding;
    }

    private void setEmptyPropertyMessages(Composite composite) {
        Label messageLabel = new Label(composite, 0);
        if (this.ds instanceof DataSourceHandle) {
            messageLabel.setText(Messages.getString((String)"PropertyBindingPage.datasource.property.empty"));
        } else if (this.ds instanceof DataSetHandle) {
            messageLabel.setText(Messages.getString((String)"PropertyBindingPage.dataset.property.empty"));
        }
    }

    public void pageActivated() {
        this.getContainer().setMessage(Messages.getString((String)"datasource.editor.property"), 0);
    }

    public String getToolTip() {
        return Messages.getString((String)"PropertyBindingPage.property.tooltip");
    }
}

