/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.AbstractFieldEditor;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ComboBoxMeasureFieldEditor
extends AbstractFieldEditor {
    private Composite parent;
    private Combo fCombo;
    private Text fText;
    private Combo fmeasure;
    private boolean hasChoice;
    private String[][] fBoxNamesAndValues;
    private String[][] fMeasureNamesAndValues;

    public ComboBoxMeasureFieldEditor(String prop_name, String labelText, String[][] entryNamesAndValues, String[][] measureNamesAndValues, Composite parent) {
        this.hasChoice = true;
        this.init(prop_name, labelText);
        Assert.isTrue((boolean)this.checkArray(entryNamesAndValues));
        Assert.isTrue((boolean)this.checkArray(measureNamesAndValues));
        this.fBoxNamesAndValues = entryNamesAndValues;
        this.fMeasureNamesAndValues = measureNamesAndValues;
        this.parent = parent;
        this.createControl(parent);
    }

    public ComboBoxMeasureFieldEditor(String prop_name, String labelText, String[][] measureNamesAndValues, Composite parent) {
        this.hasChoice = false;
        this.init(prop_name, labelText);
        Assert.isTrue((boolean)this.checkArray(measureNamesAndValues));
        this.fMeasureNamesAndValues = measureNamesAndValues;
        this.parent = parent;
        this.createControl(parent);
    }

    private boolean checkArray(String[][] table) {
        if (table == null) {
            return false;
        }
        for (int i = 0; i < table.length; ++i) {
            String[] array = table[i];
            if (array != null && array.length == 2) continue;
            return false;
        }
        return true;
    }

    public int getNumberOfControls() {
        return 3;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = 1;
            --numColumns;
        }
        if (this.hasChoice) {
            ((GridData)this.getComboBoxControl((Composite)this.parent).getLayoutData()).horizontalSpan = 1;
            ((GridData)this.getComboBoxControl((Composite)this.parent).getLayoutData()).widthHint = 70;
        } else {
            ((GridData)this.getTextControl((Composite)this.parent).getLayoutData()).horizontalSpan = 1;
            ((GridData)this.getTextControl((Composite)this.parent).getLayoutData()).widthHint = 85;
        }
        ((GridData)this.getMeasureControl((Composite)this.parent).getLayoutData()).horizontalSpan = --numColumns;
        ((GridData)this.getMeasureControl((Composite)this.parent).getLayoutData()).widthHint = 65;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getValueControl(parent);
        gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getMeasureControl(parent);
        gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
    }

    protected void doLoadDefault() {
    }

    protected void doLoad() {
        String value = this.getPreferenceStore().getString(this.getPreferenceName());
        String[] sptValue = DEUtil.splitString((String)value);
        if (this.hasChoice) {
            if (sptValue[0] == null) {
                if (!this.updateComboForValue(sptValue[1])) {
                    this.fCombo.setText(this.resolveNull(sptValue[1]));
                }
            } else {
                this.fCombo.setText(this.resolveNull(sptValue[0]));
                this.updateMeasureForValue(sptValue[1]);
            }
        } else if (sptValue[0] == null) {
            this.fText.setText(this.resolveNull(sptValue[1]));
        } else {
            this.fText.setText(this.resolveNull(sptValue[0]));
            this.updateMeasureForValue(sptValue[1]);
        }
        this.setOldValue(this.getStringValue());
    }

    private boolean updateComboForValue(String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < this.fBoxNamesAndValues.length; ++i) {
            if (!value.equals(this.fBoxNamesAndValues[i][1])) continue;
            this.fCombo.setText(this.fBoxNamesAndValues[i][0]);
            return true;
        }
        return false;
    }

    private void updateMeasureForValue(String value) {
        if (value == null) {
            this.fmeasure.setText("");
            return;
        }
        for (int i = 0; i < this.fMeasureNamesAndValues.length; ++i) {
            if (!value.equals(this.fMeasureNamesAndValues[i][1])) continue;
            this.fmeasure.setText(this.fMeasureNamesAndValues[i][0]);
            return;
        }
        if (this.fMeasureNamesAndValues.length > 0) {
            this.fmeasure.setText("");
        }
    }

    private String resolveNull(String src) {
        return src == null ? "" : src;
    }

    protected String getStringValue() {
        if (this.hasChoice) {
            if (this.InComboNamesList(this.getComboBoxControl(this.parent).getText())) {
                return this.getBoxValueForName(this.getComboBoxControl(this.parent).getText());
            }
            return this.getComboBoxControl(this.parent).getText() + this.getMeasureValueForName(this.getMeasureControl(this.parent).getText());
        }
        return this.getTextControl(this.parent).getText() + this.getMeasureValueForName(this.getMeasureControl(this.parent).getText());
    }

    public boolean InComboNamesList(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < this.fBoxNamesAndValues.length; ++i) {
            if (!name.equals(this.fBoxNamesAndValues[i][0])) continue;
            return true;
        }
        return false;
    }

    public Control getValueControl(Composite parent) {
        if (this.hasChoice) {
            return this.getComboBoxControl(parent);
        }
        return this.getTextControl(parent);
    }

    public Text getTextControl(Composite parent) {
        if (this.hasChoice) {
            return null;
        }
        if (this.fText == null) {
            this.fText = new Text(parent, 2048);
            this.fText.setFont(parent.getFont());
            this.fText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String text = ComboBoxMeasureFieldEditor.this.fText.getText();
                    if (!DEUtil.isValidNumber((String)text)) {
                        ComboBoxMeasureFieldEditor.this.fmeasure.deselectAll();
                        ComboBoxMeasureFieldEditor.this.fmeasure.setEnabled(false);
                    } else if (!ComboBoxMeasureFieldEditor.this.fmeasure.isEnabled()) {
                        String unit = ComboBoxMeasureFieldEditor.this.getDefaultUnit();
                        if (!StringUtil.isBlank((String)unit)) {
                            unit = DesignEngine.getMetaDataDictionary().getChoiceSet("units").findChoice(unit).getDisplayName();
                        }
                        ComboBoxMeasureFieldEditor.this.fmeasure.setText(unit == null ? "" : unit);
                        ComboBoxMeasureFieldEditor.this.fmeasure.setEnabled(true);
                    }
                    ComboBoxMeasureFieldEditor.this.valueChanged("field_editor_value");
                }
            });
        }
        return this.fText;
    }

    public Combo getComboBoxControl(Composite parent) {
        if (!this.hasChoice) {
            return null;
        }
        if (this.fCombo == null) {
            this.fCombo = new Combo(parent, 4);
            for (int i = 0; i < this.fBoxNamesAndValues.length; ++i) {
                this.fCombo.add(this.fBoxNamesAndValues[i][0], i);
            }
            this.fCombo.setFont(parent.getFont());
            this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    if (ComboBoxMeasureFieldEditor.this.fmeasure != null) {
                        ComboBoxMeasureFieldEditor.this.fmeasure.setEnabled(false);
                    }
                    ComboBoxMeasureFieldEditor.this.valueChanged("field_editor_value");
                }
            });
            this.fCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    boolean cusType;
                    boolean bl = cusType = !ComboBoxMeasureFieldEditor.this.InComboNamesList(ComboBoxMeasureFieldEditor.this.fCombo.getText());
                    if (cusType) {
                        if (!DEUtil.isValidNumber((String)ComboBoxMeasureFieldEditor.this.fCombo.getText())) {
                            ComboBoxMeasureFieldEditor.this.fmeasure.deselectAll();
                            ComboBoxMeasureFieldEditor.this.fmeasure.setEnabled(false);
                        } else if (!ComboBoxMeasureFieldEditor.this.fmeasure.isEnabled()) {
                            String unit = ComboBoxMeasureFieldEditor.this.getDefaultUnit();
                            if (!StringUtil.isBlank((String)unit)) {
                                unit = DesignEngine.getMetaDataDictionary().getChoiceSet("units").findChoice(unit).getDisplayName();
                            }
                            ComboBoxMeasureFieldEditor.this.fmeasure.setText(unit == null ? "" : unit);
                            ComboBoxMeasureFieldEditor.this.fmeasure.setEnabled(true);
                        }
                    } else {
                        ComboBoxMeasureFieldEditor.this.fmeasure.deselectAll();
                        ComboBoxMeasureFieldEditor.this.fmeasure.setEnabled(false);
                    }
                    ComboBoxMeasureFieldEditor.this.valueChanged("field_editor_value");
                }
            });
        }
        return this.fCombo;
    }

    public Combo getMeasureControl(Composite parent) {
        if (this.fmeasure == null) {
            this.fmeasure = new Combo(parent, 8);
            for (int i = 0; i < this.fMeasureNamesAndValues.length; ++i) {
                this.fmeasure.add(this.fMeasureNamesAndValues[i][0], i);
            }
            if (this.getTextControl(parent) == null || this.getTextControl(parent).getText() != null) {
                // empty if block
            }
            this.fmeasure.setFont(parent.getFont());
            this.fmeasure.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ComboBoxMeasureFieldEditor.this.valueChanged("field_editor_value");
                }
            });
        }
        return this.fmeasure;
    }

    protected String getBoxValueForName(String name) {
        for (int i = 0; i < this.fBoxNamesAndValues.length; ++i) {
            String[] entry = this.fBoxNamesAndValues[i];
            if (!name.equals(entry[0])) continue;
            return entry[1];
        }
        return name;
    }

    protected String getMeasureValueForName(String name) {
        for (int i = 0; i < this.fMeasureNamesAndValues.length; ++i) {
            String[] entry = this.fMeasureNamesAndValues[i];
            if (!name.equals(entry[0])) continue;
            return entry[1];
        }
        return name;
    }
}

