/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseStylePreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatNumberPage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatPage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.StylePreferenceStore;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FormatNumberPreferencePage
extends BaseStylePreferencePage {
    private String name;
    private IFormatPage formatPage;

    public FormatNumberPreferencePage(Object model) {
        super(model);
        this.setTitle(Messages.getString((String)"FormatNumberPreferencePage.formatNumber.title"));
        this.setPreferenceName("NumberFormatValue");
    }

    private void setPreferenceName(String name) {
        this.name = name;
    }

    public String getPreferenceName() {
        return this.name;
    }

    protected void adjustGridLayout() {
        ((GridLayout)this.getFieldEditorParent().getLayout()).numColumns = 1;
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        Composite parent = this.getFieldEditorParent();
        this.formatPage = new FormatNumberPage(parent, 0);
        ((Composite)this.formatPage).setLayoutData((Object)new GridData(768));
        this.initiateFormatPage();
        UIUtil.bindHelp((Control)this.getFieldEditorParent().getParent(), "org.eclipse.birt.cshelp.StyleBuilderFormatNumber_ID");
    }

    private void initiateFormatPage() {
        String category = ((StylePreferenceStore)this.getPreferenceStore()).getNumberFormatCategory();
        String pattern = ((StylePreferenceStore)this.getPreferenceStore()).getNumberFormat();
        this.formatPage.setInput(category, pattern);
    }

    public boolean performOk() {
        IPreferenceStore ps = this.getPreferenceStore();
        if (ps instanceof StylePreferenceStore) {
            ((StylePreferenceStore)ps).clearError();
        }
        boolean rt = this.doStore();
        if (ps instanceof StylePreferenceStore) {
            return !((StylePreferenceStore)ps).hasError();
        }
        return rt;
    }

    protected boolean doStore() {
        if (this.formatPage == null || !this.formatPage.isFormatModified() || !this.formatPage.isDirty()) {
            return true;
        }
        try {
            ((StylePreferenceStore)this.getPreferenceStore()).setNumberFormatCategory(this.formatPage.getCategory());
            ((StylePreferenceStore)this.getPreferenceStore()).setNumberFormat(this.formatPage.getPattern());
            return true;
        }
        catch (SemanticException e) {
            e.printStackTrace();
            return false;
        }
    }
}

