/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.js;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.internal.ui.dialogs.js.JSExpression;
import org.eclipse.birt.report.designer.internal.ui.dialogs.js.JSObjectMetaData;
import org.eclipse.birt.report.designer.internal.ui.dialogs.js.JSSyntaxContext;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;

public class JSCompletionProcessor
implements IContentAssistProcessor {
    private JSSyntaxContext context;
    private String currentWord = "";
    private String currentExpressionStr = "";
    private JSExpression currentExpression;

    public JSCompletionProcessor(JSSyntaxContext context) {
        this.context = context;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        this.currentWord = null;
        try {
            String expression;
            this.currentExpressionStr = expression = this.supposeCurrentExpression(viewer.getDocument(), viewer.getTopIndexStartOffset(), offset);
            this.currentExpression = new JSExpression(this.context, this.currentExpressionStr);
            return this.getCompletionProposals(this.currentExpression.getReturnType(), offset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private String supposeCurrentExpression(IDocument document, int topOffset, int offset) throws BadLocationException {
        if (offset < 0) {
            offset = 0;
        }
        int startOffset = offset;
        int endOffset = offset;
        int bracket = 0;
        while (startOffset > topOffset) {
            char currentChar = document.getChar(--startOffset);
            if (this.currentWord == null && currentChar == '.') {
                while ((currentChar = document.getChar(--startOffset)) == '.') {
                }
                currentChar = document.getChar(++startOffset);
                this.currentWord = document.get(startOffset + 1, endOffset - startOffset - 1);
                endOffset = startOffset + 1;
            }
            if (currentChar == ')' || currentChar == ']') {
                ++bracket;
            }
            if (currentChar == '(' || currentChar == '[') {
                --bracket;
            }
            if (bracket != 0 || currentChar != '\n' && currentChar != ' ' && currentChar != '=' && currentChar != '+' && currentChar != '-' && currentChar != '*' && currentChar != '/' && currentChar != '<' && currentChar != '>' && currentChar != '&' && currentChar != '|' && currentChar != ';') continue;
            ++startOffset;
            break;
        }
        if (this.currentWord == null) {
            this.currentWord = document.get(startOffset, endOffset - startOffset);
            return this.currentWord;
        }
        return document.get(startOffset, endOffset - startOffset);
    }

    private ICompletionProposal[] getCompletionProposals(Object meta, int offset) {
        if (meta instanceof JSObjectMetaData) {
            return this.getCompletionProposals((JSObjectMetaData)meta, offset);
        }
        if (meta instanceof JSObjectMetaData[]) {
            return this.getCompletionProposals((JSObjectMetaData[])meta, offset);
        }
        return null;
    }

    private CompletionProposal[] getCompletionProposals(JSObjectMetaData[] metas, int offset) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        int wordLength = this.currentWord == null ? 0 : this.currentWord.length();
        for (int i = 0; i < metas.length; ++i) {
            if (this.currentWord != null && !this.currentWord.equals("") && !metas[i].getName().toLowerCase().startsWith(this.currentWord.toLowerCase())) continue;
            proposals.add(new CompletionProposal(metas[i].getName(), offset - wordLength, wordLength, metas[i].getName().length(), null, metas[i].getName(), null, null));
        }
        return proposals.toArray(new CompletionProposal[proposals.size()]);
    }

    private CompletionProposal[] getCompletionProposals(JSObjectMetaData meta, int offset) {
        JSObjectMetaData.JSMethod[] methods;
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        int wordLength = this.currentWord == null ? 0 : this.currentWord.length();
        JSObjectMetaData.JSField[] members = meta.getFields();
        if (members != null) {
            for (int i = 0; i < members.length; ++i) {
                if (this.currentWord != null && !this.currentWord.equals("") && !members[i].getName().toLowerCase().startsWith(this.currentWord.toLowerCase())) continue;
                proposals.add(new CompletionProposal(members[i].getName(), offset - wordLength, wordLength, members[i].getName().length(), this.getMemberImage(members[i].getVisibility()), members[i].getDisplayText(), null, null));
            }
        }
        if ((methods = meta.getMethods()) != null) {
            for (int i = 0; i < methods.length; ++i) {
                if (this.currentWord != null && !this.currentWord.equals("") && !methods[i].getName().toLowerCase().startsWith(this.currentWord.toLowerCase())) continue;
                proposals.add(new CompletionProposal("." + methods[i].getName() + "()", offset - wordLength - 1, wordLength + 1, methods[i].getName().length() + 2, this.getMethodImage(methods[i].getVisibility()), methods[i].getDisplayText(), null, null));
            }
        }
        return proposals.toArray(new CompletionProposal[proposals.size()]);
    }

    private Image getMemberImage(int visibility) {
        switch (visibility) {
            case 0: {
                return ReportPlatformUIImages.getImage("Member");
            }
            case 1: {
                return ReportPlatformUIImages.getImage("Member");
            }
            case 2: {
                return ReportPlatformUIImages.getImage("Member");
            }
            case 3: {
                return ReportPlatformUIImages.getImage("Static Member");
            }
        }
        return null;
    }

    private Image getMethodImage(int visibility) {
        switch (visibility) {
            case 0: {
                return ReportPlatformUIImages.getImage("Method");
            }
            case 1: {
                return ReportPlatformUIImages.getImage("Method");
            }
            case 2: {
                return ReportPlatformUIImages.getImage("Method");
            }
            case 3: {
                return ReportPlatformUIImages.getImage("Static Member");
            }
        }
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.', '['};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

