/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.resource;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ResourceFileContentProvider
implements ITreeContentProvider {
    private boolean showFiles;
    private FileFilter filter = new FileFilter(){

        public boolean accept(File pathname) {
            return true;
        }
    };

    public ResourceFileContentProvider(boolean showFiles) {
        this.showFiles = showFiles;
    }

    public ResourceFileContentProvider(final String[] extension) {
        this.showFiles = true;
        this.filter = new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                for (int i = 0; i < extension.length; ++i) {
                    if (!pathname.getName().toLowerCase().endsWith(extension[i])) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof File) {
            File file = (File)parentElement;
            if (!file.exists()) {
                return new Object[]{Messages.getString((String)"LibraryExplorerProvider.FolderNotExist")};
            }
            File[] childrenFiles = file.listFiles(this.filter);
            if (childrenFiles != null) {
                ArrayList<File> folers = new ArrayList<File>();
                ArrayList<File> files = new ArrayList<File>();
                for (int i = 0; i < childrenFiles.length; ++i) {
                    File child = childrenFiles[i];
                    if (child.isDirectory()) {
                        folers.add(child);
                        continue;
                    }
                    if (!this.showFiles) continue;
                    files.add(child);
                }
                folers.addAll(files);
                return folers.toArray();
            }
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof File) {
            return ((File)element).getParentFile();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof File) {
            return ((File)element).list() != null && ((File)element).list().length > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof String) {
            return new Object[]{new File(inputElement.toString())};
        }
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

