/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dnd;

import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;

public abstract class DesignElementDragAdapter
extends DragSourceAdapter {
    private StructuredViewer viewer;

    public DesignElementDragAdapter(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    public void dragFinished(DragSourceEvent event) {
        if (event.doit) {
            TemplateTransfer.getInstance().setTemplate(null);
            if (Policy.TRACING_DND_DRAG) {
                System.out.println("DND >> Drag finished.");
            }
        }
    }

    public void dragSetData(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        Object[] objects = selection.toList().toArray();
        if (TemplateTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = objects;
        }
    }

    public void dragStart(DragSourceEvent event) {
        boolean doit;
        boolean bl = doit = !this.getViewer().getSelection().isEmpty();
        if (doit) {
            IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
            Object[] objects = selection.toList().toArray();
            if (this.validateType(objects)) {
                for (int i = 0; i < objects.length; ++i) {
                    if (this.validateTransfer(objects[i])) continue;
                    doit = false;
                    break;
                }
            } else {
                doit = false;
            }
            if (doit) {
                TemplateTransfer.getInstance().setTemplate((Object)objects);
            }
        }
        event.doit = doit;
        if (Policy.TRACING_DND_DRAG && doit) {
            System.out.println("DND >> Drag starts.");
        }
    }

    protected abstract boolean validateTransfer(Object var1);

    protected boolean validateType(Object transfer) {
        Object[] objects = (Object[])transfer;
        Class<?> type = null;
        for (int i = 0; i < objects.length; ++i) {
            if (type == null) {
                type = objects[i].getClass();
                continue;
            }
            if (type.equals(objects[i].getClass())) continue;
            return false;
        }
        return true;
    }

    protected StructuredViewer getViewer() {
        return this.viewer;
    }
}

