/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.parts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.ListBandProxy;
import org.eclipse.birt.report.designer.core.util.mediator.request.IRequestConvert;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.editors.notification.DeferredRefreshManager;
import org.eclipse.birt.report.designer.internal.ui.editors.notification.ReportDeferredUpdateManager;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.ReportDomainEventDispatcher;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AreaEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DummyEditpart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ISelectionHandlesEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.TableResizeEditPolice;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.ui.parts.DomainEventDispatcher;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class DeferredGraphicalViewer
extends ScrollingGraphicalViewer {
    private DomainEventDispatcher eventDispatcher;
    private OriginStepData stepData = new OriginStepData();
    public static final String LAYOUT_SIZE = "Layout Size";
    public static final String REPORT_SIZE = "Report Size";
    public static final String PROPERTY_MARGIN_VISIBILITY = "Property Margin Visibility";

    public void hookRefreshListener(DeferredRefreshManager refreshManager) {
        ReportDeferredUpdateManager updateManager = new ReportDeferredUpdateManager();
        updateManager.setRefreshManager(refreshManager);
        this.getLightweightSystem().setUpdateManager((UpdateManager)updateManager);
    }

    public void setSelection(ISelection newSelection) {
        this.setSelection(newSelection, true);
    }

    public void setSelection(ISelection newSelection, boolean dispatch) {
        int i;
        if (!(newSelection instanceof IStructuredSelection)) {
            return;
        }
        List editparts = ((IStructuredSelection)newSelection).toList();
        List selection = this.primGetSelectedEditParts();
        this.setFocus(null);
        for (i = 0; i < selection.size(); ++i) {
            ((EditPart)selection.get(i)).setSelected(0);
        }
        selection.clear();
        editparts = this.flitterEditpart(editparts);
        selection.addAll(editparts);
        for (i = 0; i < editparts.size(); ++i) {
            EditPart part = (EditPart)editparts.get(i);
            if (i == editparts.size() - 1) {
                part.setSelected(2);
                continue;
            }
            part.setSelected(1);
        }
        if (dispatch) {
            this.fireSelectionChanged();
        }
    }

    private List flitterEditpart(List editparts) {
        int i;
        int size = editparts.size();
        ArrayList copy = new ArrayList(editparts);
        for (int i2 = 0; i2 < size; ++i2) {
            EditPart part = (EditPart)editparts.get(i2);
            if (!(part instanceof AreaEditPart)) continue;
            copy.remove(part);
        }
        boolean hasCell = false;
        boolean hasOther = false;
        for (i = 0; i < size; ++i) {
            Object obj = ((EditPart)editparts.get(i)).getModel();
            if (obj instanceof CellHandle || obj instanceof RowHandle || obj instanceof ColumnHandle) {
                hasCell = true;
                continue;
            }
            hasOther = true;
        }
        if (hasCell && hasOther) {
            for (i = 0; i < size; ++i) {
                EditPart part = (EditPart)editparts.get(i);
                Object obj = part.getModel();
                if (!(obj instanceof CellHandle) && !(obj instanceof RowHandle) && !(obj instanceof ColumnHandle)) continue;
                copy.remove(part);
            }
        }
        editparts = copy;
        return editparts;
    }

    public Handle findHandleAt(Point p) {
        LayerManager layermanager = (LayerManager)this.getEditPartRegistry().get(LayerManager.ID);
        if (layermanager == null) {
            return null;
        }
        ArrayList<IFigure> list = new ArrayList<IFigure>(3);
        list.add(layermanager.getLayer((Object)"Connection Layer"));
        list.add(layermanager.getLayer((Object)"Feedback Layer"));
        IFigure handle = this.getLightweightSystem().getRootFigure().findFigureAtExcluding(p.x, p.y, list);
        if (handle instanceof Handle) {
            return (Handle)handle;
        }
        return null;
    }

    public FigureCanvas getFigureCanvas() {
        return super.getFigureCanvas();
    }

    public void appendSelection(EditPart editpart) {
        if (editpart != this.focusPart) {
            this.setFocus(null);
        }
        List list = this.primGetSelectedEditParts();
        list.remove(editpart);
        list.add(editpart);
        this.setSelection((ISelection)new StructuredSelection(list));
    }

    public void setEditDomain(EditDomain domain) {
        super.setEditDomain(domain);
        this.eventDispatcher = new ReportDomainEventDispatcher(domain, (EditPartViewer)this);
        this.eventDispatcher.setEnableKeyTraversal(true);
        this.getLightweightSystem().setEventDispatcher((EventDispatcher)this.eventDispatcher);
    }

    protected DomainEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public void reveal(EditPart part) {
        if (this.getFigureCanvas() == null || this.getFigureCanvas().isDisposed()) {
            return;
        }
        Viewport port = this.getFigureCanvas().getViewport();
        IFigure target = ((GraphicalEditPart)part).getFigure();
        Rectangle exposeRegion = target.getBounds().getCopy();
        EditPolicy policy = part.getEditPolicy((Object)"PrimaryDrag Policy");
        if (!(policy instanceof ISelectionHandlesEditPolicy)) {
            super.reveal(part);
            return;
        }
        for (target = target.getParent(); target != null && target != port; target = target.getParent()) {
            target.translateToParent((Translatable)exposeRegion);
        }
        List handles = ((TableResizeEditPolice)policy).getHandles();
        Iterator iter = handles.iterator();
        while (iter.hasNext()) {
            AbstractHandle handle = (AbstractHandle)iter.next();
            Locator locator = handle.getLocator();
            locator.relocate((IFigure)handle);
            exposeRegion.union(handle.getBounds().getCopy());
        }
        exposeRegion.getExpanded(5, 5);
        Dimension viewportSize = port.getClientArea().getSize();
        Point topLeft = exposeRegion.getTopLeft();
        Point bottomRight = exposeRegion.getBottomRight().translate(viewportSize.getNegated());
        Point finalLocation = new Point();
        finalLocation.x = viewportSize.width < exposeRegion.width ? Math.min(bottomRight.x, Math.max(topLeft.x, port.getViewLocation().x)) : Math.min(topLeft.x, Math.max(bottomRight.x, port.getViewLocation().x));
        finalLocation.y = viewportSize.height < exposeRegion.height ? Math.min(bottomRight.y, Math.max(topLeft.y, port.getViewLocation().y)) : Math.min(topLeft.y, Math.max(bottomRight.y, port.getViewLocation().y));
        this.getFigureCanvas().scrollSmoothTo(finalLocation.x, finalLocation.y);
    }

    protected void fireSelectionChanged() {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        ReportRequest request = new ReportRequest((Object)this);
        List list = new ArrayList();
        if (this.getSelection() instanceof IStructuredSelection) {
            list = ((IStructuredSelection)this.getSelection()).toList();
        }
        request.setSelectionObject(list);
        request.setType((Object)"selection");
        request.setRequestConvert((IRequestConvert)new EditorReportRequestConvert());
        SessionHandleAdapter.getInstance().getMediator().notifyRequest(request);
        DeferredGraphicalViewer.super.fireSelectionChanged();
    }

    public void initStepDat() {
        Viewport port = ((FigureCanvas)this.getControl()).getViewport();
        this.stepData.minX = port.getHorizontalRangeModel().getMinimum();
        this.stepData.maxX = port.getHorizontalRangeModel().getMaximum();
        this.stepData.valueX = port.getHorizontalRangeModel().getValue();
        this.stepData.extendX = port.getHorizontalRangeModel().getExtent();
        this.stepData.minY = port.getVerticalRangeModel().getMinimum();
        this.stepData.maxY = port.getVerticalRangeModel().getMaximum();
        this.stepData.valueY = port.getVerticalRangeModel().getValue();
        this.stepData.extendY = port.getVerticalRangeModel().getExtent();
    }

    public OriginStepData getOriginStepData() {
        return this.stepData;
    }

    public static class EditorReportRequestConvert
    implements IRequestConvert {
        public List convertSelectionToModelLisr(List list) {
            ArrayList<Object> retValue = new ArrayList<Object>();
            int size = list.size();
            boolean isDummy = false;
            for (int i = 0; i < size; ++i) {
                Object object = list.get(i);
                if (!(object instanceof EditPart)) continue;
                EditPart part = (EditPart)object;
                if (part instanceof DummyEditpart) {
                    retValue.add(part.getModel());
                    isDummy = true;
                    continue;
                }
                if (isDummy) break;
                if (part.getModel() instanceof ListBandProxy) {
                    retValue.add(((ListBandProxy)part.getModel()).getSlotHandle());
                    continue;
                }
                retValue.add(part.getModel());
            }
            return retValue;
        }
    }

    public static class OriginStepData {
        public int minX;
        public int maxX;
        public int valueX;
        public int extendX;
        public int minY;
        public int maxY;
        public int valueY;
        public int extendY;
    }
}

