/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.parts;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.TableCellSelectionHelper;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;

public class TableCellKeyDelegate
extends GraphicalViewerKeyHandler {
    private int lastHDir;
    private ActionRegistry actionRegistry;
    private int lastVDir;
    private int counter;
    private static final ArrayList NULL_LIST = new ArrayList(0);
    private WeakReference cachedNode;

    public TableCellKeyDelegate(GraphicalViewer viewer, ActionRegistry actionRegistry) {
        super(viewer);
        this.actionRegistry = actionRegistry;
        this.put(KeyStroke.getPressed((char)'r', (int)114, (int)196608), actionRegistry.getAction((Object)"org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SelectRowAction"));
        this.put(KeyStroke.getPressed((char)'R', (int)114, (int)196608), actionRegistry.getAction((Object)"org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SelectRowAction"));
        this.put(KeyStroke.getPressed((char)'c', (int)99, (int)196608), actionRegistry.getAction((Object)"org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SelectColumnAction"));
        this.put(KeyStroke.getPressed((char)'C', (int)99, (int)196608), actionRegistry.getAction((Object)"org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SelectColumnAction"));
    }

    boolean acceptConnection(KeyEvent event) {
        return event.character == '/' || event.character == '?' || event.character == '\\' || event.character == '\u001c' || event.character == '|';
    }

    boolean acceptIntoContainer(KeyEvent event) {
        return (event.stateMask & 0x10000) != 0 && event.keyCode == 0x1000002;
    }

    boolean acceptLeaveConnection(KeyEvent event) {
        int key = event.keyCode;
        return this.getFocusEditPart() instanceof ConnectionEditPart && (key == 0x1000001 || key == 0x1000004 || key == 0x1000002 || key == 0x1000003);
    }

    boolean acceptLeaveContents(KeyEvent event) {
        int key = event.keyCode;
        return this.getFocusEditPart() == this.getViewer().getContents() && (key == 0x1000001 || key == 0x1000004 || key == 0x1000002 || key == 0x1000003);
    }

    boolean acceptOutOf(KeyEvent event) {
        return (event.stateMask & 0x10000) != 0 && event.keyCode == 0x1000001;
    }

    boolean acceptScroll(KeyEvent event) {
        return (event.stateMask & 0x40000) != 0 && (event.stateMask & 0x20000) != 0 && (event.keyCode == 0x1000002 || event.keyCode == 0x1000003 || event.keyCode == 0x1000004 || event.keyCode == 0x1000001);
    }

    private GraphicalEditPart getCachedNode() {
        if (this.cachedNode == null) {
            return null;
        }
        if (this.cachedNode.isEnqueued()) {
            return null;
        }
        return (GraphicalEditPart)this.cachedNode.get();
    }

    private void setCachedNode(GraphicalEditPart node) {
        this.cachedNode = node == null ? null : new WeakReference<GraphicalEditPart>(node);
    }

    ConnectionEditPart findConnection(GraphicalEditPart node, ConnectionEditPart current, boolean forward) {
        ArrayList connections = new ArrayList(node.getSourceConnections());
        connections.addAll(node.getTargetConnections());
        if (connections.isEmpty()) {
            return null;
        }
        this.counter = forward ? ++this.counter : --this.counter;
        while (this.counter < 0) {
            this.counter += connections.size();
        }
        this.counter %= connections.size();
        return (ConnectionEditPart)connections.get(this.counter % connections.size());
    }

    List getNavigationSiblings() {
        GraphicalEditPart focusPart = this.getFocusEditPart();
        if (focusPart.getParent() != null) {
            return focusPart.getParent().getChildren();
        }
        ArrayList<GraphicalEditPart> list = new ArrayList<GraphicalEditPart>();
        list.add(focusPart);
        return list;
    }

    Point getNavigationPoint(IFigure figure) {
        return figure.getBounds().getCenter();
    }

    public boolean keyPressed(KeyEvent event) {
        if (event.character == ' ') {
            this.processSelect(event);
            return true;
        }
        if (this.acceptIntoContainer(event)) {
            this.navigateIntoContainer(event);
            return true;
        }
        if (this.acceptOutOf(event)) {
            this.navigateOut(event);
            return true;
        }
        if (this.acceptConnection(event)) {
            this.navigateConnections(event);
            return true;
        }
        if (this.acceptScroll(event)) {
            this.scrollViewer(event);
            return true;
        }
        if (this.acceptLeaveConnection(event)) {
            this.navigateOutOfConnection(event);
            return true;
        }
        if (this.acceptLeaveContents(event)) {
            this.navigateIntoContainer(event);
            return true;
        }
        switch (event.keyCode) {
            case 0x1000003: {
                if (!this.navigateNextSibling(event, 8)) break;
                return true;
            }
            case 0x1000004: {
                if (!this.navigateNextSibling(event, 16)) break;
                return true;
            }
            case 0x1000001: {
                if (!this.navigateNextSibling(event, 1)) break;
                return true;
            }
            case 0x1000002: {
                if (!this.navigateNextSibling(event, 4)) break;
                return true;
            }
            case 0x1000007: {
                if (!this.navigateJumpSibling(event, 8)) break;
                return true;
            }
            case 0x1000008: {
                if (!this.navigateJumpSibling(event, 16)) break;
                return true;
            }
            case 0x1000006: {
                if (!this.navigateJumpSibling(event, 4)) break;
                return true;
            }
            case 0x1000005: {
                if (!this.navigateJumpSibling(event, 1)) break;
                return true;
            }
        }
        return super.keyPressed(event);
    }

    void navigateConnections(KeyEvent event) {
        GraphicalEditPart focus = this.getFocusEditPart();
        ConnectionEditPart current = null;
        GraphicalEditPart node = this.getCachedNode();
        if (focus instanceof ConnectionEditPart) {
            current = (ConnectionEditPart)focus;
            if (node == null || node != current.getSource() && node != current.getTarget()) {
                node = (GraphicalEditPart)current.getSource();
                this.counter = 0;
            }
        } else {
            node = focus;
        }
        this.setCachedNode(node);
        boolean forward = event.character == '/' || event.character == '?';
        ConnectionEditPart next = this.findConnection(node, current, forward);
        this.navigateTo((EditPart)next, event);
    }

    void navigateIntoContainer(KeyEvent event) {
        GraphicalEditPart focus = this.getFocusEditPart();
        List childList = focus.getChildren();
        Point tl = focus.getContentPane().getBounds().getTopLeft();
        int minimum = Integer.MAX_VALUE;
        GraphicalEditPart closestPart = null;
        for (int i = 0; i < childList.size(); ++i) {
            GraphicalEditPart ged = (GraphicalEditPart)childList.get(i);
            if (!ged.isSelectable()) continue;
            Rectangle childBounds = ged.getFigure().getBounds();
            int current = childBounds.x - tl.x + (childBounds.y - tl.y);
            if (current >= minimum) continue;
            minimum = current;
            closestPart = ged;
        }
        if (closestPart != null) {
            this.navigateTo((EditPart)closestPart, event);
        }
    }

    void navigateOut(KeyEvent event) {
        if (this.getFocusEditPart() == null || this.getFocusEditPart() == this.getViewer().getContents() || this.getFocusEditPart().getParent() == this.getViewer().getContents()) {
            return;
        }
        this.navigateTo(this.getFocusEditPart().getParent(), event);
    }

    void navigateOutOfConnection(KeyEvent event) {
        GraphicalEditPart cached = this.getCachedNode();
        ConnectionEditPart conn = (ConnectionEditPart)this.getFocusEditPart();
        if (cached != null && (cached == conn.getSource() || cached == conn.getTarget())) {
            this.navigateTo((EditPart)cached, event);
        } else {
            this.navigateTo(conn.getSource(), event);
        }
    }

    void scrollViewer(KeyEvent event) {
        if (!(this.getViewer().getControl() instanceof FigureCanvas)) {
            return;
        }
        FigureCanvas figCanvas = (FigureCanvas)this.getViewer().getControl();
        Point loc = figCanvas.getViewport().getViewLocation();
        Rectangle area = figCanvas.getViewport().getClientArea(Rectangle.SINGLETON).scale(0.1);
        switch (event.keyCode) {
            case 0x1000002: {
                figCanvas.scrollToY(loc.y + area.height);
                break;
            }
            case 0x1000001: {
                figCanvas.scrollToY(loc.y - area.height);
                break;
            }
            case 0x1000003: {
                figCanvas.scrollToX(loc.x - area.width);
                break;
            }
            case 0x1000004: {
                figCanvas.scrollToX(loc.x + area.width);
            }
        }
    }

    boolean navigateNextSibling(KeyEvent event, int direction) {
        return this.navigateNextSibling(event, direction, this.getNavigationSiblings());
    }

    boolean navigateNextSibling(KeyEvent event, int direction, List list) {
        GraphicalEditPart epStart = this.getFocusEditPart();
        IFigure figure = epStart.getFigure();
        Point pStart = this.getNavigationPoint(figure);
        figure.translateToAbsolute((Translatable)pStart);
        if (epStart instanceof TableCellEditPart) {
            if ((event.stateMask & 0x20000) != 0) {
                List parts = this.findTableCellSiblings(list, pStart, direction, (EditPart)epStart);
                if (parts == null || parts.size() == 0) {
                    return true;
                }
                this.navigateTo(parts, event);
            } else {
                GraphicalEditPart next = this.findTableCellSibling(list, pStart, direction, (EditPart)epStart);
                if (next == null) {
                    return false;
                }
                this.navigateTo((EditPart)next, event);
            }
        } else {
            GraphicalEditPart next = this.findSibling(list, pStart, direction, (EditPart)epStart);
            if (next == null) {
                return false;
            }
            this.navigateTo((EditPart)next, event);
        }
        return true;
    }

    boolean navigateJumpSibling(KeyEvent event, int direction) {
        return false;
    }

    GraphicalEditPart findSibling(List siblings, Point pStart, int direction, EditPart exclude) {
        GraphicalEditPart epFinal = null;
        int distance = Integer.MAX_VALUE;
        Iterator iter = siblings.iterator();
        while (iter.hasNext()) {
            int d;
            GraphicalEditPart epCurrent = (GraphicalEditPart)iter.next();
            if (epCurrent == exclude || !epCurrent.isSelectable()) continue;
            IFigure figure = epCurrent.getFigure();
            Point pCurrent = this.getNavigationPoint(figure);
            figure.translateToAbsolute((Translatable)pCurrent);
            if (pStart.getPosition(pCurrent) != direction || (d = pCurrent.getDistanceOrthogonal(pStart)) >= distance) continue;
            distance = d;
            epFinal = epCurrent;
        }
        return epFinal;
    }

    protected GraphicalEditPart findTableCellSibling(List siblings, Point pStart, int direction, EditPart exclude) {
        TableCellEditPart start = (TableCellEditPart)exclude;
        int nRow = start.getRowNumber();
        int nCol = start.getColumnNumber();
        switch (direction) {
            case 1: {
                --nRow;
                break;
            }
            case 4: {
                nRow += start.getRowSpan();
                break;
            }
            case 8: {
                --nCol;
                break;
            }
            case 16: {
                nCol += start.getColSpan();
                break;
            }
        }
        TableEditPart parent = (TableEditPart)start.getParent();
        if (nRow < 1) {
            nRow = 1;
        }
        if (nRow > parent.getRowCount()) {
            nRow = parent.getRowCount();
        }
        if (nCol < 1) {
            nCol = 1;
        }
        if (nCol > parent.getColumnCount()) {
            nCol = parent.getColumnCount();
        }
        return parent.getCell(nRow, nCol);
    }

    protected List findTableCellSiblings(List siblings, Point pStart, int direction, EditPart exclude) {
        TableCellEditPart start = (TableCellEditPart)exclude;
        TableEditPart parent = (TableEditPart)start.getParent();
        StructuredSelection selection = (StructuredSelection)this.getViewer().getSelection();
        Object obj = selection.getFirstElement();
        if (obj instanceof TableCellEditPart) {
            TableCellEditPart first = (TableCellEditPart)((Object)obj);
            Rectangle constraint = TableCellSelectionHelper.getSelectionRectangle(first, selection.toList());
            boolean refined = TableCellSelectionHelper.increaseSelectionRectangle(constraint, parent);
            while (refined) {
                refined = TableCellSelectionHelper.increaseSelectionRectangle(constraint, parent);
            }
            this.translateRectangle(parent, constraint, direction);
            this.alterRectangle(constraint, direction, parent);
            return TableCellSelectionHelper.getRectangleSelection(constraint, parent);
        }
        return NULL_LIST;
    }

    void translateRectangle(TableEditPart table, Rectangle rect, int direction) {
        TableCellEditPart cell;
        int j;
        int i;
        boolean HMovable = true;
        boolean VMovable = true;
        int xstart = Math.min(rect.x, rect.x + rect.width);
        int xend = Math.max(rect.x, rect.x + rect.width);
        int ystart = Math.min(rect.y, rect.y + rect.height);
        int yend = Math.max(rect.y, rect.y + rect.height);
        for (int i2 = xstart; i2 <= xend; ++i2) {
            for (int j2 = ystart; j2 <= yend; ++j2) {
                TableCellEditPart cell2 = table.getCell(j2, i2);
                if (HMovable && cell2.getColSpan() >= xend - xstart + 1) {
                    HMovable = false;
                }
                if (!VMovable || cell2.getRowSpan() < yend - ystart + 1) continue;
                VMovable = false;
            }
        }
        if (HMovable) {
            boolean HConnective = true;
            for (i = xstart + 1; i <= xend; ++i) {
                boolean spanned = false;
                for (j = ystart; j <= yend; ++j) {
                    cell = table.getCell(j, i - 1);
                    if (cell.getColumnNumber() + cell.getColSpan() - 1 < i) continue;
                    spanned = true;
                    break;
                }
                if (spanned) continue;
                HConnective = false;
                break;
            }
            if (HConnective) {
                HMovable = false;
            }
        }
        if (VMovable) {
            boolean VConnective = true;
            for (i = ystart + 1; i <= yend; ++i) {
                boolean spanned = false;
                for (j = xstart; j <= xend; ++j) {
                    cell = table.getCell(i - 1, j);
                    if (cell.getRowNumber() + cell.getRowSpan() - 1 < i) continue;
                    spanned = true;
                    break;
                }
                if (spanned) continue;
                VConnective = false;
                break;
            }
            if (VConnective) {
                VMovable = false;
            }
        }
        if (this.lastVDir < 0 && VMovable || !VMovable && direction == 1) {
            int ny = rect.y + rect.height;
            int nHeight = -rect.height;
            rect.y = ny;
            rect.height = nHeight;
        }
        if (this.lastHDir < 0 && HMovable || !HMovable && direction == 8) {
            int nx = rect.x + rect.width;
            int nWidth = -rect.width;
            rect.x = nx;
            rect.width = nWidth;
        }
    }

    void alterRectangle(Rectangle rect, int direction, TableEditPart table) {
        switch (direction) {
            case 1: {
                if (rect.height <= 0) {
                    --rect.height;
                    boolean refined = TableCellSelectionHelper.increaseSelectionRectangle(rect, table);
                    while (refined) {
                        refined = TableCellSelectionHelper.increaseSelectionRectangle(rect, table);
                    }
                } else {
                    --rect.height;
                    boolean refined = TableCellSelectionHelper.decreaseSelectionRectangle(rect, table, direction);
                    while (refined) {
                        refined = TableCellSelectionHelper.decreaseSelectionRectangle(rect, table, direction);
                    }
                }
                this.lastVDir = rect.height;
                break;
            }
            case 4: {
                if (rect.height >= 0) {
                    ++rect.height;
                    boolean refined = TableCellSelectionHelper.increaseSelectionRectangle(rect, table);
                    while (refined) {
                        refined = TableCellSelectionHelper.increaseSelectionRectangle(rect, table);
                    }
                } else {
                    ++rect.height;
                    boolean refined = TableCellSelectionHelper.decreaseSelectionRectangle(rect, table, direction);
                    while (refined) {
                        refined = TableCellSelectionHelper.decreaseSelectionRectangle(rect, table, direction);
                    }
                }
                this.lastVDir = rect.height;
                break;
            }
            case 8: {
                if (rect.width <= 0) {
                    --rect.width;
                    boolean refined = TableCellSelectionHelper.increaseSelectionRectangle(rect, table);
                    while (refined) {
                        refined = TableCellSelectionHelper.increaseSelectionRectangle(rect, table);
                    }
                } else {
                    --rect.width;
                    boolean refined = TableCellSelectionHelper.decreaseSelectionRectangle(rect, table, direction);
                    while (refined) {
                        refined = TableCellSelectionHelper.decreaseSelectionRectangle(rect, table, direction);
                    }
                }
                this.lastHDir = rect.width;
                break;
            }
            case 16: {
                if (rect.width >= 0) {
                    ++rect.width;
                    boolean refined = TableCellSelectionHelper.increaseSelectionRectangle(rect, table);
                    while (refined) {
                        refined = TableCellSelectionHelper.increaseSelectionRectangle(rect, table);
                    }
                } else {
                    ++rect.width;
                    boolean refined = TableCellSelectionHelper.decreaseSelectionRectangle(rect, table, direction);
                    while (refined) {
                        refined = TableCellSelectionHelper.decreaseSelectionRectangle(rect, table, direction);
                    }
                }
                this.lastHDir = rect.width;
                break;
            }
        }
    }

    protected void navigateTo(EditPart part, KeyEvent event) {
        super.navigateTo(part, event);
    }

    protected void navigateTo(List parts, KeyEvent event) {
        if (parts == null || parts.size() == 0) {
            return;
        }
        boolean first = true;
        Iterator itr = parts.iterator();
        while (itr.hasNext()) {
            GraphicalEditPart part = (GraphicalEditPart)itr.next();
            if (first) {
                this.getViewer().select((EditPart)part);
                first = false;
            } else {
                this.getViewer().appendSelection((EditPart)part);
            }
            this.getViewer().reveal((EditPart)part);
        }
    }
}

