/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.schematic.CellHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.ContextSelectionAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.ui.IWorkbenchPart;

public class SelectColumnAction
extends ContextSelectionAction {
    public static final String ID = "org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SelectColumnAction";

    public SelectColumnAction(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
    }

    protected boolean calculateEnabled() {
        int[] intValue = this.getSelectionColumnNumbers();
        if (intValue == null || intValue.length == 0) {
            return false;
        }
        return TableUtil.isContinue(intValue);
    }

    public void run() {
        int[] intValue = this.getSelectionColumnNumbers();
        Arrays.sort(intValue);
        TableEditPart part = this.getTableEditPart();
        if (part != null) {
            part.selectColumn(intValue);
        }
    }

    private int[] getSelectionColumnNumbers() {
        List list = this.getElementHandles();
        if (!TableUtil.isAllCell(list)) {
            return new int[0];
        }
        int size = list.size();
        ArrayList<Integer> temp = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            Object obj = list.get(i);
            CellHandleAdapter adapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(obj);
            int colNumber = adapt.getColumnNumber();
            int colSpan = adapt.getColumnSpan();
            for (int j = colNumber; j < colNumber + colSpan; ++j) {
                Integer value = new Integer(j);
                if (temp.contains(value)) continue;
                temp.add(value);
            }
        }
        size = temp.size();
        int[] retValue = new int[size];
        for (int i = 0; i < size; ++i) {
            Integer value = (Integer)temp.get(i);
            retValue[i] = value;
        }
        return retValue;
    }
}

