/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.border;

import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class ReportDesignMarginBorder
extends MarginBorder {
    private static final Insets DEFAULT_CROP = new Insets(-3, -3, -2, -2);
    private int backgroundColor = 0xFFFFFF;

    public ReportDesignMarginBorder(Insets insets) {
        super(insets);
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        Color oldBackgroundColor = graphics.getBackgroundColor();
        Color oldForegroundColor = graphics.getForegroundColor();
        Rectangle rect = figure.getBounds().getCopy();
        Insets margin = this.getInsets(figure);
        graphics.setBackgroundColor(ColorManager.getColor((int)this.backgroundColor));
        Rectangle top = new Rectangle(rect.x, rect.y, rect.width, margin.top);
        graphics.fillRectangle(top);
        Rectangle left = new Rectangle(rect.x, rect.y, margin.left, rect.height);
        graphics.fillRectangle(left);
        Rectangle bottom = new Rectangle(rect.x, rect.height - margin.bottom, rect.width, margin.bottom);
        graphics.fillRectangle(bottom);
        Rectangle right = new Rectangle(rect.width - margin.right, rect.y, margin.right, rect.height);
        graphics.fillRectangle(right);
        graphics.setBackgroundColor(oldBackgroundColor);
        graphics.setForegroundColor(ReportColorConstants.MarginBorderColor);
        graphics.drawRectangle(figure.getBounds().getCopy().crop(margin).crop(DEFAULT_CROP));
        graphics.setForegroundColor(oldForegroundColor);
    }

    public void setBackgroundColor(Object obj) {
        if (obj != null) {
            this.backgroundColor = obj instanceof String ? ColorUtil.parseColor((String)((String)obj)) : (Integer)obj;
        }
    }
}

