/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.border;

import java.util.Iterator;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.CellBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.TableBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.util.TableBorderCollisionArbiter;
import org.eclipse.draw2d.geometry.Insets;

public class TableBorderHelper {
    private TableEditPart owner;
    private int[][] heights;
    private int[][] widths;
    private int[][] borderData;

    public TableBorderHelper(TableEditPart owner) {
        this.owner = owner;
    }

    private void initialize() {
        int i;
        int rowCount = this.owner.getRowCount();
        int colCount = this.owner.getColumnCount();
        this.heights = new int[colCount][rowCount + 1];
        this.widths = new int[rowCount][colCount + 1];
        this.borderData = new int[2 * colCount * rowCount + colCount + rowCount][5];
        for (int i2 = 0; i2 < rowCount; ++i2) {
            for (int j = 0; j < colCount; ++j) {
                this.borderData[i2 * (2 * colCount + 1) + j][3] = -1;
                this.borderData[i2 * (2 * colCount + 1) + j][4] = -1;
                this.borderData[(i2 + 1) * (2 * colCount + 1) + j][3] = -1;
                this.borderData[(i2 + 1) * (2 * colCount + 1) + j][4] = -1;
                this.borderData[i2 * (2 * colCount + 1) + colCount + j][3] = -1;
                this.borderData[i2 * (2 * colCount + 1) + colCount + j][4] = -1;
                this.borderData[i2 * (2 * colCount + 1) + colCount + j + 1][3] = -1;
                this.borderData[i2 * (2 * colCount + 1) + colCount + j + 1][4] = -1;
            }
        }
        TableBorder tableBorder = (TableBorder)this.owner.getFigure().getBorder();
        Insets tableBorderInsets = tableBorder.getTrueBorderInsets();
        for (i = 0; i < colCount; ++i) {
            this.heights[i][0] = tableBorderInsets.top;
            this.heights[i][rowCount] = tableBorderInsets.bottom;
        }
        for (i = 0; i < rowCount; ++i) {
            this.widths[i][0] = tableBorderInsets.left;
            this.widths[i][colCount] = tableBorderInsets.right;
        }
        Iterator itr = this.owner.getChildren().iterator();
        while (itr.hasNext()) {
            int i3;
            TableCellEditPart cellPart = (TableCellEditPart)((Object)itr.next());
            int rowIndex = cellPart.getRowNumber();
            int colIndex = cellPart.getColumnNumber();
            int rowSpan = cellPart.getRowSpan();
            int colSpan = cellPart.getColSpan();
            CellBorder border = (CellBorder)cellPart.getFigure().getBorder();
            Insets ins = border.getTrueBorderInsets();
            int topStyle = border.getTopBorderStyle();
            int topWidth = border.getTopBorderWidth();
            int topColor = border.getTopBorderColor();
            int bottomStyle = border.getBottomBorderStyle();
            int bottomWidth = border.getBottomBorderWidth();
            int bottomColor = border.getBottomBorderColor();
            int leftStyle = border.getLeftBorderStyle();
            int leftWidth = border.getLeftBorderWidth();
            int leftColor = border.getLeftBorderColor();
            int rightStyle = border.getRightBorderStyle();
            int rightWidth = border.getRightBorderWidth();
            int rightColor = border.getRightBorderColor();
            for (i3 = 0; i3 < colSpan; ++i3) {
                TableBorderCollisionArbiter.refreshBorderData((int[])this.borderData[(rowIndex - 1) * (2 * colCount + 1) + colIndex - 1 + i3], (int)topStyle, (int)topWidth, (int)topColor, (int)(rowIndex - 1), (int)(colIndex - 1 + i3));
                TableBorderCollisionArbiter.refreshBorderData((int[])this.borderData[(rowIndex + rowSpan - 1) * (2 * colCount + 1) + colIndex - 1 + i3], (int)bottomStyle, (int)bottomWidth, (int)bottomColor, (int)(rowIndex - 1 + rowSpan - 1), (int)(colIndex - 1 + i3));
                this.heights[colIndex - 1 + i3][rowIndex - 1] = Math.max(this.heights[colIndex - 1 + i3][rowIndex - 1], ins.top);
                this.heights[colIndex - 1 + i3][rowIndex + rowSpan - 1] = Math.max(this.heights[colIndex - 1 + i3][rowIndex + rowSpan - 1], ins.bottom);
            }
            for (i3 = 0; i3 < rowSpan; ++i3) {
                TableBorderCollisionArbiter.refreshBorderData((int[])this.borderData[(rowIndex - 1 + i3) * (2 * colCount + 1) + colCount + colIndex - 1], (int)leftStyle, (int)leftWidth, (int)leftColor, (int)(rowIndex - 1 + i3), (int)(colIndex - 1));
                TableBorderCollisionArbiter.refreshBorderData((int[])this.borderData[(rowIndex - 1 + i3) * (2 * colCount + 1) + colCount + colIndex + colSpan - 1], (int)rightStyle, (int)rightWidth, (int)rightColor, (int)(rowIndex - 1 + i3), (int)(colIndex - 1 + colSpan - 1));
                this.widths[rowIndex - 1 + i3][colIndex - 1] = Math.max(this.widths[rowIndex - 1 + i3][colIndex - 1], ins.left);
                this.widths[rowIndex - 1 + i3][colIndex + colSpan - 1] = Math.max(this.widths[rowIndex - 1 + i3][colIndex + colSpan - 1], ins.right);
            }
        }
        int tableTopStyle = tableBorder.getTopBorderStyle();
        int tableTopWidth = tableBorder.getTopBorderWidth();
        if (tableTopStyle != 0 && tableTopWidth > 0) {
            int tableTopColor = tableBorder.getTopBorderColor();
            for (int i4 = 0; i4 < colCount; ++i4) {
                this.borderData[i4][0] = tableTopStyle;
                this.borderData[i4][1] = tableTopWidth;
                this.borderData[i4][2] = tableTopColor;
                this.borderData[i4][3] = -2;
                this.borderData[i4][4] = -2;
            }
        }
        int tableBottomStyle = tableBorder.getBottomBorderStyle();
        int tableBottomWidth = tableBorder.getBottomBorderWidth();
        if (tableBottomStyle != 0 && tableBottomWidth > 0) {
            int tableBottomColor = tableBorder.getBottomBorderColor();
            for (int i5 = 0; i5 < colCount; ++i5) {
                this.borderData[2 * colCount * rowCount + rowCount + i5][0] = tableBottomStyle;
                this.borderData[2 * colCount * rowCount + rowCount + i5][1] = tableBottomWidth;
                this.borderData[2 * colCount * rowCount + rowCount + i5][2] = tableBottomColor;
                this.borderData[2 * colCount * rowCount + rowCount + i5][3] = -2;
                this.borderData[2 * colCount * rowCount + rowCount + i5][4] = -2;
            }
        }
        int tableLeftStyle = tableBorder.getLeftBorderStyle();
        int tableLeftWidth = tableBorder.getLeftBorderWidth();
        if (tableLeftStyle != 0 && tableLeftWidth > 0) {
            int tableLeftColor = tableBorder.getLeftBorderColor();
            for (int i6 = 0; i6 < rowCount; ++i6) {
                this.borderData[(2 * colCount + 1) * i6 + colCount][0] = tableLeftStyle;
                this.borderData[(2 * colCount + 1) * i6 + colCount][1] = tableLeftWidth;
                this.borderData[(2 * colCount + 1) * i6 + colCount][2] = tableLeftColor;
                this.borderData[(2 * colCount + 1) * i6 + colCount][3] = -2;
                this.borderData[(2 * colCount + 1) * i6 + colCount][4] = -2;
            }
        }
        int tableRightStyle = tableBorder.getRightBorderStyle();
        int tableRightWidth = tableBorder.getRightBorderWidth();
        if (tableRightStyle != 0 && tableRightWidth > 0) {
            int tableRightColor = tableBorder.getRightBorderColor();
            for (int i7 = 0; i7 < rowCount; ++i7) {
                this.borderData[(2 * colCount + 1) * i7 + 2 * colCount][0] = tableRightStyle;
                this.borderData[(2 * colCount + 1) * i7 + 2 * colCount][1] = tableRightWidth;
                this.borderData[(2 * colCount + 1) * i7 + 2 * colCount][2] = tableRightColor;
                this.borderData[(2 * colCount + 1) * i7 + 2 * colCount][3] = -2;
                this.borderData[(2 * colCount + 1) * i7 + 2 * colCount][4] = -2;
            }
        }
    }

    public void updateCellBorderInsets() {
        if (this.heights == null || this.widths == null) {
            this.initialize();
        }
        int rowCount = this.owner.getRowCount();
        int colCount = this.owner.getColumnCount();
        Iterator itr = this.owner.getChildren().iterator();
        while (itr.hasNext()) {
            int lw;
            int rw;
            int th;
            int bh;
            int i;
            int bh2;
            int th2;
            TableCellEditPart cellPart = (TableCellEditPart)((Object)itr.next());
            int rowIndex = cellPart.getRowNumber();
            int colIndex = cellPart.getColumnNumber();
            int rowSpan = cellPart.getRowSpan();
            int colSpan = cellPart.getColSpan();
            CellBorder border = (CellBorder)cellPart.getFigure().getBorder();
            Insets borderInsets = new Insets();
            if (rowIndex == 1 && rowIndex + rowSpan - 1 == rowCount) {
                th2 = 0;
                bh2 = 0;
                for (i = 0; i < colSpan; ++i) {
                    th2 = Math.max(th2, this.heights[colIndex - 1 + i][rowIndex - 1]);
                    bh2 = Math.max(bh2, this.heights[colIndex - 1 + i][rowIndex + rowSpan - 1]);
                }
                borderInsets.top = th2;
                borderInsets.bottom = bh2;
            } else if (rowIndex == 1) {
                bh = 0;
                th = 0;
                for (i = 0; i < colSpan; ++i) {
                    th = Math.max(th, this.heights[colIndex - 1 + i][rowIndex - 1]);
                    bh = Math.max(bh, this.heights[colIndex - 1 + i][rowIndex + rowSpan - 1] / 2 + this.heights[colIndex - 1 + i][rowIndex + rowSpan - 1] % 2);
                }
                borderInsets.top = th;
                borderInsets.bottom = bh;
            } else if (rowIndex + rowSpan - 1 == rowCount) {
                th2 = 0;
                bh2 = 0;
                for (i = 0; i < colSpan; ++i) {
                    th2 = Math.max(th2, this.heights[colIndex - 1 + i][rowIndex - 1] / 2);
                    bh2 = Math.max(bh2, this.heights[colIndex - 1 + i][rowIndex + rowSpan - 1]);
                }
                borderInsets.top = th2;
                borderInsets.bottom = bh2;
            } else {
                bh = 0;
                th = 0;
                for (i = 0; i < colSpan; ++i) {
                    th = Math.max(th, this.heights[colIndex - 1 + i][rowIndex - 1] / 2);
                    bh = Math.max(bh, this.heights[colIndex - 1 + i][rowIndex + rowSpan - 1] / 2 + this.heights[colIndex - 1 + i][rowIndex + rowSpan - 1] % 2);
                }
                borderInsets.top = th;
                borderInsets.bottom = bh;
            }
            if (colIndex == 1 && colIndex + colSpan - 1 == colCount) {
                rw = 0;
                lw = 0;
                for (i = 0; i < rowSpan; ++i) {
                    rw = Math.max(rw, this.widths[rowIndex - 1 + i][colIndex + colSpan - 1]);
                    lw = Math.max(lw, this.widths[rowIndex - 1 + i][colIndex - 1]);
                }
                borderInsets.left = lw;
                borderInsets.right = rw;
            } else if (colIndex == 1) {
                rw = 0;
                lw = 0;
                for (i = 0; i < rowSpan; ++i) {
                    lw = Math.max(lw, this.widths[rowIndex - 1 + i][colIndex - 1]);
                    rw = Math.max(rw, this.widths[rowIndex - 1 + i][colIndex + colSpan - 1] / 2 + this.widths[rowIndex - 1 + i][colIndex + colSpan - 1] % 2);
                }
                borderInsets.left = lw;
                borderInsets.right = rw;
            } else if (colIndex + colSpan - 1 == colCount) {
                int lw2 = 0;
                int rw2 = 0;
                for (i = 0; i < rowSpan; ++i) {
                    lw2 = Math.max(lw2, this.widths[rowIndex - 1 + i][colIndex - 1] / 2);
                    rw2 = Math.max(rw2, this.widths[rowIndex - 1 + i][colIndex + colSpan - 1]);
                }
                borderInsets.left = lw2;
                borderInsets.right = rw2;
            } else {
                rw = 0;
                lw = 0;
                for (i = 0; i < rowSpan; ++i) {
                    rw = Math.max(rw, this.widths[rowIndex - 1 + i][colIndex + colSpan - 1] / 2 + this.widths[rowIndex - 1 + i][colIndex + colSpan - 1] % 2);
                    lw = Math.max(lw, this.widths[rowIndex - 1 + i][colIndex - 1] / 2);
                }
                borderInsets.left = lw;
                borderInsets.right = rw;
            }
            border.setBorderInsets(borderInsets);
        }
    }

    public int[][] getBorderData() {
        if (this.borderData == null) {
            this.initialize();
        }
        return this.borderData;
    }
}

