/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.LabelEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.LabelFigure;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ColumnBindingDialog;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;

public class DataEditPart
extends LabelEditPart {
    private static final String FIGURE_DEFAULT_TEXT = Messages.getString((String)"DataEditPart.Figure.Dafault");

    public DataEditPart(Object model) {
        super(model);
    }

    protected IFigure createFigure() {
        LabelFigure label = new LabelFigure();
        label.setLayoutManager((LayoutManager)new StackLayout());
        return label;
    }

    public void performDirectEdit() {
        DataItemHandle handle = (DataItemHandle)this.getModel();
        handle.getModuleHandle().getCommandStack().startTrans(null);
        ColumnBindingDialog dialog = new ColumnBindingDialog(true);
        dialog.setInput((ReportItemHandle)handle);
        dialog.setGroupList(DEUtil.getGroups((DesignElementHandle)handle));
        if (dialog.open() == 0) {
            handle.getModuleHandle().getCommandStack().commit();
            this.refreshVisuals();
        } else {
            handle.getModuleHandle().getCommandStack().rollbackAll();
        }
    }

    public void refreshFigure() {
        super.refreshFigure();
        ((LabelFigure)this.getFigure()).setToolTipText(((DataItemHandle)this.getModel()).getResultSetColumn());
    }

    protected String getText() {
        String text = ((DataItemHandle)this.getModel()).getResultSetColumn();
        if (text == null || text.length() == 0) {
            text = FIGURE_DEFAULT_TEXT;
        } else {
            if (text.length() > 18) {
                text = text.substring(0, 16) + "...";
            }
            text = "[" + text + "]";
        }
        return text;
    }

    protected boolean hasText() {
        String text = ((DataItemHandle)this.getModel()).getResultSetColumn();
        return text != null && text.length() > 0;
    }
}

