/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.ListBandProxy;
import org.eclipse.birt.report.designer.core.model.schematic.ListHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BaseBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.SectionBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListBandEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ListLayoutEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportComponentEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportContainerEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ListFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.AbstractGuideHandle;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.TableGuideHandle;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;

public class ListEditPart
extends ReportElementEditPart {
    private static final String GUIDEHANDLE_TEXT = Messages.getString((String)"ListEditPart.GUIDEHANDLE_TEXT");

    public ListEditPart(Object obj) {
        super(obj);
    }

    protected AbstractGuideHandle createGuideHandle() {
        TableGuideHandle handle = new TableGuideHandle((GraphicalEditPart)this);
        handle.setIndicatorLabel(GUIDEHANDLE_TEXT);
        handle.setIndicatorIcon(ReportPlatformUIImages.getImage("List"));
        return handle;
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        switch (ev.getEventType()) {
            case 0: 
            case 17: {
                if (ev instanceof ContentEvent && ((ContentEvent)ev).getAction() == 2 && "ListGroup".equals(((ContentEvent)ev).getContent().getDefn().getName())) {
                    DesignElementHandle handle = ((ContentEvent)ev).getContent().getHandle(SessionHandleAdapter.getInstance().getReportDesignHandle().getModule());
                    handle.removeListener((Listener)this);
                    this.markDirty(true);
                    this.getListHandleAdapt().remove((Object)handle);
                    this.refresh();
                    break;
                }
                if (focus instanceof ListHandle) {
                    this.addListBandEditPart();
                }
                this.markDirty(true);
                this.refreshChildren();
                break;
            }
            case 1: {
                focus.removeListener((Listener)this);
                this.markDirty(true);
                this.getListHandleAdapt().remove((Object)focus);
                this.refresh();
                break;
            }
            case 5: {
                this.markDirty(true);
                this.reLayout();
                this.refresh();
                PropertyEvent event = (PropertyEvent)ev;
                if (event.getPropertyName().startsWith("border")) {
                    this.refreshVisuals();
                }
                if (!event.getPropertyName().equals("paddingTop") && !event.getPropertyName().equals("paddingBottom") && !event.getPropertyName().equals("paddingLeft") && !event.getPropertyName().equals("paddingRight")) break;
                this.getFigure().getParent().revalidate();
                break;
            }
            default: {
                this.markDirty(true);
                this.reLayout();
                this.refresh();
            }
        }
    }

    private void addListBandEditPart() {
        List list = this.getModelChildren();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ListBandProxy proxy = (ListBandProxy)list.get(i);
            proxy.getElemtHandle().addListener((Listener)this);
        }
    }

    public void activate() {
        super.activate();
        this.addListBandEditPart();
    }

    private void reLayout() {
        this.getFigure().invalidateTree();
        this.getFigure().getUpdateManager().addInvalidFigure(this.getFigure());
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ReportComponentEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new ReportContainerEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ListLayoutEditPolicy());
    }

    public void refreshFigure() {
        this.refreshBorder(this.getListHandleAdapt().getHandle(), (BaseBorder)this.getFigure().getBorder());
        ((SectionBorder)this.getFigure().getBorder()).setPaddingInsets(this.getListHandleAdapt().getPadding(this.getFigure().getInsets()));
        this.refreshMargin();
        this.refreshBackground((DesignElementHandle)this.getModel());
    }

    protected void refreshChildren() {
        super.refreshChildren();
        List list = this.getChildren();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ((ListBandEditPart)((Object)list.get(i))).refreshChildren();
        }
    }

    protected IFigure createFigure() {
        ListFigure figure = new ListFigure();
        figure.setOpaque(false);
        return figure;
    }

    protected List getModelChildren() {
        return this.getListHandleAdapt().getChildren();
    }

    private ListHandleAdapter getListHandleAdapt() {
        return (ListHandleAdapter)this.getModelAdapter();
    }

    public boolean insertGroup() {
        return UIUtil.createGroup(this.getListHandleAdapt().getHandle());
    }

    public boolean insertGroup(int position) {
        return UIUtil.createGroup(this.getListHandleAdapt().getHandle(), position);
    }

    public void removeGroup(Object group) {
        try {
            this.getListHandleAdapt().removeGroup(group);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    protected void notifyChildrenDirty(boolean bool) {
        super.notifyChildrenDirty(bool);
        if (bool) {
            this.reLayout();
        }
    }

    public void includeSlotHandle(boolean bool, int id) {
        Object model = this.getListHandleAdapt().getChild(id);
        ListBandEditPart part = (ListBandEditPart)((Object)this.getViewer().getEditPartRegistry().get(model));
        if (part == null) {
            return;
        }
        part.setRenderVisile(bool);
    }

    public boolean isIncludeSlotHandle(int id) {
        Object model = this.getListHandleAdapt().getChild(id);
        ListBandEditPart part = (ListBandEditPart)((Object)this.getViewer().getEditPartRegistry().get(model));
        if (part == null) {
            return false;
        }
        return part.isRenderVisile();
    }

    public void showTargetFeedback(Request request) {
        if (this.getSelected() == 0 && this.isActive() && request.getType() == "selection") {
            if (this.isFigureLeft(request)) {
                this.getViewer().setCursor(ReportPlugin.getDefault().getLeftCellCursor());
            } else {
                this.getViewer().setCursor(ReportPlugin.getDefault().getRightCellCursor());
            }
        }
        super.showTargetFeedback(request);
    }

    public void eraseTargetFeedback(Request request) {
        if (this.isActive()) {
            this.getViewer().setCursor(null);
        }
        super.eraseTargetFeedback(request);
    }

    protected void addChildVisual(EditPart part, int index) {
        this.getViewer().setCursor(null);
        super.addChildVisual(part, index);
    }
}

