/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.views.outline.ReportElementModel;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.ReportDesignMarginBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.MasterPageEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportElementFigure;
import org.eclipse.birt.report.designer.internal.ui.layout.AbstractPageFlowLayout;
import org.eclipse.birt.report.designer.internal.ui.layout.MasterPageLayout;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractEditPart;

public class MasterPageEditPart
extends ReportElementEditPart {
    private static final Point PRIVATE_POINT = new Point();
    private static final Insets DEFAULT_CROP = new Insets(-3, -3, -2, -2);
    private List children = new ArrayList();
    private Listener listener = new Listener(){

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            switch (ev.getEventType()) {
                case 19: {
                    MasterPageEditPart.this.reloadTheChildren();
                }
            }
        }
    };

    public MasterPageEditPart(Object model) {
        super(model);
    }

    public void elementChanged(DesignElementHandle element, NotificationEvent ev) {
        switch (ev.getEventType()) {
            case 0: 
            case 1: 
            case 5: 
            case 6: 
            case 15: 
            case 17: {
                this.markDirty(true);
                this.refresh();
                Iterator it = this.getChildren().iterator();
                while (it.hasNext()) {
                    ((AbstractEditPart)it.next()).refresh();
                }
                break;
            }
        }
    }

    public void activate() {
        super.activate();
        ((DesignElementHandle)this.getModel()).getContainer().addListener(this.listener);
        this.getFigure().setFocusTraversable(false);
    }

    public void deactivate() {
        super.deactivate();
        ((DesignElementHandle)this.getModel()).getContainer().removeListener(this.listener);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new MasterPageEditPolicy());
    }

    protected IFigure createFigure() {
        ReportElementFigure figure = new ReportElementFigure(){

            protected void paintBorder(Graphics graphics) {
            }

            protected void paintFigure(Graphics graphics) {
                super.paintFigure(graphics);
                graphics.setForegroundColor(ReportColorConstants.MarginBorderColor);
                graphics.drawRectangle(this.getBounds().getCopy().crop(this.getBorder().getInsets((IFigure)this)).crop(DEFAULT_CROP));
            }

            protected void paintChildren(Graphics graphics) {
                for (int i = 0; i < this.getChildren().size(); ++i) {
                    IFigure child = (IFigure)this.getChildren().get(i);
                    if (!child.isVisible()) continue;
                    graphics.setClip(this.getBounds().getCopy().intersect(child.getBounds()));
                    child.paint(graphics);
                    graphics.restoreState();
                }
            }

            protected IFigure findDescendantAtExcluding(int x, int y, TreeSearch search) {
                PRIVATE_POINT.setLocation(x, y);
                this.translateFromParent((Translatable)PRIVATE_POINT);
                if (!this.getBounds().contains(PRIVATE_POINT)) {
                    return null;
                }
                int i = this.getChildren().size();
                while (i > 0) {
                    IFigure fig = (IFigure)this.getChildren().get(--i);
                    if (!fig.isVisible() || (fig = fig.findFigureAt(PRIVATE_POINT.x, PRIVATE_POINT.y, search)) == null) continue;
                    return fig;
                }
                return null;
            }
        };
        figure.setOpaque(true);
        MasterPageLayout layout = new MasterPageLayout((GraphicalEditPart)this);
        MasterPageHandle masterPageHandle = (MasterPageHandle)this.getModel();
        Dimension size = this.getMasterPageSize((DesignElementHandle)masterPageHandle);
        Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
        layout.setInitSize(bounds);
        figure.setLayoutManager((LayoutManager)layout);
        figure.setBorder((Border)new ReportDesignMarginBorder(this.getMasterPageInsets((DesignElementHandle)((MasterPageHandle)this.getModel()))));
        figure.setBounds(bounds.getCopy());
        return figure;
    }

    public void refreshFigure() {
        int color = this.getBackgroundColor((DesignElementHandle)((MasterPageHandle)this.getModel()));
        this.getFigure().setBackgroundColor(ColorManager.getColor((int)color));
        Dimension size = this.getMasterPageSize((DesignElementHandle)((MasterPageHandle)this.getModel()));
        Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
        ((AbstractPageFlowLayout)this.getFigure().getLayoutManager()).setInitSize(bounds);
        ReportDesignMarginBorder reportDesignMarginBorder = new ReportDesignMarginBorder(this.getMasterPageInsets((DesignElementHandle)((MasterPageHandle)this.getModel())));
        reportDesignMarginBorder.setBackgroundColor(((MasterPageHandle)this.getModel()).getProperty("backgroundColor"));
        this.getFigure().setBorder((Border)reportDesignMarginBorder);
        this.refreshBackground((DesignElementHandle)((MasterPageHandle)this.getModel()));
    }

    protected List getModelChildren() {
        ReportElementModel model = new ReportElementModel(((SimpleMasterPageHandle)this.getModel()).getPageHeader());
        if (!this.children.contains(model)) {
            this.children.add(model);
        }
        if (!this.children.contains(model = new ReportElementModel(((SimpleMasterPageHandle)this.getModel()).getPageFooter()))) {
            this.children.add(model);
        }
        return this.children;
    }
}

