/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.NothingLocator;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.ColumnTracker;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.IContainer;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.AbstractHandle;

public class ColumnHandle
extends AbstractHandle
implements IContainer {
    private int columnNumber;

    protected DragTracker createDragTracker() {
        return new ColumnTracker((TableEditPart)this.getOwner(), this.columnNumber, this);
    }

    public ColumnHandle(TableEditPart owner, int number) {
        this(owner, new NothingLocator(owner.getFigure()), number);
    }

    public ColumnHandle(TableEditPart owner, Locator loc, int number) {
        super((GraphicalEditPart)owner, loc);
        this.columnNumber = number;
        this.initialize();
    }

    public boolean containsPoint(int x, int y) {
        return this.getBounds().getCopy().shrink(2, 2).contains(x, y);
    }

    public int getWidth() {
        TableEditPart part = (TableEditPart)this.getOwner();
        return HandleAdapterFactory.getInstance().getColumnHandleAdapter(part.getColumn(this.columnNumber)).getWidth();
    }

    protected void initialize() {
        this.setOpaque(true);
        LineBorder bd = new LineBorder(1);
        bd.setColor(ReportColorConstants.HandleBorderColor);
        this.setBorder((Border)bd);
        this.setCursor(Cursors.ARROW);
    }

    protected void paintFigure(Graphics graphics) {
        if (this.isSelect()) {
            graphics.setBackgroundColor(ReportColorConstants.SelctionFillColor);
        } else {
            graphics.setBackgroundColor(ReportColorConstants.TableGuideFillColor);
        }
        graphics.setLineStyle(1);
        Rectangle bounds = this.getBounds().getCopy();
        graphics.fillRectangle(bounds.resize(-1, -1));
        graphics.setBackgroundColor(ColorConstants.black);
    }

    public boolean contains(Point pt) {
        return false;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public boolean isSelect() {
        TableEditPart part = (TableEditPart)this.getOwner();
        List list = part.getViewer().getSelectedEditParts();
        Object obj = part.getColumn(this.getColumnNumber());
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (((EditPart)list.get(i)).getModel() != obj) continue;
            return true;
        }
        return false;
    }

    public GraphicalEditPart getOwner() {
        return super.getOwner();
    }
}

