/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.layer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.schematic.ColumnHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.RowHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ImageConstants;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;

public class TableGridLayer
extends GridLayer {
    private TableEditPart source;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TableGridLayer(TableEditPart source) {
        this.source = source;
    }

    public List getRows() {
        return this.source.getRows();
    }

    public List getColumns() {
        return this.source.getColumns();
    }

    protected void paintGrid(Graphics g) {
        Collections.sort(this.getRows(), new NumberComparator());
        Collections.sort(this.getColumns(), new NumberComparator());
        if (!this.getColumns().isEmpty()) {
            this.drawColumns(g);
        }
        if (!this.getRows().isEmpty()) {
            this.drawRows(g);
        }
    }

    protected void drawRows(Graphics g) {
        Rectangle clip = g.getClip(Rectangle.SINGLETON);
        List rows = this.getRows();
        int size = rows.size();
        int height = 0;
        for (int i = 0; i < size; ++i) {
            this.drawBackgroud(rows.get(i), g, new Rectangle(clip.x, height, clip.x + clip.width, this.getRowHeight(rows.get(i))));
            this.drawBackgroudImage((DesignElementHandle)rows.get(i), g, new Rectangle(clip.x, height, clip.x + clip.width, this.getRowHeight(rows.get(i))));
            height += this.getRowHeight(rows.get(i));
        }
    }

    private void drawBackgroudImage(DesignElementHandle handle, Graphics g, Rectangle rectangle) {
        String backGroundImage = this.getBackgroundImage(handle);
        Object backGroundPosition = this.getBackgroundPosition(handle);
        int backGroundRepeat = this.getBackgroundRepeat(handle);
        if (backGroundImage != null) {
            Image image = null;
            try {
                image = ImageManager.getInstance().getImage(backGroundImage);
            }
            catch (SWTException e) {
                image = null;
            }
            if (image != null) {
                int y;
                int x;
                Rectangle area = rectangle;
                int repeat = backGroundRepeat;
                int alignment = -1;
                Point position = new Point(-1, -1);
                if (backGroundPosition instanceof int[]) {
                    alignment = ((int[])backGroundPosition)[0] | ((int[])backGroundPosition)[1];
                } else if (backGroundPosition instanceof Point) {
                    position = (Point)backGroundPosition;
                } else if (backGroundPosition instanceof DimensionValue[]) {
                    int percentX = (int)((DimensionValue[])backGroundPosition)[0].getMeasure();
                    int percentY = (int)((DimensionValue[])backGroundPosition)[1].getMeasure();
                    org.eclipse.swt.graphics.Rectangle imageArea = image.getBounds();
                    int xPosition = (area.width - imageArea.width) * percentX / 100;
                    int yPosition = (area.height - imageArea.height) * percentY / 100;
                    position = new Point(xPosition, yPosition);
                }
                Dimension size = new Rectangle(image.getBounds()).getSize();
                if (position.x != -1 || position.y != -1) {
                    x = area.x + position.x;
                    y = area.y + position.y;
                } else {
                    switch (alignment & 5) {
                        case 1: {
                            y = area.y;
                            break;
                        }
                        case 4: {
                            y = area.y + area.height - size.height;
                            break;
                        }
                        default: {
                            y = (area.height - size.height) / 2 + area.y;
                        }
                    }
                    switch (alignment & 0x18) {
                        case 16: {
                            x = area.x + area.width - size.width;
                            break;
                        }
                        case 8: {
                            x = area.x;
                            break;
                        }
                        default: {
                            x = (area.width - size.width) / 2 + area.x;
                        }
                    }
                }
                ArrayList xyList = this.createImageList(x, y, size, repeat, rectangle);
                Iterator iter = xyList.iterator();
                Rectangle rect = new Rectangle();
                g.getClip(rect);
                g.setClip(rectangle);
                while (iter.hasNext()) {
                    Point point = (Point)iter.next();
                    g.drawImage(image, point);
                }
                g.setClip(rect);
                xyList.clear();
            }
        }
    }

    private ArrayList createImageList(int x, int y, Dimension size, int repeat, Rectangle rectangle) {
        Rectangle area = rectangle;
        ArrayList<Point> yList = new ArrayList<Point>();
        if ((repeat & ImageConstants.REPEAT_Y) == 0) {
            yList.add(new Point(x, y));
        } else {
            int i = 0;
            while (y + size.height * i + size.height > area.y) {
                yList.add(new Point(x, y + size.height * i));
                --i;
            }
            i = 1;
            while (y + size.height * i < area.y + area.height) {
                yList.add(new Point(x, y + size.height * i));
                ++i;
            }
        }
        ArrayList<Point> xyList = new ArrayList<Point>();
        Iterator iter = yList.iterator();
        while (iter.hasNext()) {
            Point point = (Point)iter.next();
            if ((repeat & ImageConstants.REPEAT_X) == 0) {
                xyList.add(point);
                continue;
            }
            int i = 0;
            while (point.x + size.width * i + size.width > area.x) {
                xyList.add(new Point(point.x + size.width * i, point.y));
                --i;
            }
            i = 1;
            while (point.x + size.width * i < area.x + area.width) {
                xyList.add(new Point(point.x + size.width * i, point.y));
                ++i;
            }
        }
        yList.clear();
        return xyList;
    }

    private RowHandleAdapter getRowAdapter(DesignElementHandle handle) {
        return HandleAdapterFactory.getInstance().getRowHandleAdapter((Object)handle);
    }

    private ColumnHandleAdapter getColumnAdapter(DesignElementHandle handle) {
        return HandleAdapterFactory.getInstance().getColumnHandleAdapter((Object)handle);
    }

    private String getBackgroundImage(DesignElementHandle handle) {
        if (handle instanceof RowHandle && this.getRowAdapter(handle) != null) {
            return this.getRowAdapter(handle).getBackgroundImage(handle);
        }
        if (handle instanceof ColumnHandle && this.getColumnAdapter(handle) != null) {
            return this.getColumnAdapter(handle).getBackgroundImage(handle);
        }
        return "";
    }

    private Object getBackgroundPosition(DesignElementHandle handle) {
        if (handle instanceof RowHandle && this.getRowAdapter(handle) != null) {
            return this.getRowAdapter(handle).getBackgroundPosition(handle);
        }
        if (handle instanceof ColumnHandle && this.getColumnAdapter(handle) != null) {
            return this.getColumnAdapter(handle).getBackgroundPosition(handle);
        }
        return null;
    }

    private int getBackgroundRepeat(DesignElementHandle handle) {
        if (handle instanceof RowHandle && this.getRowAdapter(handle) != null) {
            return this.getRowAdapter(handle).getBackgroundRepeat(handle);
        }
        if (handle instanceof ColumnHandle && this.getColumnAdapter(handle) != null) {
            return this.getColumnAdapter(handle).getBackgroundRepeat(handle);
        }
        return 0;
    }

    protected void drawColumns(Graphics g) {
        g.setBackgroundColor(ReportColorConstants.greyFillColor);
        Rectangle clip = g.getClip(Rectangle.SINGLETON);
        List columns = this.getColumns();
        int size = columns.size();
        int width = 0;
        for (int i = 0; i < size; ++i) {
            this.drawBackgroud(columns.get(i), g, new Rectangle(width, clip.y, this.getColumnWidth(columns.get(i)), clip.y + clip.height));
            this.drawBackgroudImage((DesignElementHandle)columns.get(i), g, new Rectangle(width, clip.y, this.getColumnWidth(columns.get(i)), clip.y + clip.height));
            width += this.getColumnWidth(columns.get(i));
        }
    }

    private int getRowHeight(Object row) {
        return TableUtil.caleVisualHeight(this.source, row);
    }

    private int getColumnWidth(Object column) {
        return TableUtil.caleVisualWidth(this.source, column);
    }

    private int getTableWidth() {
        int width = 0;
        Iterator it = this.getColumns().iterator();
        while (it.hasNext()) {
            width += TableUtil.caleVisualWidth(this.source, it.next());
        }
        return width;
    }

    public void drawBackgroud(Object model, Graphics g, Rectangle rect) {
        if (!$assertionsDisabled && !(model instanceof DesignElementHandle)) {
            throw new AssertionError();
        }
        DesignElementHandle handle = (DesignElementHandle)model;
        Object obj = handle.getProperty("backgroundColor");
        if (obj != null) {
            int color = 0xFFFFFF;
            color = obj instanceof String ? ColorUtil.parseColor((String)((String)obj)) : (Integer)obj;
            g.setBackgroundColor(ColorManager.getColor((int)color));
            g.fillRectangle(rect);
        }
    }

    static {
        $assertionsDisabled = !TableGridLayer.class.desiredAssertionStatus();
    }

    public static class NumberComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return 0;
        }
    }
}

