/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.AddStyleAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.AddThemeStyleAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.CreatePlaceHolderPartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.DeleteTableGroupAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.EditGroupAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertGroupActionFactory;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DataEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DummyEditpart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.GridEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ImageEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.LabelEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListBandEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.views.actions.CopyAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.CutAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.DeleteAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.PasteAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.RefreshModuleHandleAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.actions.GeneralInsertMenuAction;
import org.eclipse.birt.report.designer.ui.actions.InsertPasteColumnAction;
import org.eclipse.birt.report.designer.ui.actions.MenuUpdateAction;
import org.eclipse.birt.report.designer.ui.actions.NoneAction;
import org.eclipse.birt.report.designer.ui.extensions.IMenuBuilder;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TemplateReportItemHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.ActionFactory;

public class SchematicContextMenuProvider
extends ContextMenuProvider {
    private static final String INSERT_ROW_MENU_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.insertRow");
    private static final String EDIT_GROUP_MENU_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.EditGroup");
    private static final String APPLY_STYLE_MENU_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.Apply");
    private static final String STYLE_MENU_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.Style");
    private static final String INSERT_MENU_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.Insert");
    private static final String ELEMENT_MENU_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.insertElement");
    private static final String EDIT_STYLE_MENU_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.EditStyle");
    private static final String DELETE_STYLE_MENU_ITEM_TEXT = Messages.getString((String)"SchematicContextMenuProvider.Menu.DeleteStyle");
    private final ActionRegistry actionRegistry;

    public SchematicContextMenuProvider(EditPartViewer viewer, ActionRegistry actionRegistry) {
        super(viewer);
        this.actionRegistry = actionRegistry;
    }

    public ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    protected IAction getAction(String actionID) {
        IAction action = this.getActionRegistry().getAction((Object)actionID);
        if (action instanceof UpdateAction) {
            ((UpdateAction)action).update();
        }
        return action;
    }

    protected ISelection getSelection() {
        return this.getViewer().getSelection();
    }

    protected List getSelectedObjects() {
        if (!(this.getSelection() instanceof IStructuredSelection)) {
            return Collections.EMPTY_LIST;
        }
        return ((IStructuredSelection)this.getSelection()).toList();
    }

    public void buildContextMenu(IMenuManager menuManager) {
        Separator separator;
        GEFActionConstants.addStandardActionGroups((IMenuManager)menuManager);
        Object firstSelectedElement = this.getFirstElement();
        Object selectedElements = this.getSelectedElement();
        Object multiSelection = this.getMultiSelectedElement();
        if (this.isMutilSelection(multiSelection)) {
            RefreshModuleHandleAction action;
            menuManager.appendToGroup("org.eclipse.gef.group.undo", this.getAction(ActionFactory.UNDO.getId()));
            menuManager.appendToGroup("org.eclipse.gef.group.undo", this.getAction(ActionFactory.REDO.getId()));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new CutAction(selectedElements));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new CopyAction(selectedElements));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new PasteAction(selectedElements));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new DeleteAction(selectedElements));
            if (this.isRootElementHandleClass(multiSelection)) {
                action = new RefreshModuleHandleAction(selectedElements);
                menuManager.add((IAction)action);
                this.createInsertElementMenu(menuManager, "org.eclipse.gef.group.edit");
                this.createThemeMenu(menuManager, "org.eclipse.gef.group.rest");
            }
            if (this.isListHandleCalss(multiSelection)) {
                action = this.getAction(CreatePlaceHolderPartAction.ID);
                menuManager.appendToGroup("org.eclipse.gef.group.edit", (IAction)action);
            }
            this.createStyleMenu(menuManager, "org.eclipse.gef.group.rest");
            if (Policy.TRACING_MENU_SHOW) {
                System.out.println("Menu(for Editor) >> Shows for multi-selcetion.");
            }
        } else if (firstSelectedElement instanceof DesignElementHandle) {
            menuManager.appendToGroup("org.eclipse.gef.group.undo", this.getAction(ActionFactory.UNDO.getId()));
            menuManager.appendToGroup("org.eclipse.gef.group.undo", this.getAction(ActionFactory.REDO.getId()));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new CutAction(selectedElements));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new CopyAction(selectedElements));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new PasteAction(selectedElements));
            this.createStyleMenu(menuManager, "org.eclipse.gef.group.rest");
            if (((IStructuredSelection)this.getSelection()).size() == 1) {
                IAction action;
                Object element = ((IStructuredSelection)this.getSelection()).getFirstElement();
                if (element instanceof LabelEditPart || element instanceof ImageEditPart) {
                    action = this.getAction("org.eclipse.gef.direct_edit");
                    action.setAccelerator(0x100000B);
                    if (element instanceof DataEditPart) {
                        action.setText(Messages.getString((String)"SchematicContextMenuProvider.ActionText.editData"));
                    } else {
                        action.setText(Messages.getString((String)"SchematicContextMenuProvider.ActionText.editLabel"));
                    }
                    menuManager.appendToGroup("org.eclipse.gef.group.edit", action);
                }
                if (firstSelectedElement instanceof ReportItemHandle) {
                    action = this.getAction(CreatePlaceHolderPartAction.ID);
                    menuManager.appendToGroup("org.eclipse.gef.group.edit", action);
                    action = this.getAction("org.eclipse.birt.report.designer.internal.ui.views.actions.RevertToReportItemAction");
                    menuManager.appendToGroup("org.eclipse.gef.group.edit", action);
                    action = this.getAction("org.eclipse.birt.report.designer.internal.ui.views.actions.RevertToTemplateAction");
                    menuManager.appendToGroup("org.eclipse.gef.group.edit", action);
                }
                if (firstSelectedElement instanceof TemplateReportItemHandle) {
                    action = this.getAction("org.eclipse.birt.report.designer.internal.ui.views.actions.RevertToReportItemAction");
                    menuManager.appendToGroup("org.eclipse.gef.group.edit", action);
                }
            }
            if (firstSelectedElement instanceof RowHandle) {
                if (this.getRowHandles().size() != 0) {
                    MenuManager insertMenu = new MenuManager(INSERT_MENU_ITEM_TEXT);
                    MenuManager rowMenu = new MenuManager(INSERT_ROW_MENU_ITEM_TEXT);
                    rowMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertRowAboveAction"));
                    rowMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertRowBelowAction"));
                    RowHandle row = (RowHandle)this.getRowHandles().get(0);
                    if (!(row.getContainer() instanceof GridHandle)) {
                        insertMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.IncludeHeaderAction"));
                        insertMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.IncludeDetailAction"));
                        insertMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.IncludeFooterAction"));
                    }
                    insertMenu.add((IContributionItem)rowMenu);
                    menuManager.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)insertMenu);
                }
                menuManager.appendToGroup("org.eclipse.gef.group.copy", this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.DeleteRowAction"));
                menuManager.appendToGroup("org.eclipse.gef.group.edit", this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.Merge"));
                menuManager.appendToGroup("org.eclipse.gef.group.edit", this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SplitAction"));
            } else if (firstSelectedElement instanceof ColumnHandle) {
                menuManager.appendToGroup("org.eclipse.gef.group.edit", (IAction)new InsertPasteColumnAction(selectedElements));
                if (this.getColumnHandles().size() != 0) {
                    MenuManager subMenu = new MenuManager(INSERT_MENU_ITEM_TEXT);
                    subMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertColumnRightAction"));
                    subMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertColumnLeftAction"));
                    menuManager.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)subMenu);
                }
                menuManager.appendToGroup("org.eclipse.gef.group.copy", this.getAction("DeleteGroupAction.DeleteColumnAction"));
                menuManager.appendToGroup("org.eclipse.gef.group.edit", this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.Merge"));
                menuManager.appendToGroup("org.eclipse.gef.group.edit", this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SplitAction"));
            } else if (firstSelectedElement instanceof CellHandle) {
                this.createInsertElementMenu(menuManager, "org.eclipse.gef.group.edit");
                menuManager.appendToGroup("org.eclipse.gef.group.edit", this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.Merge"));
                menuManager.appendToGroup("org.eclipse.gef.group.edit", this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SplitAction"));
                menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new DeleteAction(selectedElements));
            } else {
                menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new DeleteAction(selectedElements));
            }
            if (Policy.TRACING_MENU_SHOW) {
                System.out.println("Menu(for Editor) >> Shows for " + ((DesignElementHandle)firstSelectedElement).getDefn().getDisplayName());
            }
        } else if (firstSelectedElement instanceof SlotHandle) {
            menuManager.appendToGroup("org.eclipse.gef.group.undo", this.getAction(ActionFactory.UNDO.getId()));
            menuManager.appendToGroup("org.eclipse.gef.group.undo", this.getAction(ActionFactory.REDO.getId()));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new CutAction(selectedElements));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new CopyAction(selectedElements));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new PasteAction(selectedElements));
            menuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)new DeleteAction(selectedElements));
            this.createInsertElementMenu(menuManager, "org.eclipse.gef.group.edit");
            if (Policy.TRACING_MENU_SHOW) {
                System.out.println("Menu(for Editor) >> Shows for the slot " + ((SlotHandle)firstSelectedElement).getSlotID() + " of " + ((SlotHandle)firstSelectedElement).getElementHandle().getDefn().getDisplayName());
            }
        }
        if (!this.getTableEditParts().isEmpty()) {
            this.createInsertGroupMenu(menuManager, "group.add");
            menuManager.appendToGroup("group.add", this.getAction(DeleteTableGroupAction.ID));
            if (this.getTableEditParts().size() == 1) {
                this.createEditGroupMenu(menuManager, "group.add");
                separator = new Separator("org.eclipse.birt.report.designer.action.editBinding");
                menuManager.add((IContributionItem)separator);
                menuManager.appendToGroup("org.eclipse.birt.report.designer.action.editBinding", this.getAction("org.eclipse.birt.report.designer.action.editBinding"));
            }
        }
        if (!this.getListEditParts().isEmpty()) {
            this.createInsertGroupMenu(menuManager, "group.add");
            menuManager.appendToGroup("group.add", this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.DeleteListGroup"));
            if (this.getListEditParts().size() == 1) {
                this.createEditGroupMenu(menuManager, "group.add");
                separator = new Separator("org.eclipse.birt.report.designer.action.editBinding");
                menuManager.add((IContributionItem)separator);
                menuManager.appendToGroup("org.eclipse.birt.report.designer.action.editBinding", this.getAction("org.eclipse.birt.report.designer.action.editBinding"));
            }
        }
        if ((this.getElements().size() == 1 || this.isMutilSelection(multiSelection)) && firstSelectedElement instanceof DesignElementHandle) {
            String elementName = ((DesignElementHandle)firstSelectedElement).getDefn().getName();
            IMenuBuilder menuBuilder = ExtensionPointManager.getInstance().getMenuBuilder(elementName);
            if (menuBuilder != null) {
                menuBuilder.buildMenu(menuManager, this.getElements());
            }
        }
    }

    private boolean isListHandleCalss(Object multiSelection) {
        return multiSelection == ListHandle.class;
    }

    private boolean isMutilSelection(Object multiSelection) {
        return multiSelection != null && (multiSelection == Object.class || multiSelection == DesignElementHandle.class || this.isRootElementHandleClass(multiSelection) || multiSelection == ReportItemHandle.class);
    }

    private boolean isRootElementHandleClass(Object obj) {
        return obj == ReportDesignHandle.class || obj == LibraryHandle.class;
    }

    private void createInsertGroupMenu(IMenuManager menuManager, String group_name) {
        DesignElementHandle container;
        RowHandle row;
        if ((this.getFirstElement() instanceof CellHandle || this.getFirstElement() instanceof RowHandle) && !((row = this.getFirstElement() instanceof CellHandle ? (RowHandle)((CellHandle)this.getFirstElement()).getContainer() : (RowHandle)this.getFirstElement()).getContainer() instanceof TableGroupHandle)) {
            int slotID = row.getContainerSlotHandle().getSlotID();
            menuManager.appendToGroup(group_name, (IAction)InsertGroupActionFactory.createInsertGroupAction(slotID, this.getSelectedObjects()));
            return;
        }
        if (this.getFirstElement() instanceof SlotHandle && !((container = ((SlotHandle)this.getFirstElement()).getElementHandle()) instanceof ListGroupHandle)) {
            int slotID = ((SlotHandle)this.getFirstElement()).getSlotID();
            menuManager.appendToGroup(group_name, (IAction)InsertGroupActionFactory.createInsertGroupAction(slotID, this.getSelectedObjects()));
            return;
        }
        MenuManager subMenu = new MenuManager(Messages.getString((String)"InsertGroupAction.actionMsg.group"));
        Action[] actions = InsertGroupActionFactory.getInsertGroupActions(this.getSelectedObjects());
        for (int i = 0; i < actions.length; ++i) {
            subMenu.add((IAction)actions[i]);
        }
        menuManager.appendToGroup(group_name, (IContributionItem)subMenu);
    }

    private void createInsertElementMenu(IMenuManager menuManager, String group_name) {
        MenuManager subMenu = new MenuManager(ELEMENT_MENU_ITEM_TEXT);
        IAction action = this.getAction("Insert Text");
        action.setText(GeneralInsertMenuAction.INSERT_TEXT_DISPLAY_TEXT);
        subMenu.add(action);
        action = this.getAction("Insert Label");
        action.setText(GeneralInsertMenuAction.INSERT_LABEL_DISPLAY_TEXT);
        subMenu.add(action);
        action = this.getAction("Insert Data");
        action.setText(GeneralInsertMenuAction.INSERT_DATA_DISPLAY_TEXT);
        subMenu.add(action);
        action = this.getAction("Insert Image");
        action.setText(GeneralInsertMenuAction.INSERT_IMAGE_DISPLAY_TEXT);
        subMenu.add(action);
        action = this.getAction("Insert Grid");
        action.setText(GeneralInsertMenuAction.INSERT_GRID_DISPLAY_TEXT);
        subMenu.add(action);
        action = this.getAction("Insert List");
        action.setText(GeneralInsertMenuAction.INSERT_LIST_DISPLAY_TEXT);
        subMenu.add(action);
        action = this.getAction("Insert Table");
        action.setText(GeneralInsertMenuAction.INSERT_TABLE_DISPLAY_TEXT);
        subMenu.add(action);
        action = this.getAction("Insert Dynamic Text");
        action.setText(GeneralInsertMenuAction.INSERT_DYNAMIC_TEXT_DISPLAY_TEXT);
        subMenu.add(action);
        List points = ExtensionPointManager.getInstance().getExtendedElementPoints();
        Iterator iter = points.iterator();
        while (iter.hasNext()) {
            ExtendedElementUIPoint point = (ExtendedElementUIPoint)iter.next();
            IElementDefn extension = DesignEngine.getMetaDataDictionary().getExtension(point.getExtensionName());
            String displayName = new String();
            displayName = extension.getDisplayName();
            action = this.getAction(point.getExtensionName());
            if (action == null) continue;
            if (displayName.equalsIgnoreCase("Chart")) {
                action.setText("&" + displayName);
            } else {
                action.setText(displayName);
            }
            subMenu.add(action);
        }
        menuManager.appendToGroup(group_name, (IContributionItem)subMenu);
    }

    private void createStyleMenu(IMenuManager menuManager, String group_name) {
        MenuManager menu = new MenuManager(STYLE_MENU_ITEM_TEXT);
        MenuManager subMenu = new MenuManager(APPLY_STYLE_MENU_ITEM_TEXT);
        subMenu.add((IAction)NoneAction.getInstance());
        subMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SchematicContextMenuProvider.this.updateDynamicItems("apply style menu", manager);
            }
        });
        menu.add((IContributionItem)subMenu);
        menu.add((IContributionItem)new Separator());
        subMenu = new MenuManager(EDIT_STYLE_MENU_ITEM_TEXT);
        subMenu.add((IAction)NoneAction.getInstance());
        subMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SchematicContextMenuProvider.this.updateDynamicItems("edit style menu", manager);
            }
        });
        menu.add((IContributionItem)subMenu);
        subMenu = new MenuManager(DELETE_STYLE_MENU_ITEM_TEXT);
        subMenu.add((IAction)NoneAction.getInstance());
        subMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SchematicContextMenuProvider.this.updateDynamicItems("delete style menu", manager);
            }
        });
        menu.add((IContributionItem)subMenu);
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction("ImportCSSStyleAction"));
        this.populateAddStyleAction(menu);
        menuManager.appendToGroup(group_name, (IContributionItem)menu);
    }

    private void populateAddStyleAction(MenuManager menu) {
        if (SessionHandleAdapter.getInstance().getReportDesignHandle() instanceof ReportDesignHandle) {
            menu.add(this.getAction("AddStyleAction"));
        } else if (SessionHandleAdapter.getInstance().getReportDesignHandle() instanceof LibraryHandle) {
            LibraryHandle libraryHandle = (LibraryHandle)SessionHandleAdapter.getInstance().getReportDesignHandle();
            MenuManager subMenu = new MenuManager("New Style");
            SlotHandle themeSlot = libraryHandle.getThemes();
            Iterator iter = themeSlot.getContents().iterator();
            while (iter.hasNext()) {
                ThemeHandle theme = (ThemeHandle)iter.next();
                subMenu.add((IAction)new AddThemeStyleAction(theme, (AddStyleAction)this.getAction("AddStyleAction")));
            }
            menu.add((IContributionItem)subMenu);
        }
    }

    private void createThemeMenu(IMenuManager menuManager, String group_name) {
        MenuManager menu = new MenuManager(Messages.getString((String)"SchematicContextMenuProvider.Menu.Theme"));
        MenuManager subMenu = new MenuManager(Messages.getString((String)"SchematicContextMenuProvider.menutitle.applythemerule"));
        subMenu.add((IAction)NoneAction.getInstance());
        subMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SchematicContextMenuProvider.this.updateDynamicItems("apply theme menu", manager);
            }
        });
        menu.add((IContributionItem)subMenu);
        menu.add((IContributionItem)new Separator());
        menuManager.appendToGroup(group_name, (IContributionItem)menu);
    }

    private void updateDynamicItems(String actionId, IMenuManager menu) {
        IAction action = this.getAction(actionId);
        if (action != null && action instanceof MenuUpdateAction) {
            ((MenuUpdateAction)action).updateMenu((MenuManager)menu);
        }
    }

    private void createEditGroupMenu(IMenuManager menuManager, String group_name) {
        DesignElementHandle container;
        if (this.getFirstElement() instanceof RowHandle && (container = ((RowHandle)this.getFirstElement()).getContainer()) instanceof TableGroupHandle) {
            EditGroupAction action = new EditGroupAction(null, (GroupHandle)((TableGroupHandle)container));
            action.setText(EDIT_GROUP_MENU_ITEM_TEXT);
            menuManager.appendToGroup(group_name, (IAction)action);
            return;
        }
        if (this.getFirstElement() instanceof SlotHandle && (container = ((SlotHandle)this.getFirstElement()).getElementHandle()) instanceof ListGroupHandle) {
            EditGroupAction action = new EditGroupAction(null, (GroupHandle)((ListGroupHandle)container));
            action.setText(EDIT_GROUP_MENU_ITEM_TEXT);
            menuManager.appendToGroup(group_name, (IAction)action);
            return;
        }
        MenuManager subMenu = new MenuManager(EDIT_GROUP_MENU_ITEM_TEXT);
        ListingHandle parentHandle = null;
        if (!this.getTableEditParts().isEmpty()) {
            parentHandle = (ListingHandle)((TableEditPart)((Object)this.getTableEditParts().get(0))).getModel();
        } else if (!this.getListEditParts().isEmpty()) {
            parentHandle = (ListingHandle)((ListEditPart)((Object)this.getListEditParts().get(0))).getModel();
        } else {
            return;
        }
        SlotHandle handle = parentHandle.getGroups();
        Iterator iter = handle.iterator();
        while (iter.hasNext()) {
            GroupHandle groupHandle = (GroupHandle)iter.next();
            subMenu.add((IAction)new EditGroupAction(null, groupHandle));
        }
        menuManager.appendToGroup(group_name, (IContributionItem)subMenu);
    }

    protected List getElements() {
        return InsertInLayoutUtil.editPart2Model(this.getSelection()).toList();
    }

    protected Object getSelectedElement() {
        Object[] array = this.getElements().toArray();
        if (array.length == 1) {
            return array[0];
        }
        return array;
    }

    protected Object getFirstElement() {
        Object[] array = this.getElements().toArray();
        if (array.length > 0) {
            return array[0];
        }
        return null;
    }

    private Object getMultiSelectedElement() {
        List list = this.getElements();
        Object baseHandle = list.get(0);
        if (baseHandle != null) {
            Class<?> base = baseHandle.getClass();
            for (int i = 1; i < list.size(); ++i) {
                Object obj = list.get(i);
                if (base.isInstance(obj)) continue;
                while (!base.isInstance(obj)) {
                    base = base.getSuperclass();
                }
            }
            return base;
        }
        return null;
    }

    public List getRowHandles() {
        List list = this.getSelectedObjects();
        if (list.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> rowHandles = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof DummyEditpart) || !(((DummyEditpart)((Object)obj)).getModel() instanceof RowHandle)) continue;
            rowHandles.add(((DummyEditpart)((Object)obj)).getModel());
        }
        return rowHandles;
    }

    public List getColumnHandles() {
        List list = this.getSelectedObjects();
        if (list.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> columnHandles = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof DummyEditpart) || !(((DummyEditpart)((Object)obj)).getModel() instanceof ColumnHandle)) continue;
            columnHandles.add(((DummyEditpart)((Object)obj)).getModel());
        }
        return columnHandles;
    }

    protected List getTableEditParts() {
        ArrayList tableParts = new ArrayList();
        Iterator itor = this.getSelectedObjects().iterator();
        while (itor.hasNext()) {
            Object obj = itor.next();
            if (obj instanceof DummyEditpart) continue;
            if (obj instanceof TableEditPart) {
                if (obj instanceof GridEditPart) {
                    return Collections.EMPTY_LIST;
                }
                if (tableParts.contains(obj)) continue;
                tableParts.add(obj);
                continue;
            }
            if (obj instanceof TableCellEditPart) {
                TableEditPart parent2 = (TableEditPart)((TableCellEditPart)((Object)obj)).getParent();
                TableEditPart parent = parent2;
                if (parent instanceof GridEditPart) {
                    return Collections.EMPTY_LIST;
                }
                if (tableParts.contains((Object)parent)) continue;
                tableParts.add(parent);
                continue;
            }
            return Collections.EMPTY_LIST;
        }
        return tableParts;
    }

    protected List getListEditParts() {
        ArrayList listParts = new ArrayList();
        Iterator iter = this.getSelectedObjects().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof ListEditPart) {
                if (listParts.contains(obj)) continue;
                listParts.add(obj);
                continue;
            }
            if (obj instanceof ListBandEditPart) {
                ListEditPart parent2 = (ListEditPart)((ListBandEditPart)((Object)obj)).getParent();
                ListEditPart parent = parent2;
                if (listParts.contains((Object)parent)) continue;
                listParts.add(parent);
                continue;
            }
            return Collections.EMPTY_LIST;
        }
        return listParts;
    }
}

