/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.ColumnHandle;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.IContainer;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.TableSelectionGuideTracker;
import org.eclipse.gef.Handle;

public class ColumnTracker
extends TableSelectionGuideTracker {
    IContainer container;

    public ColumnTracker(TableEditPart sourceEditPart, int column, IContainer container) {
        super(sourceEditPart, column);
        this.container = container;
    }

    public void select() {
        if (this.container.isSelect() && this.getCurrentInput().isMouseButtonDown(3)) {
            return;
        }
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        part.selectColumn(new int[]{this.getNumber()});
    }

    protected boolean handleButtonUp(int button) {
        boolean rlt = super.handleButtonUp(button);
        if (button == 1 && this.container != null && this.container.contains(this.getLocation())) {
            this.getSourceEditPart().getViewer().getContextMenu().getMenu().setVisible(true);
        }
        return rlt;
    }

    public boolean isDealwithDrag() {
        Handle handle = this.getHandleUnderMouse();
        if (handle instanceof ColumnHandle) {
            return ((ColumnHandle)handle).getOwner() == this.getSourceEditPart();
        }
        return false;
    }

    public void selectDrag() {
        ColumnHandle handle = (ColumnHandle)this.getHandleUnderMouse();
        int columnNumber = handle.getColumnNumber();
        int number = this.getNumber();
        int[] columns = new int[]{};
        for (int i = number; i <= number + Math.abs(number - columnNumber); ++i) {
            int lenegth = columns.length;
            int[] temp = new int[lenegth + 1];
            System.arraycopy(columns, 0, temp, 0, lenegth);
            temp[lenegth] = number > columnNumber ? number - (i - number) : i;
            columns = temp;
        }
        if (columns.length > 0) {
            TableEditPart tableEditpart = (TableEditPart)this.getSourceEditPart();
            tableEditpart.selectColumn(columns);
        }
    }
}

