/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.extension;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedUIAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.extensions.IMenuBuilder;
import org.eclipse.birt.report.designer.ui.extensions.IProviderFactory;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;

public class ExtensionPointManager {
    private Map reportItemUIMap = null;
    private Map menuBuilderMap = null;
    private Map providerFactoryMap = null;
    private static ExtensionPointManager instance = null;

    private ExtensionPointManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExtensionPointManager getInstance() {
        if (instance == null) {
            Class clazz = ExtensionPointManager.class;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new ExtensionPointManager();
                }
            }
        }
        return instance;
    }

    public List getExtendedElementPoints() {
        return Arrays.asList(this.getReportItemUIMap().values().toArray());
    }

    public ExtendedElementUIPoint getExtendedElementPoint(String extensionName) {
        Assert.isLegal((extensionName != null ? 1 : 0) != 0);
        return (ExtendedElementUIPoint)this.getReportItemUIMap().get(extensionName);
    }

    public IMenuBuilder getMenuBuilder(String elementName) {
        return (IMenuBuilder)this.getMenuBuilderMap().get(elementName);
    }

    public IProviderFactory getProviderFactory(String elementName) {
        return (IProviderFactory)this.getProviderFactoryMap().get(elementName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getReportItemUIMap() {
        ExtensionPointManager extensionPointManager = this;
        synchronized (extensionPointManager) {
            if (this.reportItemUIMap == null) {
                this.reportItemUIMap = new HashMap();
                Iterator iter = this.getExtensionElements("org.eclipse.birt.report.designer.ui.reportitemUI").iterator();
                while (iter.hasNext()) {
                    IExtension extension = (IExtension)iter.next();
                    ExtendedElementUIPoint point = this.createReportItemUIPoint(extension);
                    if (point == null) continue;
                    this.reportItemUIMap.put(point.getExtensionName(), point);
                }
            }
        }
        return this.reportItemUIMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getMenuBuilderMap() {
        ExtensionPointManager extensionPointManager = this;
        synchronized (extensionPointManager) {
            if (this.menuBuilderMap == null) {
                this.menuBuilderMap = new HashMap();
                Iterator iter = this.getExtensionElements("org.eclipse.birt.report.designer.ui.menuBuilders").iterator();
                while (iter.hasNext()) {
                    IExtension extension = (IExtension)iter.next();
                    IConfigurationElement[] elements = extension.getConfigurationElements();
                    for (int i = 0; i < elements.length; ++i) {
                        if (!"menuBuilder".equals(elements[i].getName())) continue;
                        String elementId = elements[i].getAttribute("elementName");
                        try {
                            Object menuBuilder = elements[i].createExecutableExtension("class");
                            if (!(menuBuilder instanceof IMenuBuilder)) continue;
                            this.menuBuilderMap.put(elementId, menuBuilder);
                            continue;
                        }
                        catch (CoreException e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return this.menuBuilderMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getProviderFactoryMap() {
        ExtensionPointManager extensionPointManager = this;
        synchronized (extensionPointManager) {
            if (this.providerFactoryMap == null) {
                this.providerFactoryMap = new HashMap();
                Iterator iter = this.getExtensionElements("org.eclipse.birt.report.designer.ui.providerFactories").iterator();
                while (iter.hasNext()) {
                    IExtension extension = (IExtension)iter.next();
                    IConfigurationElement[] elements = extension.getConfigurationElements();
                    for (int i = 0; i < elements.length; ++i) {
                        if (!"providerFactory".equals(elements[i].getName())) continue;
                        String elementId = elements[i].getAttribute("elementName");
                        try {
                            Object factory = elements[i].createExecutableExtension("class");
                            if (!(factory instanceof IProviderFactory)) continue;
                            this.providerFactoryMap.put(elementId, factory);
                            continue;
                        }
                        catch (CoreException e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return this.providerFactoryMap;
    }

    private List getExtensionElements(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            return Collections.EMPTY_LIST;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(id);
        if (extensionPoint == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(extensionPoint.getExtensions());
    }

    private ExtendedElementUIPoint createReportItemUIPoint(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements != null && elements.length > 0) {
            return this.loadElements(elements);
        }
        return null;
    }

    private ExtendedElementUIPoint loadElements(IConfigurationElement[] elements) {
        ExtendedElementUIPoint newPoint = new ExtendedElementUIPoint();
        if (elements != null) {
            try {
                for (int i = 0; i < elements.length; ++i) {
                    this.loadAttributes(newPoint, elements[i]);
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle(e);
                return null;
            }
        }
        if (DesignEngine.getMetaDataDictionary().getExtension(newPoint.getExtensionName()) == null) {
            return null;
        }
        if (Policy.TRACING_EXTENSION_LOAD) {
            System.out.println("GUI Extesion Manager >> Loads " + newPoint.getExtensionName());
        }
        return newPoint;
    }

    private void loadAttributes(ExtendedElementUIPoint newPoint, IConfigurationElement element) throws CoreException {
        String elementName = element.getName();
        if ("model".equals(elementName)) {
            String value = element.getAttribute("extensionName");
            newPoint.setExtensionName(value);
        } else if ("reportItemFigureUI".equals(elementName) || "reportItemImageUI".equals(elementName) || "reportItemLabelUI".equals(elementName)) {
            String className = element.getAttribute("class");
            if (className != null) {
                Object ui = element.createExecutableExtension("class");
                newPoint.setReportItemUI(new ExtendedUIAdapter(ui));
            }
        } else if ("builder".equals(elementName)) {
            this.loadClass(newPoint, element, "class", "builder");
        } else if ("propertyPage".equals(elementName)) {
            this.loadClass(newPoint, element, "class", "propertyPage");
        } else if ("palette".equals(elementName)) {
            this.loadIconAttribute(newPoint, element, "paletteIcon", false);
            this.loadStringAttribute(newPoint, element, "category");
            this.loadStringAttribute(newPoint, element, "categoryDisplayName");
        } else if ("editor".equals(elementName)) {
            this.loadBooleanAttribute(newPoint, element, "showInDesigner");
            this.loadBooleanAttribute(newPoint, element, "showInMasterPage");
            this.loadBooleanAttribute(newPoint, element, "canResize");
        } else if ("outline".equals(elementName)) {
            this.loadIconAttribute(newPoint, element, "outlineIcon", true);
        }
    }

    private void loadClass(ExtendedElementUIPoint newPoint, IConfigurationElement element, String className, String attributeName) {
        String value = element.getAttribute(className);
        if (value != null) {
            try {
                newPoint.setClass(attributeName, element.createExecutableExtension(className));
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
    }

    private ImageDescriptor getImageDescriptor(IConfigurationElement element) {
        Assert.isLegal((element != null ? 1 : 0) != 0);
        IExtension extension = element.getDeclaringExtension();
        String iconPath = element.getAttribute("icon");
        if (iconPath == null) {
            return null;
        }
        URL path = Platform.getBundle((String)extension.getNamespace()).getEntry("/");
        try {
            return ImageDescriptor.createFromURL((URL)new URL(path, iconPath));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private void loadStringAttribute(ExtendedElementUIPoint newPoint, IConfigurationElement element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (value != null) {
            newPoint.setAttribute(attributeName, value);
        }
    }

    private void loadBooleanAttribute(ExtendedElementUIPoint newPoint, IConfigurationElement element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (value != null) {
            newPoint.setAttribute(attributeName, Boolean.valueOf(value));
        }
    }

    private void loadIconAttribute(ExtendedElementUIPoint newPoint, IConfigurationElement element, String attributeName, boolean shared) {
        ImageDescriptor imageDescriptor = this.getImageDescriptor(element);
        if (imageDescriptor != null) {
            if (shared) {
                String symbolName = ReportPlatformUIImages.getIconSymbolName(newPoint.getExtensionName(), attributeName);
                ReportPlatformUIImages.declareImage(symbolName, imageDescriptor);
            }
            newPoint.setAttribute(attributeName, imageDescriptor);
        }
    }
}

