/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.layout;

import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportElementFigure;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportFlowLayout;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;

public abstract class AbstractPageFlowLayout
extends ReportFlowLayout {
    public static final int MINLEFTSPACE = 20;
    public static final int MINRIGHTSPACE = 20;
    public static final int MINTOPSPACE = 20;
    public static final int MINBOTTOMSPACE = 20;
    private GraphicalEditPart owner;
    private Rectangle initSize = new Rectangle();
    private Rectangle comsiteBounds = new Rectangle();
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractPageFlowLayout(final GraphicalEditPart owner) {
        if (!$assertionsDisabled && owner == null) {
            throw new AssertionError();
        }
        this.owner = owner;
        final ControlListener listener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                AbstractPageFlowLayout.this.setComsiteBounds(new Rectangle(AbstractPageFlowLayout.this.getOwner().getViewer().getControl().getBounds()));
                AbstractPageFlowLayout.this.layouRootLayer();
            }
        };
        owner.getViewer().getControl().addControlListener(listener);
        owner.addEditPartListener(new EditPartListener(){

            public void childAdded(EditPart child, int index) {
            }

            public void partActivated(EditPart editpart) {
            }

            public void partDeactivated(EditPart editpart) {
                owner.getViewer().getControl().removeControlListener(listener);
            }

            public void removingChild(EditPart child, int index) {
            }

            public void selectedStateChanged(EditPart editpart) {
            }
        });
        this.getZoomManager().addZoomListener(new ZoomListener(){

            public void zoomChanged(double zoom) {
                if (AbstractPageFlowLayout.this.getOwner().getParent() == null) {
                    return;
                }
                AbstractPageFlowLayout.this.setComsiteBounds(new Rectangle(AbstractPageFlowLayout.this.getOwner().getViewer().getControl().getBounds()));
                AbstractPageFlowLayout.this.layouRootLayer();
            }
        });
    }

    private void layouRootLayer() {
        if (this.getOwner().getFigure() instanceof ReportElementFigure) {
            ((ReportElementFigure)this.getOwner().getFigure()).fireMoved();
        }
    }

    protected GraphicalEditPart getOwner() {
        return this.owner;
    }

    protected void setOwner(GraphicalEditPart owner) {
        this.owner = owner;
    }

    public ZoomManager getZoomManager() {
        return (ZoomManager)this.owner.getViewer().getProperty(ZoomManager.class.toString());
    }

    public Rectangle getComsiteBounds() {
        return this.comsiteBounds;
    }

    public void setComsiteBounds(Rectangle comsiteBounds) {
        this.comsiteBounds = comsiteBounds;
        this.layout(this.getOwner().getFigure());
    }

    public Rectangle getInitSize() {
        return this.initSize;
    }

    public void setInitSize(Rectangle initSize) {
        this.initSize = initSize;
    }

    protected void setViewProperty(Rectangle caleBounds, Rectangle ownerBounds) {
        this.getOwner().getViewer().setProperty("Report Size", (Object)caleBounds);
        this.getOwner().getViewer().setProperty("Layout Size", (Object)ownerBounds);
    }

    protected Result getReportBounds(Rectangle reportSize) {
        Result revValue = new Result();
        revValue.reportSize.y = 20;
        revValue.reportSize.width = reportSize.width;
        revValue.reportSize.height = reportSize.height;
        PrecisionDimension dim = new PrecisionDimension((double)this.getComsiteBounds().width, (double)this.getComsiteBounds().height);
        double scale = this.getZoomManager().getZoom();
        dim.performScale(1.0 / scale);
        if (dim.width > reportSize.width + 20 + 20) {
            revValue.reportSize.x = (dim.width - reportSize.width) / 2;
            revValue.rightSpace = (dim.width - reportSize.width) / 2;
        } else {
            revValue.reportSize.x = 20;
            revValue.rightSpace = 20;
        }
        revValue.bottomSpace = dim.height > reportSize.height + 20 + 20 ? dim.height - reportSize.height - revValue.reportSize.y : 20;
        return revValue;
    }

    static {
        $assertionsDisabled = !AbstractPageFlowLayout.class.desiredAssertionStatus();
    }

    protected static class Result {
        public Rectangle reportSize = new Rectangle();
        public int rightSpace;
        public int bottomSpace;

        protected Result() {
        }
    }
}

