/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.layout;

import org.eclipse.birt.report.designer.internal.ui.layout.TableLayoutData;
import org.eclipse.birt.report.designer.internal.ui.layout.TableLayoutDataProvider;
import org.eclipse.birt.report.designer.util.ITableLayoutCalculator;

public class TableLayoutHelper {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void calculateColumnWidth(TableLayoutData.ColumnData[] columnWidths, final int containerWidth, ITableLayoutCalculator calculator) {
        int size = columnWidths.length;
        final int[] hintWidth = calculator.getIntColWidth();
        final int[] minWidth = new int[size];
        final int[] maxWidth = new int[size];
        for (int i = 0; i < size; ++i) {
            TableLayoutData.ColumnData colData = columnWidths[i];
            minWidth[i] = colData.minColumnWidth;
            maxWidth[i] = Math.max(containerWidth, minWidth[i]);
        }
        int[] width = TableLayoutHelper.refineColumnWidth(new TableLayoutDataProvider(){

            public int getAvailableWidth() {
                return containerWidth;
            }

            public int[] getHintColumnWidth() {
                return hintWidth;
            }

            public int[] getMaxColumnWidth() {
                return maxWidth;
            }

            public int[] getMinColumnWidth() {
                return minWidth;
            }
        });
        for (int i = 0; i < size; ++i) {
            TableLayoutData.ColumnData colData = columnWidths[i];
            colData.width = width[i];
        }
    }

    public static int[] refineColumnWidth(TableLayoutDataProvider provider) {
        int[] hintWidth;
        block14: {
            int totalHintWidth;
            int size;
            int availableWidth;
            int[] minWidth;
            block15: {
                hintWidth = provider.getHintColumnWidth();
                minWidth = provider.getMinColumnWidth();
                int[] maxWidth = provider.getMaxColumnWidth();
                availableWidth = provider.getAvailableWidth();
                if (!$assertionsDisabled && hintWidth.length != minWidth.length) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && minWidth.length != maxWidth.length) {
                    throw new AssertionError();
                }
                TableLayoutHelper.checkValid(hintWidth, minWidth);
                TableLayoutHelper.checkValid(maxWidth, minWidth);
                size = hintWidth.length;
                totalHintWidth = TableLayoutHelper.getSum(hintWidth);
                int totalMinWidth = TableLayoutHelper.getSum(minWidth);
                int totalMaxWidth = TableLayoutHelper.getSum(maxWidth);
                if (totalMinWidth >= availableWidth) {
                    for (int i = 0; i < size; ++i) {
                        hintWidth[i] = Math.max(minWidth[i], hintWidth[i]);
                    }
                    return hintWidth;
                }
                if (totalMaxWidth <= availableWidth) {
                    for (int i = 0; i < size; ++i) {
                        hintWidth[i] = maxWidth[i];
                    }
                    return hintWidth;
                }
                if (totalMaxWidth <= availableWidth || totalMinWidth >= availableWidth) break block14;
                if (totalHintWidth >= (availableWidth = Math.max(totalMinWidth, availableWidth))) break block15;
                int T = availableWidth - totalHintWidth;
                int delta = 0;
                for (int i = 0; i < size; ++i) {
                    int n;
                    int xdelta = T * hintWidth[i] / totalHintWidth;
                    hintWidth[i] = n = hintWidth[i] + xdelta;
                    delta += xdelta;
                }
                if (delta >= T) break block14;
                int xx = T - delta;
                while (xx > 0) {
                    int i = 0;
                    while (i < size && xx > 0) {
                        int n = i++;
                        hintWidth[n] = hintWidth[n] + 1;
                        --xx;
                    }
                }
                break block14;
            }
            if (totalHintWidth > availableWidth) {
                int T = totalHintWidth - availableWidth;
                int delta = 0;
                for (int i = 0; i < size; ++i) {
                    int xdelta = T * hintWidth[i] / totalHintWidth;
                    int n = Math.max(hintWidth[i] - xdelta, minWidth[i]);
                    delta += hintWidth[i] - n;
                    hintWidth[i] = n;
                }
                if (delta < T) {
                    int xx = T - delta;
                    while (xx > 0) {
                        for (int i = 0; i < size && xx > 0; ++i) {
                            if (hintWidth[i] <= minWidth[i]) continue;
                            int n = i;
                            hintWidth[n] = hintWidth[n] - 1;
                            --xx;
                        }
                    }
                }
            }
        }
        return hintWidth;
    }

    private static void checkValid(int[] width, int[] minWidth) {
        for (int i = 0; i < width.length; ++i) {
            if (width[i] >= minWidth[i]) continue;
            width[i] = minWidth[i];
        }
    }

    private static int getSum(int[] width) {
        int rt = 0;
        for (int i = 0; i < width.length; ++i) {
            rt += width[i];
        }
        return rt;
    }

    static {
        $assertionsDisabled = !TableLayoutHelper.class.desiredAssertionStatus();
    }
}

