/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.palette;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.views.data.DataSetItemModel;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.AbstractToolHandleExtends;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.LibraryElementsToolHandleExtends;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.ReportCreationTool;
import org.eclipse.birt.report.designer.internal.ui.palette.BasePaletteFactory;
import org.eclipse.birt.report.designer.internal.ui.palette.ReportElementFactory;
import org.eclipse.birt.report.designer.internal.ui.views.actions.InsertInLayoutAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.dnd.DropTargetEvent;

public class ReportTemplateTransferDropTargetListener
extends TemplateTransferDropTargetListener {
    private static final String TRANS_LABEL_CREATE_ELEMENT = Messages.getString((String)"ReportTemplateTransferDropTargetListener.transLabel.createElement");

    public ReportTemplateTransferDropTargetListener(EditPartViewer viewer) {
        super(viewer);
    }

    protected CreationFactory getFactory(Object template) {
        if (this.handleValidateDrag(template)) {
            if (template instanceof String) {
                return new ReportElementFactory(template);
            }
            return new ReportElementFactory(this.getSingleTransferData(template), template);
        }
        return null;
    }

    protected void handleDrop() {
        Object template = TemplateTransfer.getInstance().getTemplate();
        Assert.isNotNull((Object)template);
        Assert.isTrue((boolean)this.handleValidateDrag(template));
        this.updateTargetRequest();
        this.updateTargetEditPart();
        AbstractToolHandleExtends preHandle = null;
        String transName = null;
        if (template instanceof String) {
            transName = TRANS_LABEL_CREATE_ELEMENT;
            preHandle = BasePaletteFactory.getAbstractToolHandleExtendsFromPaletteName(template);
        } else if (this.handleValidateInsert(template)) {
            transName = InsertInLayoutAction.DISPLAY_TEXT;
            Object objectType = this.getFactory(template).getObjectType();
            if (objectType instanceof DataSetHandle) {
                preHandle = new BasePaletteFactory.DataSetToolExtends();
            } else if (objectType instanceof DataSetItemModel || objectType instanceof ResultSetColumnHandle) {
                preHandle = new BasePaletteFactory.DataSetColumnToolExtends();
            } else if (objectType instanceof ScalarParameterHandle) {
                preHandle = new BasePaletteFactory.ParameterToolExtends();
            }
        } else if (this.handleValidateLibrary(template)) {
            preHandle = new LibraryElementsToolHandleExtends((DesignElementHandle)this.getSingleTransferData(template));
        }
        if (preHandle != null) {
            Object[] objs;
            SessionHandleAdapter.getInstance().getReportDesignHandle().getCommandStack().startTrans(transName);
            preHandle.setRequest(this.getCreateRequest());
            preHandle.setTargetEditPart(this.getTargetEditPart());
            Command command = this.getCommand();
            if (command != null && command.canExecute() && !preHandle.preHandleMouseUp()) {
                SessionHandleAdapter.getInstance().getReportDesignHandle().getCommandStack().rollback();
                return;
            }
            boolean isTheme = false;
            if (preHandle instanceof LibraryElementsToolHandleExtends && template instanceof Object[] && (objs = (Object[])template).length == 1 && objs[0] instanceof ThemeHandle) {
                isTheme = true;
            }
            if (!isTheme) {
                super.handleDrop();
                if (!preHandle.postHandleCreation()) {
                    SessionHandleAdapter.getInstance().getReportDesignHandle().getCommandStack().rollback();
                    return;
                }
            }
            SessionHandleAdapter.getInstance().getReportDesignHandle().getCommandStack().commit();
            if (!isTheme) {
                this.selectAddedObject();
            }
        }
    }

    private boolean handleValidateDrag(Object dragObj) {
        return dragObj != null && (this.handleValidatePalette(dragObj) || this.handleValidateOutline(dragObj) || this.handleValidateInsert(dragObj) || this.handleValidateLibrary(dragObj));
    }

    private boolean handleValidatePalette(Object dragObj) {
        return dragObj instanceof String && (this.getTargetEditPart() == null || ReportCreationTool.handleValidatePalette(dragObj, this.getTargetEditPart()));
    }

    private boolean handleValidateInsert(Object template) {
        return InsertInLayoutUtil.handleValidateInsert(template) && (this.getTargetEditPart() == null || InsertInLayoutUtil.handleValidateInsertToLayout(template, this.getTargetEditPart()));
    }

    private boolean handleValidateOutline(Object dragSource) {
        return false;
    }

    private boolean handleValidateLibrary(Object dragObj) {
        EditPart targetEditPart = this.getTargetEditPart();
        if (targetEditPart == null) {
            return true;
        }
        if (dragObj != null) {
            Object[] dragObjs = dragObj instanceof Object[] ? (Object[])dragObj : new Object[]{dragObj};
            if (dragObjs.length == 0) {
                return false;
            }
            for (int i = 0; i < dragObjs.length; ++i) {
                dragObj = dragObjs[i];
                if (dragObj instanceof ReportElementHandle) {
                    if (((ReportElementHandle)dragObj).getRoot() instanceof LibraryHandle) {
                        if (dragObj instanceof DataSetHandle || dragObj instanceof ParameterHandle) {
                            return true;
                        }
                        if (DNDUtil.handleValidateTargetCanContain((Object)targetEditPart.getModel(), (Object)dragObj) && DNDUtil.handleValidateTargetCanContainMore((Object)targetEditPart.getModel(), (int)1)) continue;
                        return false;
                    }
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void dragOver(DropTargetEvent event) {
        super.dragOver(event);
        if (!this.handleValidateDrag(TemplateTransfer.getInstance().getTemplate())) {
            event.detail = 0;
        }
    }

    private void selectAddedObject() {
        Object model = this.getCreateRequest().getExtendedData().get("newObject");
        EditPartViewer viewer = this.getViewer();
        viewer.getControl().setFocus();
        ReportCreationTool.selectAddedObject(model, viewer);
    }

    private Object getSingleTransferData(Object template) {
        if (template instanceof Object[]) {
            return ((Object[])template)[0];
        }
        return template;
    }
}

