/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.designer.core.commands.DeleteCommand;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DeleteWarningDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractElementAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class DeleteAction
extends AbstractElementAction {
    public static final String CONFIRM_PARAM_DELETE_TITLE = Messages.getString((String)"DefaultNodeProvider.ParameterGroup.ConfirmTitle");
    public static final String CONFIRM_PARAM_DELETE_MESSAGE = Messages.getString((String)"DefaultNodeProvider.ParameterGroup.ConfirmMessage");
    public static final String DLG_CONFIRM_MSG = Messages.getString((String)"DefaultNodeProvider.Dlg.Confirm");
    public static final String DLG_HAS_FOLLOWING_CLIENTS_MSG = Messages.getString((String)"DefaultNodeProvider.Tree.Clients");
    public static final String DLG_REFERENCE_FOUND_TITLE = Messages.getString((String)"DefaultNodeProvider.Tree.Reference");
    private static final String DEFAULT_TEXT = Messages.getString((String)"DeleteAction.text");
    private boolean hasExecuted = false;

    public DeleteAction(Object selectedObject) {
        this(selectedObject, DEFAULT_TEXT);
    }

    public DeleteAction(Object selectedObject, String text) {
        super(selectedObject, text);
        ISharedImages shareImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(shareImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(shareImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setAccelerator(127);
    }

    protected boolean doAction() throws Exception {
        this.hasExecuted = this.isOKPressed(this.getSelection());
        if (this.hasExecuted()) {
            this.createDeleteCommand(this.getSelection()).execute();
        }
        return this.hasExecuted();
    }

    public boolean isEnabled() {
        Command cmd = this.createDeleteCommand(this.getSelection());
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    protected boolean isOKPressed(Object model) {
        if (model instanceof IStructuredSelection) {
            Iterator itor = ((IStructuredSelection)model).iterator();
            while (itor.hasNext()) {
                Object obj = itor.next();
                if (this.isOKPressed(obj)) continue;
                return false;
            }
            return true;
        }
        if (model instanceof DesignElementHandle) {
            DesignElementHandle handle = (DesignElementHandle)model;
            if (handle instanceof ParameterGroupHandle && ((ParameterGroupHandle)handle).getParameters().getCount() > 0) {
                if (!MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)CONFIRM_PARAM_DELETE_TITLE, (String)CONFIRM_PARAM_DELETE_MESSAGE)) {
                    return false;
                }
                Iterator iter = ((ParameterGroupHandle)handle).getParameters().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof ParameterHandle)) continue;
                    ParameterHandle parameter = (ParameterHandle)obj;
                    ConfigVariable cv = parameter.getModuleHandle().findConfigVariable(parameter.getName());
                    try {
                        if (cv == null) continue;
                        parameter.getModuleHandle().getPropertyHandle("configVars").removeItem((IStructure)cv);
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                    }
                }
            }
            ArrayList referenceList = new ArrayList();
            Iterator itor = handle.clientsIterator();
            while (itor.hasNext()) {
                referenceList.add(itor.next());
            }
            if (!referenceList.isEmpty()) {
                DeleteWarningDialog dialog = new DeleteWarningDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), DLG_REFERENCE_FOUND_TITLE, referenceList);
                dialog.setPreString(DEUtil.getDisplayLabel((Object)handle) + DLG_HAS_FOLLOWING_CLIENTS_MSG);
                dialog.setSufString(DLG_CONFIRM_MSG);
                return dialog.open() != 1;
            }
            return true;
        }
        return true;
    }

    protected String getTransactionLabel() {
        if (this.getSelection() instanceof IStructuredSelection) {
            return Messages.getString((String)"DeleteAction.trans");
        }
        return DEFAULT_TEXT + " " + DEUtil.getDisplayLabel((Object)this.getSelection());
    }

    protected Command createDeleteCommand(Object objects) {
        return new DeleteCommand(objects);
    }

    public boolean hasExecuted() {
        return this.hasExecuted;
    }
}

