/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ImportLibraryAction
extends Action {
    public static final String ID = "UseLibraryAction";
    public static final String ACTION_TEXT = Messages.getString((String)"UseLibraryAction.Text");

    public ImportLibraryAction() {
        this.setText(ACTION_TEXT);
    }

    public boolean isEnabled() {
        return true;
    }

    public void run() {
        String filename;
        FileDialog dialog = new FileDialog(UIUtil.getDefaultShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.rptlibrary"});
        try {
            filename = dialog.open();
        }
        catch (Throwable e) {
            return;
        }
        if (filename != null) {
            if (!new File(filename).exists()) {
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"AddLibraryAction.Error.Title"), Messages.getFormattedString((String)"AddLibraryAction.Error.FileNotFound", (Object[])new String[]{filename}));
                return;
            }
            if (!filename.endsWith(".rptlibrary")) {
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"AddLibraryAction.Error.Title"), Messages.getFormattedString((String)"AddLibraryAction.Error.FileIsNotLibrary", (Object[])new String[]{filename, ".rptlibrary"}));
                return;
            }
            try {
                filename = this.copyToResourceFolder(filename);
                if (filename != null) {
                    ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
                    UIUtil.includeLibrary(moduleHandle, filename);
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    private String copyToResourceFolder(String filename) throws IOException {
        File orgFile = new File(filename);
        File resourceFolder = new File(ReportPlugin.getDefault().getResourcePreference());
        if (resourceFolder.exists()) {
            File targetFile = new File(resourceFolder, orgFile.getName());
            if (targetFile.exists()) {
                if (targetFile.getAbsolutePath().equals(orgFile.getAbsolutePath())) {
                    return orgFile.getAbsolutePath();
                }
                if (MessageDialog.openConfirm((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"UseLibraryAction.Error.Title"), (String)Messages.getFormattedString((String)"UseLibraryAction.Error.Message", (Object[])new String[]{targetFile.getName()}))) {
                    this.coypFile(orgFile, targetFile);
                }
            }
            return targetFile.getAbsolutePath();
        }
        return null;
    }

    private void coypFile(File org, File dest) throws IOException {
        if (dest.exists() || dest.createNewFile()) {
            FileInputStream in = new FileInputStream(org);
            FileOutputStream out = new FileOutputStream(dest);
            byte[] bytes = new byte[64];
            int length = 0;
            while ((length = in.read(bytes)) != -1) {
                out.write(bytes, 0, length);
            }
            in.close();
            out.close();
        }
    }
}

