/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import java.util.Iterator;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class RefreshModuleHandleAction
extends AbstractViewAction {
    public static final String ID = "org.eclipse.birt.report.designer.internal.ui.views.actions.RefreshModuleHandleAction";
    public static final String ACTION_TEXT = Messages.getString((String)"RefreshModuleHandleAction.Action.Text");

    public RefreshModuleHandleAction(Object selectedObject) {
        super(selectedObject, ACTION_TEXT);
    }

    public RefreshModuleHandleAction(Object selectedObject, String text) {
        super(selectedObject, text);
    }

    public boolean isEnabled() {
        return this.getSelection() instanceof ReportDesignHandle || this.getSelection() instanceof LibraryHandle;
    }

    public void run() {
        Object obj = this.getSelection();
        if (obj instanceof ReportDesignHandle || obj instanceof LibraryHandle) {
            ModuleHandle moduleHandle = (ModuleHandle)obj;
            Iterator iter = moduleHandle.getLibraries().iterator();
            while (iter.hasNext()) {
                LibraryHandle library = (LibraryHandle)iter.next();
                try {
                    moduleHandle.reloadLibrary(library);
                }
                catch (SemanticException e) {
                }
                catch (DesignFileException e) {}
            }
        }
    }
}

