/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.PreviewLabel;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.LayoutTable;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.MapHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.MapRuleBuilder;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MapRuleHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;

public class MapPage
extends AttributePage {
    private TableViewer fTableViewer;
    private Button fAddButton;
    private Button fDeleteButton;
    private Button fMoveUpButton;
    private Button fMoveDownButton;
    private PreviewLabel previewLabel;
    private MapHandleProvider provider = new MapHandleProvider();

    public MapPage(Composite parent, int style) {
        super(parent, style);
    }

    protected void buildUI() {
        GridLayout layout = UIUtil.createGridLayoutWithoutMargin(2, false);
        layout.horizontalSpacing = 10;
        this.setLayout((Layout)layout);
        Composite buttons = new Composite((Composite)this, 0);
        GridData data = new GridData(768);
        buttons.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 5;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        Label lb = new Label(buttons, 0);
        lb.setText(Messages.getString((String)"MapPage.label.mapList"));
        lb.setLayoutData((Object)new GridData(800));
        this.fAddButton = new Button(buttons, 2048);
        this.fAddButton.setText(Messages.getString((String)"MapPage.label.add"));
        data = new GridData(128);
        data.widthHint = Math.max(60, this.fAddButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.fAddButton.setLayoutData((Object)data);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapPage.this.add();
            }
        });
        this.fDeleteButton = new Button(buttons, 2048);
        this.fDeleteButton.setText(Messages.getString((String)"MapPage.label.delete"));
        data = new GridData(128);
        data.widthHint = Math.max(60, this.fDeleteButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.fDeleteButton.setLayoutData((Object)data);
        this.fDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapPage.this.delete();
            }
        });
        this.fMoveUpButton = new Button(buttons, 2048);
        this.fMoveUpButton.setText(Messages.getString((String)"FormPage.Button.Up"));
        this.fMoveUpButton.setToolTipText(Messages.getString((String)"MapPage.toolTipText.moveUp"));
        data = new GridData(128);
        data.widthHint = Math.max(60, this.fMoveUpButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.fMoveUpButton.setLayoutData((Object)data);
        this.fMoveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapPage.this.moveUp();
            }
        });
        this.fMoveDownButton = new Button(buttons, 2048);
        this.fMoveDownButton.setText(Messages.getString((String)"FormPage.Button.Down"));
        this.fMoveDownButton.setToolTipText(Messages.getString((String)"MapPage.toolTipText.moveDown"));
        data = new GridData(128);
        data.widthHint = Math.max(60, this.fMoveDownButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.fMoveDownButton.setLayoutData((Object)data);
        this.fMoveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapPage.this.moveDown();
            }
        });
        new Label((Composite)this, 0).setText(Messages.getString((String)"MapPage.label.displayValue"));
        LayoutTable table = new LayoutTable(this, new LayoutTable.ColumnsDescription(new String[]{Messages.getString((String)"MapPage.label.condition")}, true), 67584);
        table.setLayoutData(new GridData(1808));
        this.fTableViewer = new TableViewer(table.getTable());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new MapLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new MapContentProvider());
        this.fTableViewer.setSorter(null);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MapPage.this.updateButtons();
                MapPage.this.refreshTableItemView();
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MapPage.this.edit();
            }
        });
        this.fTableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    MapPage.this.delete();
                }
            }
        });
        this.previewLabel = new PreviewLabel(this, 2048);
        this.previewLabel.setText("");
        this.previewLabel.setLayoutData(new GridData(1808));
        this.updateButtons();
    }

    private void enableUI(boolean enabled) {
        if (this.fTableViewer != null) {
            this.fAddButton.setEnabled(enabled);
            this.fDeleteButton.setEnabled(enabled);
            this.fMoveUpButton.setEnabled(enabled);
            this.fMoveDownButton.setEnabled(enabled);
            this.fTableViewer.getTable().setEnabled(enabled);
            if (enabled) {
                this.updateButtons();
            }
        }
    }

    public void setInput(List elements) {
        if (elements.size() != 1) {
            this.enableUI(false);
            return;
        }
        this.enableUI(true);
        super.setInput(elements);
        this.fTableViewer.setInput((Object)elements);
        this.refreshTableItemView();
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (this.fTableViewer.getContentProvider() == null) {
            return;
        }
        if (this.fTableViewer != null) {
            this.fTableViewer.setInput((Object)this.input);
            this.refreshTableItemView();
        }
    }

    private void updateButtons() {
        this.fDeleteButton.setEnabled(this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount());
        this.fMoveUpButton.setEnabled(this.fTableViewer.getTable().getSelectionIndex() > 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount());
        this.fMoveDownButton.setEnabled(this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount() - 1);
    }

    private void refreshTableItemView() {
        for (int i = 0; i < this.fTableViewer.getTable().getItemCount(); ++i) {
            TableItem ti = this.fTableViewer.getTable().getItem(i);
            MapRuleHandle handle = (MapRuleHandle)ti.getData();
            ti.setText(0, this.provider.getColumnText(handle, 1));
        }
        if (this.fTableViewer.getTable().getSelectionIndex() >= 0) {
            this.updatePreview((MapRuleHandle)this.fTableViewer.getTable().getItem(this.fTableViewer.getTable().getSelectionIndex()).getData());
        } else {
            this.updatePreview(null);
        }
    }

    private void updatePreview(MapRuleHandle mrhandle) {
        if (mrhandle != null) {
            this.previewLabel.setText(mrhandle.getDisplay());
            this.previewLabel.updateView();
        } else {
            this.previewLabel.restoreDefaultState();
            this.previewLabel.setForeground(ColorManager.getColor((int)-1));
            this.previewLabel.setBackground(ColorManager.getColor((int)-1));
            this.previewLabel.setText("");
            this.previewLabel.updateView();
        }
    }

    private void add() {
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        try {
            stack.startTrans(Messages.getString((String)"MapPage.transName.addMapRule"));
            MapRuleBuilder builder = new MapRuleBuilder(this.getShell(), MapRuleBuilder.DLG_TITLE_NEW, this.provider);
            builder.updateHandle(null, this.fTableViewer.getTable().getItemCount());
            builder.setDesignHandle(this.provider.getDesignElementHandle());
            if (builder.open() == 0) {
                int itemCount = this.fTableViewer.getTable().getItemCount();
                this.fTableViewer.getTable().deselectAll();
                this.fTableViewer.getTable().select(itemCount - 1);
                this.fTableViewer.getTable().setFocus();
                this.updateButtons();
                this.refreshTableItemView();
            }
            stack.commit();
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionHandler.handle(e);
        }
    }

    private void edit() {
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        try {
            stack.startTrans(Messages.getString((String)"MapPage.transName.editMapRule"));
            if (this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount()) {
                MapRuleBuilder builder = new MapRuleBuilder(this.getShell(), MapRuleBuilder.DLG_TITLE_EDIT, this.provider);
                MapRuleHandle handle = (MapRuleHandle)this.fTableViewer.getTable().getItem(this.fTableViewer.getTable().getSelectionIndex()).getData();
                builder.updateHandle(handle, this.fTableViewer.getTable().getItemCount());
                builder.setDesignHandle(this.provider.getDesignElementHandle());
                int idx = this.fTableViewer.getTable().getSelectionIndex();
                if (builder.open() == 0) {
                    this.fTableViewer.getTable().select(idx);
                    this.fTableViewer.getTable().setFocus();
                    this.updateButtons();
                    this.refreshTableItemView();
                }
            }
            stack.commit();
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionHandler.handle(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete() {
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        try {
            stack.startTrans(Messages.getString((String)"MapPage.transName.deleteMapRule"));
            if (this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount()) {
                int idx = this.fTableViewer.getTable().getSelectionIndex();
                this.provider.doDeleteItem(idx);
                if (idx >= this.fTableViewer.getTable().getItemCount()) {
                    --idx;
                }
                this.fTableViewer.getTable().select(idx);
                this.fTableViewer.getTable().setFocus();
                this.updateButtons();
                this.refreshTableItemView();
            }
            stack.commit();
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionHandler.handle(e);
        }
        finally {
            this.updateButtons();
            this.refreshTableItemView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveUp() {
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        try {
            stack.startTrans(Messages.getString((String)"MapPage.transName.moveUpMapRule"));
            int index = this.fTableViewer.getTable().getSelectionIndex();
            this.provider.doSwapItem(index, -1);
            this.fTableViewer.getTable().select(index - 1);
            this.fTableViewer.getTable().setFocus();
            stack.commit();
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionHandler.handle(e);
        }
        finally {
            this.updateButtons();
            this.refreshTableItemView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveDown() {
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        try {
            stack.startTrans(Messages.getString((String)"MapPage.transName.moveDownRule"));
            int index = this.fTableViewer.getTable().getSelectionIndex();
            this.provider.doSwapItem(index, 1);
            this.fTableViewer.getTable().select(index + 1);
            this.fTableViewer.getTable().setFocus();
            stack.commit();
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionHandler.handle(e);
        }
        finally {
            this.updateButtons();
            this.refreshTableItemView();
        }
    }

    class MapContentProvider
    implements IStructuredContentProvider {
        MapContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = MapPage.this.provider.getElements(inputElement);
            for (int i = 0; i < elements.length; ++i) {
                if (!(elements[i] instanceof DesignElementHandle)) continue;
                DesignElementHandle element = (DesignElementHandle)elements[i];
                element.removeListener((Listener)MapPage.this);
                element.addListener((Listener)MapPage.this);
            }
            return elements;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
            Object[] elements = MapPage.this.provider.getElements(MapPage.this.input);
            for (int i = 0; i < elements.length; ++i) {
                if (!(elements[i] instanceof DesignElementHandle)) continue;
                DesignElementHandle element = (DesignElementHandle)elements[i];
                element.removeListener((Listener)MapPage.this);
            }
        }
    }

    class MapLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        MapLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return MapPage.this.provider.getColumnText(element, 1);
        }
    }
}

