/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IFormHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ComboBoxCellEditor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ComboBoxExpressionCellEditor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ExpressionValueCellEditor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.FilterModelProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class FilterHandleProvider
implements IFormHandleProvider {
    private List input;
    private String[] columnKeys = new String[]{"expr", "operator", "value1", "value2"};
    private static int[] columnWidth = new int[]{200, 200, 200, 200};
    private FilterModelProvider modelAdapter = new FilterModelProvider();
    private String[] columnNames;
    private CellEditor[] editors;
    private List columnList = new ArrayList();
    private Table table;
    private ParamBindingHandle[] bindingParams = null;

    private void getDataSetColumns(Object obj) {
        if (obj instanceof DesignElementHandle) {
            this.columnList = new ArrayList();
            String[] columns = this.modelAdapter.getChoiceSet(obj, "expr");
            if (columns != null) {
                this.columnList.addAll(Arrays.asList(columns));
            }
            this.setProviderAndBinding(obj);
        }
    }

    public void setBindingParams(ParamBindingHandle[] params) {
        this.bindingParams = params;
    }

    public String[] getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = this.modelAdapter.getColumnNames(this.columnKeys);
        }
        return this.columnNames;
    }

    public String getTitle() {
        return Messages.getString((String)"FilterHandleProvider.Label.Filterby");
    }

    public CellEditor[] getEditors(Table table) {
        if (this.editors == null) {
            this.editors = new CellEditor[this.columnKeys.length];
            this.editors[0] = new ComboBoxExpressionCellEditor((Composite)table);
            this.editors[1] = new ComboBoxCellEditor((Composite)table, new String[0], 8);
            this.editors[2] = new ExpressionValueCellEditor((Composite)table);
            this.editors[3] = new ExpressionValueCellEditor((Composite)table);
        }
        this.table = table;
        return this.editors;
    }

    public boolean doMoveItem(int oldPos, int newPos) throws PropertyValueException {
        return this.modelAdapter.moveItem(this.input.get(0), oldPos, newPos);
    }

    public boolean doDeleteItem(int pos) throws PropertyValueException {
        return this.modelAdapter.deleteItem(this.input.get(0), pos);
    }

    public boolean doAddItem(int pos) throws SemanticException {
        return this.modelAdapter.doAddItem(this.input.get(0), pos);
    }

    public boolean doEditItem(int pos) {
        return true;
    }

    public String getColumnText(Object element, int columnIndex) {
        String key = this.columnKeys[columnIndex];
        return this.modelAdapter.getText(element, key);
    }

    public String getImagePath(Object element, int columnIndex) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            this.input = (List)inputElement;
        } else {
            this.input = new ArrayList();
            this.input.add(inputElement);
        }
        this.getDataSetColumns(this.input.get(0));
        ((ComboBoxExpressionCellEditor)this.editors[0]).setItems(this.columnList.toArray(new String[this.columnList.size()]));
        ((ComboBoxCellEditor)this.editors[1]).setItems(this.modelAdapter.getChoiceSet(this.input.get(0), this.columnKeys[1]));
        Object[] elements = this.modelAdapter.getElements(this.input);
        return elements;
    }

    private void setProviderAndBinding(Object obj) {
        ComboBoxExpressionCellEditor editor = (ComboBoxExpressionCellEditor)this.editors[0];
        ExpressionProvider provider = new ExpressionProvider((DesignElementHandle)obj);
        editor.setExpressionProvider(provider);
        for (int i = 2; i <= 3; ++i) {
            ExpressionValueCellEditor valEditor = (ExpressionValueCellEditor)this.editors[i];
            valEditor.setExpressionProvider(provider);
            valEditor.setBindingParams(this.bindingParams);
            if (obj instanceof ReportItemHandle) {
                valEditor.setReportElement((ReportElementHandle)((ReportItemHandle)obj));
                continue;
            }
            if (!(obj instanceof GroupHandle)) continue;
            valEditor.setReportElement((ReportElementHandle)((ReportItemHandle)((GroupHandle)obj).getContainer()));
        }
    }

    public boolean canModify(Object element, String property) {
        if (property.equals(this.columnNames[2])) {
            int index = this.table.getSelectionIndex();
            if (index == -1) {
                return false;
            }
            String text = this.table.getItems()[index].getText(1);
            if (this.getDisplayName("operator", "is-null").equals(text) || this.getDisplayName("operator", "is-not-null").equals(text) || this.getDisplayName("operator", "is-true").equals(text) || this.getDisplayName("operator", "is-false").equals(text)) {
                return false;
            }
        } else if (property.equals(this.columnNames[3])) {
            int index = this.table.getSelectionIndex();
            if (index == -1) {
                return false;
            }
            String text = this.table.getItems()[index].getText(1);
            if (!this.getDisplayName("operator", "between").equals(text) && !this.getDisplayName("operator", "not-between").equals(text)) {
                return false;
            }
        }
        if (property.equals(this.columnNames[2]) || property.equals(this.columnNames[3])) {
            this.updateValueCellEditor(this.getColumnText(element, 0));
        }
        return true;
    }

    public Object getValue(Object element, String property) {
        int index = Arrays.asList(this.columnNames).indexOf(property);
        String columnText = this.getColumnText(element, index);
        return columnText;
    }

    public boolean modify(Object data, String property, Object value) throws NameException, SemanticException {
        if (property.equals(this.modelAdapter.getColumnNames(this.columnKeys)[1]) && !value.equals(this.getDisplayName("operator", "between")) && !value.equals(this.getDisplayName("operator", "not-between"))) {
            this.modelAdapter.setStringValue(this.input.get(0), data, "value2", "");
        }
        int index = Arrays.asList(this.columnNames).indexOf(property);
        String key = this.columnKeys[index];
        String strValue = "";
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            if (intValue == -1) {
                CCombo combo = (CCombo)this.editors[index].getControl();
                strValue = combo.getText();
            } else {
                String[] choices = this.modelAdapter.getChoiceSet(this.input.get(0), this.columnKeys[index]);
                strValue = choices[intValue];
            }
        } else {
            strValue = (String)value;
        }
        return this.modelAdapter.setStringValue(this.input.get(0), data, key, strValue);
    }

    private void updateValueCellEditor(String exp) {
        String bindingName = null;
        Iterator iter = this.columnList.iterator();
        while (iter.hasNext()) {
            String columnName = (String)iter.next();
            if (!DEUtil.getColumnExpression((String)columnName).equals(exp)) continue;
            bindingName = columnName;
            break;
        }
        ((ExpressionValueCellEditor)this.editors[2]).setBindingName(bindingName);
        ((ExpressionValueCellEditor)this.editors[3]).setBindingName(bindingName);
    }

    public int[] getColumnWidths() {
        return columnWidth;
    }

    public boolean needRefreshed(NotificationEvent event) {
        if (event instanceof PropertyEvent) {
            String propertyName = ((PropertyEvent)event).getPropertyName();
            if ("boundDataColumns".equals(propertyName)) {
                this.getDataSetColumns(this.input.get(0));
                ((ComboBoxExpressionCellEditor)this.editors[0]).setItems(this.columnList.toArray(new String[this.columnList.size()]));
            }
            if ("filter".equals(propertyName)) {
                return true;
            }
            if ("paramBindings".equals(propertyName)) {
                return true;
            }
        }
        return false;
    }

    private Object getDisplayName(String key, String value) {
        IChoiceSet choiceSet = ChoiceSetFactory.getStructChoiceSet("FilterCondition", key);
        IChoice choice = choiceSet.findChoice(value);
        if (choice != null) {
            return choice.getDisplayName();
        }
        return null;
    }
}

