/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ExpressionFilter;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.CCombo;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ComboBoxExpressionCellEditor
extends DialogCellEditor {
    private CCombo comboBox;
    private String[] items;
    int selection;
    protected static final int defaultStyle = 0;
    private Composite composite;
    private Button btnPopup;
    private IExpressionProvider provider;

    public ComboBoxExpressionCellEditor(Composite parent) {
        super(parent);
        this.setStyle(0);
    }

    public ComboBoxExpressionCellEditor(Composite parent, String[] items) {
        this(parent, items, 0);
    }

    public ComboBoxExpressionCellEditor(Composite parent, String[] items, int style) {
        super(parent, style);
        this.setItems(items);
    }

    public String[] getItems() {
        return this.items;
    }

    public void setItems(String[] items) {
        Assert.isNotNull((Object)items);
        this.items = items;
        this.populateComboBoxItems();
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            this.comboBox.removeAll();
            for (int i = 0; i < this.items.length; ++i) {
                this.comboBox.add(this.items[i], i);
            }
            this.setValueValid(true);
            this.selection = 0;
        }
    }

    protected Control createContents(Composite cell) {
        Color bg = cell.getBackground();
        this.composite = new Composite(cell, this.getStyle());
        this.composite.setBackground(bg);
        this.composite.setLayout((Layout)new FillLayout());
        this.comboBox = new CCombo(this.composite, 0);
        this.comboBox.setBackground(bg);
        this.comboBox.setFont(cell.getFont());
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String newValue = ComboBoxExpressionCellEditor.this.comboBox.getText();
                if (newValue != null) {
                    boolean newValidState = ComboBoxExpressionCellEditor.this.isCorrect(newValue);
                    if (newValidState) {
                        ComboBoxExpressionCellEditor.this.markDirty();
                        ComboBoxExpressionCellEditor.this.doSetValue(newValue);
                    } else {
                        ComboBoxExpressionCellEditor.this.setErrorMessage(MessageFormat.format(ComboBoxExpressionCellEditor.this.getErrorMessage(), newValue.toString()));
                    }
                    ComboBoxExpressionCellEditor.this.fireApplyEditorValue();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                String newValue = ComboBoxExpressionCellEditor.this.comboBox.getText();
                if (newValue != null) {
                    boolean newValidState = ComboBoxExpressionCellEditor.this.isCorrect(newValue);
                    if (newValidState) {
                        ComboBoxExpressionCellEditor.this.markDirty();
                        ComboBoxExpressionCellEditor.this.doSetValue(newValue);
                    } else {
                        ComboBoxExpressionCellEditor.this.setErrorMessage(MessageFormat.format(ComboBoxExpressionCellEditor.this.getErrorMessage(), newValue.toString()));
                    }
                    ComboBoxExpressionCellEditor.this.fireApplyEditorValue();
                }
            }
        });
        this.comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (ComboBoxExpressionCellEditor.this.btnPopup != null && !ComboBoxExpressionCellEditor.this.btnPopup.isFocusControl() && Display.getCurrent().getCursorControl() != ComboBoxExpressionCellEditor.this.btnPopup) {
                    ComboBoxExpressionCellEditor.this.applyEditorValueAndDeactivate();
                    super.focusLost(e);
                }
            }
        });
        return this.composite;
    }

    void applyEditorValueAndDeactivate() {
        this.selection = this.comboBox.getSelectionIndex();
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.items[this.selection]));
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), this.comboBox.getText());
        dialog.setExpressionProvier(this.provider);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        this.setFocus();
        return null;
    }

    protected void updateContents(Object value) {
        if (this.comboBox == null) {
            return;
        }
        String text = "";
        if (value != null) {
            text = value.toString();
        }
        this.comboBox.setText(text);
    }

    public void setEnable(boolean flag) {
        this.comboBox.setEnabled(flag);
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    protected Object doGetValue() {
        int selection = this.comboBox.getSelectionIndex();
        if (selection == -1) {
            return this.comboBox.getText();
        }
        return this.comboBox.getItem(selection);
    }

    protected Button createButton(Composite parent) {
        this.btnPopup = super.createButton(parent);
        return this.btnPopup;
    }

    public void setExpressionProvider(IExpressionProvider provider) {
        this.provider = provider;
    }

    public void addFilter(ExpressionFilter filter) {
    }

    public void setDataSetList(List list) {
    }
}

