/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.CheckPropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ColorPropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ComboPropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ExpressionPropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FontSizePropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.MarignPropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ResourceKeyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.SimpleComboPropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.SpinnerPropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.TextAlignPropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.TextPropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.TogglePropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.UnitPropertyDescriptor;
import org.eclipse.birt.report.designer.ui.views.attributes.IPropertyDescriptor;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;

public class PropertyDescriptorFactory {
    private static List textConstants;
    private static List marginConstants;
    private static List multiTextConstants;
    private static List unitConstants;
    private static List comboConstants;
    private static List spinnerConstants;
    private static List checkConstants;
    private static List colorConstants;
    private static List simpleComboConstants;
    private static List fontSizeConstants;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static IPropertyDescriptor getPropertyDescriptor(String elementName, String property) {
        if (!$assertionsDisabled && property == null) {
            throw new AssertionError();
        }
        PropertyProcessor processor = new PropertyProcessor(elementName, property);
        if (fontSizeConstants.contains(property)) {
            return new FontSizePropertyDescriptor(processor);
        }
        if (simpleComboConstants.contains(property)) {
            return new SimpleComboPropertyDescriptor(processor);
        }
        if (textConstants.contains(property)) {
            TextPropertyDescriptor desc = new TextPropertyDescriptor(processor);
            if ("createdBy".equals(property) || "dataSource".equals(property) || "controlType".equals(property) || "dataType".equals(property)) {
                desc.setStyle(2056);
            }
            return desc;
        }
        if (marginConstants.contains(property)) {
            return new MarignPropertyDescriptor(processor);
        }
        if (multiTextConstants.contains(property)) {
            TextPropertyDescriptor descriptor = new TextPropertyDescriptor(processor);
            descriptor.setStyle(2882);
            return descriptor;
        }
        if (unitConstants.contains(property)) {
            return new UnitPropertyDescriptor(processor);
        }
        if (colorConstants.contains(property)) {
            return new ColorPropertyDescriptor(processor);
        }
        if (spinnerConstants.contains(property)) {
            return new SpinnerPropertyDescriptor(processor);
        }
        if (checkConstants.contains(property)) {
            return new CheckPropertyDescriptor(processor);
        }
        if (comboConstants.contains(property)) {
            if (property.equals("GUI_HORIZONTAL_ALIGN")) {
                processor = new PropertyProcessor(elementName, "textAlign");
            }
            return new ComboPropertyDescriptor(processor);
        }
        if (property.equals("fontWeight")) {
            TogglePropertyDescriptor descriptor = new TogglePropertyDescriptor(processor);
            descriptor.setAllowedValues("normal", "bold");
            return descriptor;
        }
        if (property.equals("fontStyle")) {
            TogglePropertyDescriptor descriptor = new TogglePropertyDescriptor(processor);
            descriptor.setAllowedValues("normal", "italic");
            return descriptor;
        }
        if (property.equals("textUnderline")) {
            TogglePropertyDescriptor descriptor = new TogglePropertyDescriptor(processor);
            descriptor.setAllowedValues("none", "underline");
            return descriptor;
        }
        if (property.equals("textLineThrough")) {
            TogglePropertyDescriptor descriptor = new TogglePropertyDescriptor(processor);
            descriptor.setAllowedValues("none", "line-through");
            return descriptor;
        }
        if (property.equals("borderLeftStyle")) {
            TogglePropertyDescriptor descriptor = new TogglePropertyDescriptor(processor);
            return descriptor;
        }
        if (property.equals("textAlign")) {
            TextAlignPropertyDescriptor descriptor = new TextAlignPropertyDescriptor(processor);
            return descriptor;
        }
        if (property.equals("contentID") || property.equals("textID") || property.equals("promptTextID")) {
            return new ResourceKeyDescriptor(processor);
        }
        if ("bookmark".equals(property) || "toc".equals(property) || "valueExpr".equals(property)) {
            return new ExpressionPropertyDescriptor(processor);
        }
        if (property.equals("includeResource")) {
            return new TextPropertyDescriptor(processor);
        }
        if (property.equals("style") || property.equals("theme") || property.equals("masterPage")) {
            SimpleComboPropertyDescriptor descriptor = new SimpleComboPropertyDescriptor(processor);
            return descriptor;
        }
        return null;
    }

    static {
        $assertionsDisabled = !PropertyDescriptorFactory.class.desiredAssertionStatus();
        textConstants = Arrays.asList("name", "author", "createdBy", "title", "eventHandlerClass", "displayName", "iconFile", "colSpan", "rowSpan", "pageBreakInterval", "dataSource", "dataType", "controlType");
        marginConstants = Arrays.asList("marginTop", "marginLeft", "marginBottom", "marginRight");
        multiTextConstants = Arrays.asList("description", "comments", "altText");
        unitConstants = Arrays.asList("height", "width", "paddingTop", "paddingBottom", "paddingLeft", "paddingRight", "width", "height", "width", "height", "headerHeight", "footerHeight");
        comboConstants = Arrays.asList("fontFamily", "fontSize", "contentType", "verticalAlign", "GUI_HORIZONTAL_ALIGN", "orientation", "type", "pageBreakBefore", "pageBreakAfter", "pageBreakInside", "units", "dateTimeFormat", "numberFormat", "stringFormat", "drop");
        spinnerConstants = Arrays.asList("leftMargin", "rightMargin", "topMargin", "bottomMargin");
        checkConstants = Arrays.asList("showHeaderOnFirst", "showFooterOnLast", "floatingFooter", "canShrink", "suppressDuplicates");
        colorConstants = Arrays.asList("backgroundColor", "color");
        simpleComboConstants = Arrays.asList("dataSet", "masterPage");
        fontSizeConstants = Arrays.asList("fontSize");
    }
}

