/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.AbstractPropertyDescriptor;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.metadata.PredefinedStyle;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SimpleComboPropertyDescriptor
extends AbstractPropertyDescriptor {
    protected Combo combo;
    private String oldValue;
    private int style = 2048;

    public SimpleComboPropertyDescriptor(PropertyProcessor propertyProcessor) {
        super(propertyProcessor);
    }

    public Control getControl() {
        return this.combo;
    }

    public Control createControl(Composite parent) {
        this.combo = new Combo(parent, this.style);
        this.combo.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                SimpleComboPropertyDescriptor.this.combo.clearSelection();
            }

            public void controlResized(ControlEvent e) {
                SimpleComboPropertyDescriptor.this.combo.clearSelection();
            }
        });
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SimpleComboPropertyDescriptor.this.processAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SimpleComboPropertyDescriptor.this.processAction();
            }
        });
        return this.combo;
    }

    private void processAction() {
        String newValue = this.combo.getText();
        if (ChoiceSetFactory.CHOICE_NONE.equals(newValue)) {
            newValue = null;
        }
        try {
            this.getPropertyProcessor().setStringValue(newValue, this.getModelList());
        }
        catch (SemanticException e) {
            WidgetUtil.processError(this.combo.getShell(), (Exception)((Object)e));
            this.combo.setText(this.oldValue);
            this.combo.setSelection(new Point(0, this.oldValue.length()));
        }
    }

    private String[] filterPreStyles(String[] items) {
        List preStyles = DesignEngine.getMetaDataDictionary().getPredefinedStyles();
        ArrayList<String> preStyleNames = new ArrayList<String>();
        for (int i = 0; i < preStyles.size(); ++i) {
            preStyleNames.add(((PredefinedStyle)preStyles.get(i)).getName());
        }
        ArrayList<String> sytleNames = new ArrayList<String>();
        for (int i = 0; i < items.length; ++i) {
            if (preStyleNames.indexOf(items[i]) != -1) continue;
            sytleNames.add(items[i]);
        }
        return sytleNames.toArray(new String[0]);
    }

    public void resetUIData() {
        boolean stateFlag;
        String property = this.getPropertyProcessor().getProperty();
        String[] items = null;
        if ("dataSet".equals(property)) {
            items = ChoiceSetFactory.getDataSets();
        } else if ("masterPage".equals(property)) {
            items = ChoiceSetFactory.getMasterPages();
        } else if ("style".equals(property)) {
            items = ChoiceSetFactory.getStyles();
            items = this.filterPreStyles(items);
        } else if ("theme".equals(property)) {
            items = ChoiceSetFactory.getThemes();
        }
        this.combo.setItems(items);
        this.oldValue = this.getPropertyProcessor().getStringValue(this.getModelList());
        boolean bl = stateFlag = this.oldValue == null == this.combo.getEnabled();
        if (stateFlag) {
            this.combo.setEnabled(this.oldValue != null);
        }
        if (this.getPropertyProcessor().isReadOnly(this.getModelList())) {
            this.combo.setEnabled(false);
        }
        int sindex = Arrays.asList(items).indexOf(this.oldValue);
        if (("style".equals(property) || "theme".equals(property) || "masterPage".equals(property)) && sindex < 0) {
            if (this.oldValue != null && this.oldValue.length() > 0) {
                this.combo.setText(this.oldValue);
                return;
            }
            if (this.combo.getItemCount() > 0) {
                this.combo.select(0);
                return;
            }
        }
        this.combo.select(sindex);
    }

    public int getStyle() {
        return this.style;
    }

    public void addStyle(int style) {
        this.style |= style;
    }
}

