/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.data;

import org.eclipse.birt.report.designer.core.model.views.data.DataSetItemModel;
import org.eclipse.birt.report.designer.core.model.views.outline.ReportElementModel;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.RenameListener;
import org.eclipse.birt.report.designer.internal.ui.views.ViewContextMenuProvider;
import org.eclipse.birt.report.designer.internal.ui.views.ViewsTreeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.GlobalActionFactory;
import org.eclipse.birt.report.designer.internal.ui.views.data.DataViewPage;
import org.eclipse.birt.report.designer.internal.ui.views.outline.ItemSorter;
import org.eclipse.birt.report.designer.internal.ui.views.outline.ListenerElementVisitor;
import org.eclipse.birt.report.designer.internal.ui.views.outline.dnd.DesignerDragListener;
import org.eclipse.birt.report.designer.internal.ui.views.outline.dnd.DesignerDropListener;
import org.eclipse.birt.report.designer.internal.ui.views.outline.dnd.IDropConstraint;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.data.DataView;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.NameEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.api.validators.ValidationEvent;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class DataViewTreeViewerPage
extends DataViewPage
implements Listener,
IValidationListener {
    private static final String LABEL_DOUBLE_CLICK = Messages.getString((String)"DataViewTreeViewerPage.tooltip.DoubleClickToEdit");
    private ModuleHandle reportHandle;
    private ListenerElementVisitor visitor;

    public DataViewTreeViewerPage(ModuleHandle reportHandle) {
        this.reportHandle = reportHandle;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent, 770);
        return treeViewer;
    }

    protected void initPage() {
        this.createContextMenus();
        this.handleGlobalAction();
        new RenameListener(this.getTreeViewer()).apply();
        this.getTreeViewer().setSorter((ViewerSorter)new ItemSorter());
        this.getTreeViewer().getTree().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                Widget widget = event.widget;
                if (widget == DataViewTreeViewerPage.this.getTreeViewer().getTree()) {
                    Point pt = new Point(event.x, event.y);
                    TreeItem item = DataViewTreeViewerPage.this.getTreeViewer().getTree().getItem(pt);
                    DataViewTreeViewerPage.this.getTreeViewer().getTree().setToolTipText(DataViewTreeViewerPage.this.getTooltip(item));
                }
            }
        });
    }

    private String getTooltip(TreeItem item) {
        if (item != null) {
            Object object = item.getData();
            if (object instanceof DataSourceHandle || object instanceof ParameterGroupHandle) {
                return LABEL_DOUBLE_CLICK;
            }
            StringBuffer tooltip = new StringBuffer();
            boolean canInsert = InsertInLayoutUtil.handleValidateInsertToLayout(object, UIUtil.getCurrentEditPart());
            String text = "(" + item.getText() + ")";
            if (object instanceof DataSetHandle) {
                if (canInsert) {
                    tooltip.append(Messages.getString((String)"DataViewTreeViewerPage.tooltip.DragToInsertDataSetColumns") + text + "; ");
                }
                tooltip.append(LABEL_DOUBLE_CLICK);
            }
            if ((object instanceof DataSetItemModel || object instanceof ResultSetColumnHandle) && canInsert) {
                tooltip.append(Messages.getString((String)"DataViewTreeViewerPage.tooltip.DragToInsertColumn") + text);
            }
            if (object instanceof ParameterHandle) {
                if (canInsert) {
                    tooltip.append(Messages.getString((String)"DataViewTreeViewerPage.tooltip.DragToInsertParameter"));
                }
                tooltip.append(LABEL_DOUBLE_CLICK);
            }
            return tooltip.toString();
        }
        return "";
    }

    private void createContextMenus() {
        ViewContextMenuProvider menuManager = new ViewContextMenuProvider((ISelectionProvider)this.getTreeViewer());
        Menu menu = menuManager.createContextMenu(this.getTreeViewer().getControl());
        this.getTreeViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu("#Pop up", (MenuManager)menuManager, this.getSite().getSelectionProvider());
    }

    protected void configTreeViewer() {
        ViewsTreeProvider provider = new ViewsTreeProvider();
        this.getTreeViewer().setContentProvider((IContentProvider)provider);
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)provider);
        this.initRoot();
        int ops = 3;
        Transfer[] transfers = new Transfer[]{TemplateTransfer.getInstance()};
        this.getTreeViewer().addDragSupport(ops, transfers, (DragSourceListener)new DesignerDragListener((StructuredViewer)this.getTreeViewer()));
        transfers = new Transfer[]{TemplateTransfer.getInstance()};
        ops = 3;
        DesignerDropListener dropListener = new DesignerDropListener(this.getTreeViewer());
        dropListener.addDropConstraint(CascadingParameterGroupHandle.class, new IDropConstraint(){

            public int validate(Object transfer, Object target) {
                return -1;
            }
        });
        dropListener.addDropConstraint(ScalarParameterHandle.class, new IDropConstraint(){

            public int validate(Object transfer, Object target) {
                ScalarParameterHandle targetParameter;
                if (target instanceof ScalarParameterHandle && (targetParameter = (ScalarParameterHandle)target).getContainer() instanceof CascadingParameterGroupHandle) {
                    return -1;
                }
                return 0;
            }
        });
        IDropConstraint cascadingParameterGroupChildrenConstraint = new IDropConstraint(){

            public int validate(Object transfer, Object target) {
                ScalarParameterHandle transferParameter;
                if (transfer instanceof Object[] && ((Object[])transfer).length > 0 && ((Object[])transfer)[0] instanceof ScalarParameterHandle && (transferParameter = (ScalarParameterHandle)((Object[])transfer)[0]).getContainer() instanceof CascadingParameterGroupHandle) {
                    return -1;
                }
                return 0;
            }
        };
        dropListener.addDropConstraint(ScalarParameterHandle.class, cascadingParameterGroupChildrenConstraint);
        dropListener.addDropConstraint(ParameterGroupHandle.class, cascadingParameterGroupChildrenConstraint);
        dropListener.addDropConstraint(ReportElementModel.class, cascadingParameterGroupChildrenConstraint);
        this.getTreeViewer().addDropSupport(ops, transfers, (DropTargetListener)dropListener);
    }

    private void initRoot() {
        ReportElementModel sources = new ReportElementModel(this.getRoot().getDataSources());
        ReportElementModel sets = new ReportElementModel(this.getRoot().getDataSets());
        ReportElementModel parameters = new ReportElementModel(this.getRoot().getParameters());
        this.getTreeViewer().setInput((Object)new Object[]{sources, sets, parameters});
        this.getListenerElementVisitor().addListener((DesignElementHandle)this.getRoot());
    }

    public ModuleHandle getRoot() {
        return this.reportHandle;
    }

    public void dispose() {
        if (this.visitor != null) {
            this.visitor.removeListener((DesignElementHandle)this.getRoot());
            this.visitor.dispose();
            this.visitor = null;
        }
        super.dispose();
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (this.getTreeViewer() == null || this.getTreeViewer().getControl().isDisposed()) {
            return;
        }
        this.getTreeViewer().refresh();
        this.expandNodeAfterCreation(ev);
        this.deleteConfigVariable(focus, ev);
        this.getListenerElementVisitor().addListener(focus);
    }

    private ListenerElementVisitor getListenerElementVisitor() {
        if (this.visitor == null) {
            this.visitor = new ListenerElementVisitor(this);
        }
        return this.visitor;
    }

    private void deleteConfigVariable(DesignElementHandle handle, NotificationEvent ev) {
        String variableName = null;
        if (ev instanceof ContentEvent && handle instanceof ModuleHandle) {
            ContentEvent event = (ContentEvent)ev;
            DesignElementHandle contentHandle = event.getContent().getHandle(this.getRoot().getModule());
            if (event.getAction() == 2 && contentHandle instanceof ParameterHandle) {
                variableName = contentHandle.getName();
            }
        } else if (ev instanceof NameEvent && handle instanceof ParameterHandle) {
            variableName = ((NameEvent)ev).getOldName();
        } else if (ev instanceof PropertyEvent && handle instanceof ParameterHandle) {
            variableName = handle.getName();
        }
        if (variableName != null) {
            ConfigVariable cv = this.getRoot().findConfigVariable(variableName);
            try {
                if (cv != null) {
                    this.getRoot().getPropertyHandle("configVars").removeItem((IStructure)cv);
                }
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    private void expandNodeAfterCreation(NotificationEvent ev) {
        IDesignElement element;
        if (ev instanceof ContentEvent && ev.getEventType() == 0 && ((ContentEvent)ev).getAction() == 1 && (element = ((ContentEvent)ev).getContent()) != null) {
            DesignElementHandle handle = element.getHandle(this.getRoot().getModule());
            this.getTreeViewer().expandToLevel((Object)handle, -1);
            if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart() instanceof DataView) {
                this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)handle), true);
            }
        }
    }

    protected boolean isDisposed() {
        Control ctrl = this.getControl();
        return ctrl == null || ctrl.isDisposed();
    }

    private void handleGlobalAction() {
        String id;
        int i;
        for (i = 0; i < GlobalActionFactory.GLOBAL_SELECTION_ACTIONS.length; ++i) {
            id = GlobalActionFactory.GLOBAL_SELECTION_ACTIONS[i];
            this.getSite().getActionBars().setGlobalActionHandler(id, GlobalActionFactory.createSelectionAction(id, this));
        }
        for (i = 0; i < GlobalActionFactory.GLOBAL_DATA_ACTIONS.length; ++i) {
            id = GlobalActionFactory.GLOBAL_DATA_ACTIONS[i];
            this.getSite().getActionBars().setGlobalActionHandler(id, GlobalActionFactory.createSelectionAction(id, this));
        }
        for (i = 0; i < GlobalActionFactory.GLOBAL_PARAMETER_ACTIONS.length; ++i) {
            id = GlobalActionFactory.GLOBAL_PARAMETER_ACTIONS[i];
            this.getSite().getActionBars().setGlobalActionHandler(id, GlobalActionFactory.createSelectionAction(id, this));
        }
        for (i = 0; i < GlobalActionFactory.GLOBAL_STACK_ACTIONS.length; ++i) {
            id = GlobalActionFactory.GLOBAL_STACK_ACTIONS[i];
            this.getSite().getActionBars().setGlobalActionHandler(id, GlobalActionFactory.createStackAction(id, this.getRoot().getCommandStack()));
        }
    }

    public void elementValidated(DesignElementHandle targetElement, ValidationEvent ev) {
        this.getTreeViewer().refresh();
    }
}

