/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignVisitor;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.validators.IValidationListener;

public class ListenerElementVisitor
extends DesignVisitor {
    private Listener listener;
    private boolean install = true;

    public ListenerElementVisitor(Listener listener) {
        this.listener = listener;
    }

    public void addListener(DesignElementHandle handle) {
        this.install = true;
        this.apply(handle);
    }

    public void removeListener(DesignElementHandle handle) {
        this.install = false;
        this.apply(handle);
    }

    public void visitDesignElement(DesignElementHandle obj) {
        if (this.install) {
            obj.addListener(this.listener);
        } else {
            obj.removeListener(this.listener);
        }
        for (int i = 0; i < obj.getDefn().getSlotCount(); ++i) {
            this.visitContents(obj.getSlot(i));
        }
    }

    protected void visitModule(ModuleHandle obj) {
        if (this.listener instanceof IValidationListener) {
            IValidationListener vl = (IValidationListener)this.listener;
            if (this.install) {
                obj.addValidationListener(vl);
            } else {
                obj.removeValidationListener(vl);
            }
        }
        super.visitModule(obj);
    }

    public void dispose() {
        this.listener = null;
    }
}

