/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline.providers;

import java.util.Map;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.core.model.views.outline.ReportElementModel;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.InsertAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;

public class TableBandProvider
extends DefaultNodeProvider {
    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        if (!(object instanceof ReportElementModel)) {
            return;
        }
        ReportElementModel model = (ReportElementModel)object;
        if (((ReportElementHandle)model.getElementHandle()).isValidReferenceForCompoundElement()) {
            if (model.getElementHandle() instanceof TableHandle && model.getSlotId() == 1) {
                InsertAction insertAction = new InsertAction(object, Messages.getString((String)"TableBandProvider.action.text.group"), "TableGroup");
                menu.add((IAction)insertAction);
            } else {
                menu.add((IAction)new InsertAction(object, Messages.getString((String)"TableBandProvider.action.text.row"), "Row"));
            }
        }
        super.createContextMenu(sourceViewer, object, menu);
    }

    public String getNodeDisplayName(Object object) {
        ReportElementModel model = (ReportElementModel)object;
        if (model.getElementHandle() instanceof TableHandle) {
            switch (model.getSlotId()) {
                case 0: {
                    return HEADER_DISPALYNAME;
                }
                case 3: {
                    return FOOTER_DISPALYNAME;
                }
                case 2: {
                    return DETAIL_DISPALYNAME;
                }
                case 1: {
                    return GROUPS_DISPALYNAME;
                }
            }
        } else if (model.getElementHandle() instanceof TableGroupHandle) {
            switch (model.getSlotId()) {
                case 0: {
                    return HEADER_DISPALYNAME;
                }
                case 1: {
                    return FOOTER_DISPALYNAME;
                }
            }
        }
        return super.getNodeDisplayName(model);
    }

    public String getIconName(Object object) {
        ReportElementModel model = (ReportElementModel)object;
        if (model.getElementHandle() instanceof TableHandle) {
            switch (model.getSlotId()) {
                case 0: {
                    return "Header";
                }
                case 3: {
                    return "Footer";
                }
                case 2: {
                    return "Details";
                }
                case 1: {
                    return "Groups";
                }
            }
        } else if (model.getElementHandle() instanceof TableGroupHandle) {
            switch (model.getSlotId()) {
                case 0: {
                    return "Group Header";
                }
                case 1: {
                    return "Group Footer";
                }
            }
        }
        return super.getIconName(model);
    }

    protected boolean performInsert(Object model, SlotHandle slotHandle, String type, String position, Map extendData) throws Exception {
        if ("Row".equals(type)) {
            TableHandleAdapter adapter = HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getRoot(((ReportElementModel)model).getElementHandle()));
            if (slotHandle.getCount() > 0) {
                int rowNumber = HandleAdapterFactory.getInstance().getRowHandleAdapter((Object)slotHandle.get(slotHandle.getCount() - 1)).getRowNumber();
                adapter.insertRow(1, rowNumber);
            } else {
                slotHandle.add(this.createElement(slotHandle, "Row"));
            }
            return true;
        }
        if ("TableGroup".equals(type)) {
            return UIUtil.createGroup(((ReportElementModel)model).getElementHandle());
        }
        return super.performInsert(model, slotHandle, type, position, extendData);
    }

    protected DesignElementHandle createElement(SlotHandle slotHandle, String type) throws Exception {
        DesignElementHandle handle = (DesignElementHandle)this.getRoot(slotHandle.getElementHandle());
        if (type.equals("Row")) {
            return DesignElementFactory.getInstance(handle.getModuleHandle()).newTableRow(((TableHandle)handle).getColumnCount());
        }
        return super.createElement(slotHandle, type);
    }

    private Object getRoot(Object model) {
        if (model instanceof TableHandle) {
            return model;
        }
        DesignElementHandle handle = ((DesignElementHandle)model).getContainer();
        if (handle instanceof GroupHandle) {
            return this.getRoot(handle);
        }
        return handle;
    }
}

