/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.property.widgets;

import java.util.Arrays;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.CCombo;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.CDialogCellEditor;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ComboBoxColorCellEditor
extends CDialogCellEditor {
    private CCombo comboBox;
    private String[] items;
    int selection;
    private static final int defaultStyle = 0;
    private Composite composite;
    private int inProcessing = 0;

    public ComboBoxColorCellEditor(Composite parent) {
        super(parent);
        this.setStyle(0);
    }

    public ComboBoxColorCellEditor(Composite parent, String[] items) {
        this(parent, items, 0);
    }

    public ComboBoxColorCellEditor(Composite parent, String[] items, int style) {
        super(parent, style);
        if (items != null) {
            Arrays.sort(items);
        }
        this.setItems(items);
    }

    public String[] getItems() {
        return this.items;
    }

    public void setItems(String[] items) {
        Assert.isNotNull((Object)items);
        this.items = items;
        this.populateComboBoxItems();
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            this.comboBox.removeAll();
            for (int i = 0; i < this.items.length; ++i) {
                this.comboBox.add(this.items[i], i);
            }
            this.setValueValid(true);
            this.selection = 0;
        }
    }

    protected Control createContents(Composite cell) {
        Color bg = cell.getBackground();
        this.composite = new Composite(cell, this.getStyle());
        this.composite.setBackground(bg);
        this.composite.setLayout((Layout)new FillLayout());
        this.comboBox = new CCombo(this.composite, 0);
        this.comboBox.setBackground(bg);
        this.comboBox.setFont(cell.getFont());
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                ComboBoxColorCellEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent event) {
                ComboBoxColorCellEditor.this.applyEditorValueAndDeactivate();
            }
        });
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ComboBoxColorCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ComboBoxColorCellEditor.this.focusLost();
            }
        });
        return this.composite;
    }

    void applyEditorValueAndDeactivate() {
        this.inProcessing = 1;
        this.doValueChanged();
        this.fireApplyEditorValue();
        this.deactivate();
        this.inProcessing = 0;
    }

    protected void doValueChanged() {
        boolean newValidState;
        if (this.selection != this.comboBox.getSelectionIndex()) {
            this.markDirty();
        }
        this.selection = this.comboBox.getSelectionIndex();
        String newValue = null;
        newValue = this.selection == -1 ? this.comboBox.getText() : this.comboBox.getItem(this.selection);
        if (newValue != null && (newValidState = this.isCorrect(newValue))) {
            this.doSetValue(newValue);
            this.markDirty();
        }
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        ColorDialog dialog = new ColorDialog(cellEditorWindow.getShell());
        Object value = this.getValue();
        try {
            int color = value instanceof String ? ColorUtil.parseColor((String)((String)value)) : (Integer)value;
            dialog.setRGB(DEUtil.getRGBValue((int)color));
        }
        catch (Exception e) {
            // empty catch block
        }
        value = dialog.open();
        if (value != null && dialog.getRGB() != null) {
            this.deactivate();
            return ColorUtil.format((int)ColorUtil.formRGB((int)dialog.getRGB().red, (int)dialog.getRGB().green, (int)dialog.getRGB().blue), (int)1);
        }
        this.comboBox.setFocus();
        return value;
    }

    protected void updateContents(Object value) {
        if (this.comboBox == null) {
            return;
        }
        String text = "";
        if (value != null) {
            text = value instanceof RGB ? "0x" + Integer.toHexString(DEUtil.getRGBInt((RGB)((RGB)value))) : value.toString();
        }
        this.comboBox.setText(text);
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        } else if (keyEvent.character == '\r') {
            this.applyEditorValueAndDeactivate();
        }
    }

    protected void focusLost() {
        if (this.inProcessing == 1) {
            return;
        }
        super.focusLost();
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }
}

