/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.property.widgets;

import java.util.Arrays;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.CDialogCellEditor;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.DimensionBuilderDialog;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class DimensionCellEditor
extends CDialogCellEditor {
    private String[] units;
    private String unitName;
    private Text defaultLabel;
    private int style;
    private int inProcessing = 0;

    public DimensionCellEditor(Composite parent, String[] unitNames) {
        super(parent);
        this.units = unitNames;
    }

    public DimensionCellEditor(Composite parent, String[] unitNames, int style) {
        super(parent, style);
        this.units = unitNames;
        this.style = style;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        DimensionValue value;
        DimensionBuilderDialog dialog = new DimensionBuilderDialog(cellEditorWindow.getShell());
        try {
            value = DimensionValue.parse((String)((String)this.getValue()));
        }
        catch (PropertyValueException e) {
            value = null;
        }
        dialog.setUnitNames(this.units);
        dialog.setUnitData(Arrays.asList(this.units).indexOf(this.unitName));
        if (value != null) {
            dialog.setMeasureData(new Double(value.getMeasure()));
        }
        this.inProcessing = 1;
        if (dialog.open() == 0) {
            this.deactivate();
            this.inProcessing = 0;
            return dialog.getMeasureData().toString() + dialog.getUnitName();
        }
        this.getDefaultText().setFocus();
        this.getDefaultText().selectAll();
        this.inProcessing = 0;
        return null;
    }

    public void setUnits(String units) {
        this.unitName = units;
    }

    protected void doSetFocus() {
        this.getDefaultText().setFocus();
        this.getDefaultText().selectAll();
    }

    protected void doValueChanged() {
        if (this.doGetValue() != this.defaultLabel.getText()) {
            this.markDirty();
            this.doSetValue(this.defaultLabel.getText());
        }
    }

    protected Control createContents(Composite cell) {
        this.defaultLabel = new Text(cell, 0x4000 | this.style);
        this.defaultLabel.setFont(cell.getFont());
        this.defaultLabel.setBackground(cell.getBackground());
        this.defaultLabel.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                DimensionCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.defaultLabel.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.defaultLabel.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DimensionCellEditor.this.focusLost();
            }
        });
        return this.defaultLabel;
    }

    protected void updateContents(Object value) {
        if (this.defaultLabel == null) {
            return;
        }
        String text = "";
        if (value != null) {
            text = value.toString();
        }
        this.defaultLabel.setText(text);
    }

    protected Text getDefaultText() {
        return this.defaultLabel;
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        } else if (keyEvent.character == '\r') {
            this.applyEditorValueAndDeactivate();
        }
    }

    private void applyEditorValueAndDeactivate() {
        this.inProcessing = 1;
        this.doValueChanged();
        this.fireApplyEditorValue();
        this.deactivate();
        this.inProcessing = 0;
    }

    protected void focusLost() {
        if (this.inProcessing == 1) {
            return;
        }
        super.focusLost();
    }
}

