/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.property.widgets;

import com.ibm.icu.util.Calendar;
import java.util.ArrayList;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.TimeTable;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.TimeTableColumn;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.TimeTableCursor;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.TimeTableItem;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SpinnerTable
extends Composite {
    private Table table = null;
    private TableCursor cursor = null;
    private final int DAY_WEEK_COUNT = 7;
    private final int ROW_COUNT = 7;
    private Calendar cale = null;
    private ArrayList listenerList = new ArrayList();
    private static final String SUN = Messages.getString((String)"Commom.ShortDateTime.Sun");
    private static final String MON = Messages.getString((String)"Commom.ShortDateTime.Mon");
    private static final String TUE = Messages.getString((String)"Commom.ShortDateTime.Tue");
    private static final String WED = Messages.getString((String)"Commom.ShortDateTime.Wed");
    private static final String THU = Messages.getString((String)"Commom.ShortDateTime.Thu");
    private static final String FRI = Messages.getString((String)"Commom.ShortDateTime.Fri");
    private static final String SAT = Messages.getString((String)"Commom.ShortDateTime.Sat");

    public void setCalendar(Calendar calendar) {
        this.cale = (Calendar)calendar.clone();
        Calendar tempcalendar = this.getOriCalendar(calendar);
        int dayCount = tempcalendar.getActualMaximum(5);
        int moreDayCount = tempcalendar.get(7) - 1;
        for (int i = 0; i < 7; ++i) {
            TableItem item = this.table.getItem(i);
            if (i == 0) continue;
            String[] values = new String[7];
            for (int j = 0; j < 7; ++j) {
                int index = (i - 1) * 7 + j;
                int dayIndex = index - moreDayCount + 1;
                values[j] = index < moreDayCount || dayIndex > dayCount ? "" : String.valueOf(dayIndex);
            }
            item.setText(values);
        }
        TableColumn[] cols = this.table.getColumns();
        int size = cols.length;
        for (int i = 0; i < size; ++i) {
            cols[i].pack();
        }
        this.table.pack();
        this.setOriValue();
    }

    public SpinnerTable(Composite composite, int style) {
        this(composite, style, Calendar.getInstance());
    }

    public SpinnerTable(Composite composite, int style, Calendar calendar) {
        super(composite, style);
        this.table = new TimeTable(this, 0x8000 | style | 0x800);
        this.createColumn(this.table);
        this.cursor = new TimeTableCursor(this.table, 0);
        this.cursor.setBackground(Display.getCurrent().getSystemColor(9));
        this.cursor.setForeground(Display.getCurrent().getSystemColor(1));
        this.cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem row = SpinnerTable.this.cursor.getRow();
                String value = row.getText(SpinnerTable.this.cursor.getColumn());
                int strValue = 0;
                try {
                    strValue = Integer.parseInt(value);
                }
                catch (Exception ee) {
                    SpinnerTable.this.setOriValue();
                    return;
                }
                int oldValue = SpinnerTable.this.cale.get(5);
                SpinnerTable.this.cale.set(5, strValue);
                SpinnerTable.this.firePropertyListener(new PropertyChangeEvent(new Object(), "daychange", (Object)new Integer(oldValue), (Object)new Integer(strValue)));
            }
        });
        this.createItems();
        this.setCalendar(calendar);
    }

    private void createColumn(Table table) {
        new TimeTableColumn(table, 0);
        new TimeTableColumn(table, 0);
        new TimeTableColumn(table, 0);
        new TimeTableColumn(table, 0);
        new TimeTableColumn(table, 0);
        new TimeTableColumn(table, 0);
        new TimeTableColumn(table, 0);
    }

    private Calendar getOriCalendar(Calendar calendar) {
        Calendar retValue = (Calendar)calendar.clone();
        retValue.set(5, 1);
        return retValue;
    }

    private void setOriValue() {
        Calendar tempcalendar = this.getOriCalendar(this.cale);
        int moreDayCount = tempcalendar.get(7) - 1;
        int selectDay = this.cale.get(5) + moreDayCount + 7;
        int week = selectDay - selectDay / 7 * 7 - 1;
        int row = selectDay / 7;
        if (week == -1) {
            week = 6;
            --row;
        }
        this.cursor.setSelection(row, week);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.remove(listener);
    }

    protected void checkWidget() {
    }

    public void firePropertyListener(PropertyChangeEvent e) {
        int size = this.listenerList.size();
        for (int i = 0; i < size; ++i) {
            IPropertyChangeListener listener = (IPropertyChangeListener)this.listenerList.get(i);
            listener.propertyChange(e);
        }
    }

    private void createItems() {
        for (int i = 0; i < 7; ++i) {
            TimeTableItem item = new TimeTableItem(this.table, 0);
            if (i != 0) continue;
            item.setText(new String[]{SUN, MON, TUE, WED, THU, FRI, SAT});
            item.setBackground(Display.getCurrent().getSystemColor(9));
            item.setForeground(Display.getCurrent().getSystemColor(1));
        }
    }

    public int getDay() {
        return this.cale.get(5);
    }
}

