/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.wizards;

import java.io.File;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ExportReportWizardPage
extends WizardPage
implements Listener {
    private static String LABEL_FILE_NAME = Messages.getString((String)"ExportToLibraryAction.wizard.page.label.filename");
    private static String LABEL_FOLDER = Messages.getString((String)"ExportToLibraryAction.wizard.page.label.folder");
    private static String BUTTON_BROWSER = Messages.getString((String)"ExportToLibraryAction.wizard.page.button.browser");
    private static String PLUGIN_ID = "org.eclipse.birt.report.designer.internal.ui.wizards.ExportReportWizardPage";
    private static String PAGE_TITLE = Messages.getString((String)"ExportToLibraryAction.wizard.page.title");
    private static String PAGE_DESC = Messages.getString((String)"ExportToLibraryAction.wizard.page.desc");
    Status nameStatus;
    Status folderStatus;
    private Text nameText;
    private Text folderText;
    private Button browserButton;

    public ExportReportWizardPage(String pageName) {
        super(pageName);
        this.setTitle(PAGE_TITLE);
        this.setMessage(PAGE_DESC);
        this.nameStatus = new Status(0, PLUGIN_ID, 0, PAGE_DESC, null);
        this.folderStatus = new Status(0, PLUGIN_ID, 0, PAGE_DESC, null);
    }

    public ExportReportWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setTitle(PAGE_TITLE);
        this.setMessage(PAGE_DESC);
        this.nameStatus = new Status(0, PLUGIN_ID, 0, PAGE_DESC, null);
        this.folderStatus = new Status(0, PLUGIN_ID, 0, PAGE_DESC, null);
    }

    public void createControl(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ExportToLibrary_ID");
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        new Label(container, 0).setText(LABEL_FILE_NAME);
        this.nameText = this.createText(container, 1);
        this.nameText.addListener(24, (Listener)this);
        new Label(container, 0);
        new Label(container, 0).setText(LABEL_FOLDER);
        this.folderText = this.createText(container, 1);
        this.folderText.setText(ReportPlugin.getDefault().getResourcePreference());
        this.folderText.addListener(24, (Listener)this);
        this.browserButton = new Button(container, 8);
        this.browserButton.setText(BUTTON_BROWSER);
        this.browserButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selectedDirectory;
                DirectoryDialog dialog = new DirectoryDialog(UIUtil.getDefaultShell());
                dialog.setMessage(Messages.getString((String)"ExportToLibraryAction.wizard.page.dirdialog.message"));
                String dirName = Platform.getLocation().toString();
                if (dirName != null && dirName.trim().length() > 0) {
                    dialog.setFilterPath(dirName.trim());
                }
                if ((selectedDirectory = dialog.open()) != null) {
                    ExportReportWizardPage.this.folderText.setText(selectedDirectory);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)container);
    }

    private Text createText(Composite container, int column) {
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = column;
        Text text = new Text(container, 2052);
        text.setLayoutData((Object)gridData);
        return text;
    }

    private static boolean isTextEmpty(Text text) {
        String s = text.getText();
        return s == null || s.trim().length() <= 0;
    }

    public void handleEvent(Event event) {
        Status status = new Status(0, PLUGIN_ID, 0, PAGE_DESC, null);
        if (ExportReportWizardPage.isTextEmpty(this.nameText)) {
            status = new Status(4, PLUGIN_ID, 0, Messages.getString((String)"ExportToLibraryAction.wizard.page.nameempty"), null);
        }
        this.nameStatus = status;
        status = new Status(0, PLUGIN_ID, 0, PAGE_DESC, null);
        if (ExportReportWizardPage.isTextEmpty(this.folderText)) {
            status = new Status(4, PLUGIN_ID, 0, Messages.getString((String)"ExportToLibraryAction.wizard.page.folderempty"), null);
        } else {
            File file = new File(this.folderText.getText().trim());
            if (!file.exists()) {
                status = new Status(4, PLUGIN_ID, 0, Messages.getString((String)"ExportToLibraryAction.wizard.page.foldererror"), null);
            }
        }
        this.folderStatus = status;
        this.applyToStatusLine(this.findMostSevere());
        this.getWizard().getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        return this.nameText.getText().trim().length() > 0 && this.folderText.getText().trim().length() > 0 && this.nameStatus.getSeverity() == 0 && this.folderStatus.getSeverity() == 0;
    }

    private IStatus findMostSevere() {
        if (this.nameStatus.matches(4)) {
            return this.nameStatus;
        }
        if (this.folderStatus.matches(4)) {
            return this.folderStatus;
        }
        return this.nameStatus;
    }

    private void applyToStatusLine(IStatus status) {
        String message = status.getMessage();
        if (message.length() == 0) {
            message = PAGE_DESC;
        }
        switch (status.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(message);
                break;
            }
            case 4: {
                this.setErrorMessage(message);
                this.setMessage(message, 3);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(message, 2);
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(message, 1);
                break;
            }
            default: {
                this.setErrorMessage(message);
                this.setMessage(null);
            }
        }
    }

    public String getFullName() {
        String name = this.nameText.getText().trim();
        String folder = this.folderText.getText().trim();
        if (!folder.endsWith(File.separator)) {
            folder = folder + File.separator;
        }
        return folder + name;
    }
}

